/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.client.gui;

import com.bewitchment.api.registry.Tarot;
import com.bewitchment.common.block.tile.container.ContainerTarotTable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiTarotTable
extends GuiContainer {
    private static final ResourceLocation TEX = new ResourceLocation("bewitchment", "textures/gui/tarot_table.png");
    private static final ResourceLocation TEX_FRAME = new ResourceLocation("bewitchment", "textures/gui/tarot/frame.png");
    private static final ResourceLocation TEX_FRAME_NUMBER = new ResourceLocation("bewitchment", "textures/gui/tarot/frame_number.png");
    private final ContainerTarotTable container;

    public GuiTarotTable(ContainerTarotTable container) {
        super((Container)container);
        this.container = container;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(TEX);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int i = 0; i < this.container.toRead.size(); ++i) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            Tarot tarot = this.container.toRead.get(i);
            this.field_146297_k.func_110434_K().func_110577_a(tarot.texture);
            int cx = x + (i % 2 == 0 ? 48 : 126);
            int cy = y + (i / 2 == 0 ? 44 : 122);
            GlStateManager.func_179094_E();
            if (tarot.isReversed(this.container.player)) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.drawCard(-cx, -cy, 48, 64);
            } else {
                this.drawCard(cx, cy, 48, 64);
            }
            GlStateManager.func_179121_F();
            this.field_146297_k.func_110434_K().func_110577_a(tarot.getNumber(this.container.player) < 0 ? TEX_FRAME : TEX_FRAME_NUMBER);
            this.drawCard(cx, cy, 50, 66);
            GlStateManager.func_179121_F();
            if (tarot.getNumber(this.container.player) <= -1) continue;
            int num = tarot.getNumber(this.container.player);
            String number = num > 99 ? "99+" : "" + num;
            this.func_73732_a(this.field_146297_k.field_71466_p, number, cx, cy + 24, 0x7F7F7F);
        }
    }

    private void drawCard(int xCenter, int yCenter, int sizeX, int sizeY) {
        Tessellator tessellator = Tessellator.func_178181_a();
        int xStart = xCenter - sizeX / 2;
        int xEnd = xCenter + sizeX / 2;
        int yStart = yCenter - sizeY / 2;
        int yEnd = yCenter + sizeY / 2;
        BufferBuilder buff = tessellator.func_178180_c();
        buff.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buff.func_181662_b((double)xStart, (double)yEnd, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buff.func_181662_b((double)xEnd, (double)yEnd, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buff.func_181662_b((double)xEnd, (double)yStart, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buff.func_181662_b((double)xStart, (double)yStart, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }
}

