/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.block;

import com.bewitchment.Util;
import com.bewitchment.api.registry.Ritual;
import com.bewitchment.common.block.tile.entity.TileEntityGlyph;
import com.bewitchment.common.block.tile.entity.util.ModTileEntity;
import com.bewitchment.common.block.util.ModBlockContainer;
import com.bewitchment.registry.ModObjects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGlyph
extends ModBlockContainer {
    public static final PropertyInteger TYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)4);
    private static final PropertyInteger LETTER = PropertyInteger.func_177719_a((String)"letter", (int)0, (int)5);
    private static final AxisAlignedBB BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0025, 1.0);
    public static final int GOLDEN = 0;
    public static final int NORMAL = 1;
    public static final int NETHER = 2;
    public static final int ENDER = 3;
    public static final int ANY = 4;

    public BlockGlyph() {
        super(null, "glyph", Material.field_151594_q, SoundType.field_185851_d, 5.0f, 100.0f, "", -1);
        this.func_149647_a(null);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityGlyph();
    }

    public boolean hasTileEntity(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TYPE) == 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BOX;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return null;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.OPEN;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult result, World world, BlockPos pos, EntityPlayer player) {
        int type = (Integer)state.func_177229_b((IProperty)TYPE);
        return new ItemStack(type == 1 ? ModObjects.ritual_chalk : (type == 0 ? ModObjects.focal_chalk : (type == 2 ? ModObjects.fiery_chalk : ModObjects.phasing_chalk)));
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && world.func_180495_p(pos.func_177977_b()).func_193401_d((IBlockAccess)world, pos, EnumFacing.UP) == BlockFaceShape.SOLID;
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() != this || (Integer)world.func_180495_p(pos).func_177229_b((IProperty)TYPE) != 0;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (world.func_175625_s(pos) instanceof ModTileEntity) {
            return ((ModTileEntity)world.func_175625_s(pos)).activate(world, pos, player, hand, face);
        }
        return super.func_180639_a(world, pos, state, player, hand, face, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        int type = (Integer)state.func_177229_b((IProperty)TYPE);
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.05;
        double z = (double)pos.func_177952_p() + 0.5;
        if (type == 2) {
            world.func_175688_a(EnumParticleTypes.FLAME, x + rand.nextGaussian() / 3.0, y, z + rand.nextGaussian() / 3.0, 0.0, 0.0, 0.0, new int[0]);
        }
        if (type == 3) {
            world.func_175688_a(EnumParticleTypes.PORTAL, x + rand.nextGaussian() / 3.0, y, z + rand.nextGaussian() / 3.0, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos to, Block block, BlockPos from) {
        world.func_175684_a(to, (Block)this, 0);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_175625_s(pos) instanceof TileEntityGlyph) {
            TileEntityGlyph tile = (TileEntityGlyph)world.func_175625_s(pos);
            if (tile.casterId != null) {
                tile.caster = Util.findPlayer(tile.casterId);
            }
            tile.syncToClient();
        }
        if (world.func_180495_p(pos.func_177977_b()).func_193401_d((IBlockAccess)world, pos, EnumFacing.UP) != BlockFaceShape.SOLID) {
            world.func_175655_b(pos, true);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)LETTER, (Comparable)Integer.valueOf(Math.abs(pos.func_177958_n() + pos.func_177952_p() * 2) % 6));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(meta & 3)).func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.field_176754_o[meta >> 2 & 3]);
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TYPE) | ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176736_b() << 2;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, BlockHorizontal.field_185512_D, LETTER});
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (!living.field_70170_p.field_72995_K) {
            BlockPos pos = living.func_180425_c();
            EntityPlayer player = living.field_70170_p.func_184137_a(living.field_70165_t, living.field_70163_u, living.field_70161_v, 10.0, false);
            if (player != null) {
                for (BlockPos pos0 : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-2, -2, -2), (BlockPos)pos.func_177982_a(2, 2, 2))) {
                    if (!(living.field_70170_p.func_175625_s(pos0) instanceof TileEntityGlyph)) continue;
                    TileEntityGlyph tile = (TileEntityGlyph)living.field_70170_p.func_175625_s(pos0);
                    Ritual ritual = GameRegistry.findRegistry(Ritual.class).getValuesCollection().stream().filter(r -> r.matches(living.field_70170_p, pos0, tile.getInventories()[0])).findFirst().orElse(null);
                    if (ritual == null || ritual.sacrificePredicate == null || !ritual.sacrificePredicate.test(living)) continue;
                    tile.startRitual(player, ritual);
                }
            }
        }
    }
}

