/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.block;

import com.bewitchment.api.capability.magicpower.MagicPower;
import com.bewitchment.common.block.tile.entity.TileEntityPlacedItem;
import com.bewitchment.common.block.tile.entity.TileEntityWitchesAltar;
import com.bewitchment.common.block.util.ModBlockContainer;
import com.bewitchment.registry.ModObjects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWitchesAltar
extends ModBlockContainer {
    public static final PropertyInteger TYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)2);
    public static final PropertyInteger COLOR = PropertyInteger.func_177719_a((String)"color", (int)0, (int)16);
    private final BlockPattern altarPattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"AAAAA", "ABBBA", "ABBBA", "AAAAA"}).func_177662_a('A', s -> s != null && !(s.func_177509_a().func_177230_c() instanceof BlockWitchesAltar)).func_177662_a('B', s -> s != null && s.func_177509_a().func_177230_c() == this).func_177661_b();

    public BlockWitchesAltar(String name, Block base) {
        super(null, name, base, -1);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)COLOR, (Comparable)Integer.valueOf(0)));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return meta == 2 ? new TileEntityWitchesAltar() : null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.SOLID;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            BlockPos pos0 = pos.func_177972_a(face);
            IBlockState state = world.func_180495_p(pos0);
            if (state.func_177230_c() instanceof BlockWitchesAltar && (Integer)state.func_177229_b((IProperty)TYPE) > 0) {
                return false;
            }
            if (face.func_176740_k() == EnumFacing.Axis.Y || !((state = world.func_180495_p(pos0.func_177972_a(face.func_176746_e()))).func_177230_c() instanceof BlockWitchesAltar) || (Integer)state.func_177229_b((IProperty)TYPE) <= 0) continue;
            return false;
        }
        return super.func_176196_c(world, pos);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    @Override
    public boolean func_149730_j(IBlockState state) {
        return true;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (this.altarPattern.func_177681_a(world, pos) != null) {
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_190926_b()) {
                TileEntityWitchesAltar tile = BlockWitchesAltar.getAltar((IBlockAccess)world, pos);
                if (tile != null) {
                    MagicPower cap = tile.getCapability(MagicPower.CAPABILITY, null);
                    if (!world.field_72995_K) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("altar.power_info", new Object[]{cap.amount, cap.maxAmount, tile.gain}), true);
                    }
                }
            } else if (face == EnumFacing.UP) {
                if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150404_cg)) {
                    TileEntityWitchesAltar tile = BlockWitchesAltar.getAltar((IBlockAccess)world, pos);
                    ItemStack carpet = ItemStack.field_190927_a;
                    if (tile != null) {
                        carpet = new ItemStack(Blocks.field_150404_cg, 1, tile.color - 1);
                    }
                    if (this.createAltar(world, pos, stack.func_77960_j() + 1)) {
                        if (!player.func_184812_l_()) {
                            stack.func_190918_g(1);
                        }
                        if (!world.field_72995_K && !carpet.func_190926_b()) {
                            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)((double)pos.func_177956_o() + 0.75), (double)pos.func_177952_p(), (ItemStack)carpet);
                        }
                        return true;
                    }
                } else {
                    if (stack.func_77973_b() instanceof ItemBlock || stack.func_77973_b() instanceof ItemSkull) {
                        return false;
                    }
                    if (world.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a())) {
                        world.func_175656_a(pos.func_177984_a(), ModObjects.placed_item.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.func_176733_a((double)player.field_70177_z)));
                        if (world.func_175625_s(pos.func_177984_a()) instanceof TileEntityPlacedItem) {
                            ((TileEntityPlacedItem)world.func_175625_s(pos.func_177984_a())).getInventories()[0].insertItem(0, stack.func_77979_a(1), false);
                        }
                        this.forceScan(world, pos);
                        return true;
                    }
                }
            }
            return false;
        }
        return super.func_180639_a(world, pos, state, player, hand, face, hitX, hitY, hitZ);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        for (EnumFacing face : EnumFacing.field_176754_o) {
            int type;
            BlockPos offset = pos.func_177972_a(face);
            if (!(world.func_180495_p(offset).func_177230_c() instanceof BlockWitchesAltar) || (type = ((Integer)world.func_180495_p(offset).func_177229_b((IProperty)TYPE)).intValue()) <= 0) continue;
            world.func_175656_a(offset, this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(0)));
            if (type == 2) {
                BlockWitchesAltar.refreshNearby((IBlockAccess)world, pos);
            }
            this.func_180663_b(world, offset, world.func_180495_p(offset));
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos to, Block block, BlockPos from) {
        super.func_189540_a(state, world, to, block, from);
        this.forceScan(world, to);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityWitchesAltar tile = BlockWitchesAltar.getAltar(world, pos);
        return tile == null ? state : state.func_177226_a((IProperty)COLOR, (Comparable)Integer.valueOf(tile.color));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TYPE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, COLOR});
    }

    public static TileEntityWitchesAltar getAltar(IBlockAccess world, BlockPos pos) {
        for (BlockPos pos0 : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 0, 1))) {
            TileEntity tile = world.func_175625_s(pos0);
            if (!(tile instanceof TileEntityWitchesAltar)) continue;
            return (TileEntityWitchesAltar)tile;
        }
        return null;
    }

    public static BlockPos getNearestAltarPos(IBlockAccess world, BlockPos pos) {
        TileEntityWitchesAltar altar;
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockWitchesAltar && (altar = BlockWitchesAltar.getAltar(world, pos)) != null) {
            return altar.func_174877_v();
        }
        int radius = 24;
        for (BlockPos pos0 : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-radius, -radius, -radius), (BlockPos)pos.func_177982_a(radius, radius, radius))) {
            TileEntityWitchesAltar altar2;
            if (!(world.func_180495_p(pos0).func_177230_c() instanceof BlockWitchesAltar) || (altar2 = BlockWitchesAltar.getAltar(world, pos0)) == null) continue;
            return altar2.func_174877_v();
        }
        return null;
    }

    private static void refreshNearby(IBlockAccess world, BlockPos pos) {
        int radius = 24;
        for (BlockPos pos0 : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-radius, -radius, -radius), (BlockPos)pos.func_177982_a(radius, radius, radius))) {
            Block block = world.func_180495_p(pos0).func_177230_c();
            if (!(block instanceof ModBlockContainer)) continue;
            ((ModBlockContainer)block).refreshAltarPos(world, pos0);
        }
    }

    public boolean createAltar(World world, BlockPos pos, int color) {
        BlockPattern.PatternHelper helper = this.altarPattern.func_177681_a(world, pos);
        if (helper != null) {
            for (int i = 1; i < helper.func_181118_d() - 1; ++i) {
                for (int j = 1; j < helper.func_181119_e() - 1; ++j) {
                    BlockPos pos0 = helper.func_177670_a(i, j, 0).func_177508_d();
                    if (!(world.func_180495_p(pos0).func_177230_c() instanceof BlockWitchesAltar)) continue;
                    world.func_180501_a(pos0, world.func_180495_p(pos0).func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(i == 2 && j == 2 ? 2 : 1)), 2);
                    TileEntity tile = world.func_175625_s(pos0);
                    if (!(tile instanceof TileEntityWitchesAltar)) continue;
                    TileEntityWitchesAltar altar = (TileEntityWitchesAltar)tile;
                    altar.color = color;
                    altar.syncToClient();
                    BlockWitchesAltar.refreshNearby((IBlockAccess)world, pos0);
                }
            }
            return true;
        }
        return false;
    }

    private void forceScan(World world, BlockPos pos) {
        TileEntityWitchesAltar tile = BlockWitchesAltar.getAltar((IBlockAccess)world, pos);
        if (tile != null) {
            tile.forceScan();
        }
    }
}

