/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.block.tile.entity;

import com.bewitchment.Util;
import com.bewitchment.api.BewitchmentAPI;
import com.bewitchment.api.capability.extendedplayer.ExtendedPlayer;
import com.bewitchment.api.capability.magicpower.MagicPower;
import com.bewitchment.api.registry.Fortune;
import com.bewitchment.common.block.tile.entity.util.TileEntityAltarStorage;
import com.bewitchment.common.item.ItemTaglock;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileEntityCrystalBall
extends TileEntityAltarStorage {
    @Override
    public boolean activate(World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing face) {
        if (!world.field_72995_K) {
            if (player.func_184586_b(hand).func_77973_b() instanceof ItemTaglock) {
                if (MagicPower.attemptDrain(this.altarPos != null ? world.func_175625_s(this.altarPos) : null, player, 1000)) {
                    NBTTagCompound tag = player.func_184586_b(hand).func_77978_p();
                    if (tag != null && tag.func_74764_b("boundId")) {
                        if (Util.findPlayer(UUID.fromString(tag.func_74779_i("boundId"))) != null) {
                            this.sendTarotMsg(player, UUID.fromString(tag.func_74779_i("boundId")));
                        } else {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.player_offline", new Object[]{tag.func_74779_i("boundName")}), true);
                        }
                    } else {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.no_player", new Object[0]), true);
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("altar.no_power", new Object[0]), true);
                }
            } else if (MagicPower.attemptDrain(this.altarPos != null ? world.func_175625_s(this.altarPos) : null, player, 750)) {
                ExtendedPlayer cap = (ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null);
                if (cap.fortune == null) {
                    List valid = GameRegistry.findRegistry(Fortune.class).getValuesCollection().stream().filter(f -> f.isValid(player)).collect(Collectors.toList());
                    if (!valid.isEmpty()) {
                        cap.fortune = (Fortune)((Object)valid.get(player.func_70681_au().nextInt(valid.size())));
                        cap.fortuneTime = player.func_70681_au().nextInt(cap.fortune.maxTime - cap.fortune.minTime) + cap.fortune.minTime;
                        ExtendedPlayer.syncToClient(player);
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("fortune." + cap.fortune.getRegistryName().toString().replace(":", "."), new Object[0]), true);
                    } else {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("fortune.no_fortune", new Object[0]), true);
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("fortune.has_fortune", new Object[]{player.func_145748_c_(), new TextComponentTranslation("fortune." + cap.fortune.getRegistryName().toString().replace(":", "."), new Object[0]).func_150254_d()}), true);
                }
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("altar.no_power", new Object[0]), true);
            }
        }
        return true;
    }

    private void sendTarotMsg(EntityPlayer player, UUID uuid) {
        EntityPlayer tagPlayer = Util.findPlayer(uuid);
        ExtendedPlayer cap = (ExtendedPlayer)tagPlayer.getCapability(ExtendedPlayer.CAPABILITY, null);
        switch (tagPlayer.func_70681_au().nextInt(11)) {
            case 0: {
                if (BewitchmentAPI.isWitchHunter((EntityLivingBase)tagPlayer)) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.is_hunter", new Object[]{tagPlayer.func_145748_c_()}), true);
                    break;
                }
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.not_hunter", new Object[]{tagPlayer.func_145748_c_()}), true);
                break;
            }
            case 1: {
                if (BewitchmentAPI.isSpectre((EntityLivingBase)tagPlayer)) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.is_spectre", new Object[]{tagPlayer.func_145748_c_()}), true);
                    break;
                }
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.not_spectre", new Object[]{tagPlayer.func_145748_c_()}), true);
                break;
            }
            case 2: {
                if (BewitchmentAPI.isVampire((EntityLivingBase)tagPlayer)) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.is_vampire", new Object[]{tagPlayer.func_145748_c_()}), true);
                    break;
                }
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.not_vampire", new Object[]{tagPlayer.func_145748_c_()}), true);
                break;
            }
            case 3: {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.no_tarot", new Object[]{tagPlayer.func_145748_c_()}), true);
                break;
            }
            case 4: {
                if (BewitchmentAPI.isWerewolf((EntityLivingBase)tagPlayer)) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.is_wolf", new Object[]{tagPlayer.func_145748_c_()}), true);
                    break;
                }
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.not_wolf", new Object[]{tagPlayer.func_145748_c_()}), true);
                break;
            }
            case 5: {
                if (BewitchmentAPI.isInfused(tagPlayer)) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.is_infused", new Object[]{tagPlayer.func_145748_c_()}), true);
                    break;
                }
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.not_infused", new Object[]{tagPlayer.func_145748_c_()}), true);
                break;
            }
            case 6: {
                if (cap.fortune != null) {
                    if (cap.fortune.isNegative) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.bad_fortune", new Object[]{tagPlayer.func_145748_c_()}), true);
                        break;
                    }
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.good_fortune", new Object[]{tagPlayer.func_145748_c_()}), true);
                    break;
                }
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.no_fortune", new Object[]{tagPlayer.func_145748_c_()}), true);
                break;
            }
            case 7: {
                if (BewitchmentAPI.hasPoppets(tagPlayer)) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.is_protected", new Object[]{tagPlayer.func_145748_c_()}), true);
                    break;
                }
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.not_protected", new Object[]{tagPlayer.func_145748_c_()}), true);
                break;
            }
            case 8: {
                if (BewitchmentAPI.hasEffects(tagPlayer)) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.has_effect", new Object[]{tagPlayer.func_145748_c_()}), true);
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.no_effect", new Object[]{tagPlayer.func_145748_c_()}), true);
                }
            }
            case 9: {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.mobkills", new Object[]{tagPlayer.func_145748_c_(), cap.mobsKilled}), true);
                break;
            }
            case 10: {
                if (BewitchmentAPI.defeatedBoss(tagPlayer)) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.has_boss", new Object[]{tagPlayer.func_145748_c_()}), true);
                    break;
                }
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tarot.no_boss", new Object[]{tagPlayer.func_145748_c_()}), true);
            }
        }
    }
}

