/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.block.tile.entity;

import com.bewitchment.Bewitchment;
import com.bewitchment.Util;
import com.bewitchment.api.capability.extendedplayer.ExtendedPlayer;
import com.bewitchment.api.capability.magicpower.MagicPower;
import com.bewitchment.api.message.SpawnParticle;
import com.bewitchment.api.registry.Ritual;
import com.bewitchment.common.block.tile.entity.util.TileEntityAltarStorage;
import com.bewitchment.registry.ModObjects;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityGlyph
extends TileEntityAltarStorage
implements ITickable {
    private final ItemStackHandler inventory = new ItemStackHandler(12){

        protected void onContentsChanged(int slot) {
            TileEntityGlyph.this.syncToClient();
        }
    };
    public Ritual ritual;
    public UUID casterId;
    public EntityPlayer caster;
    public BlockPos effectivePos;
    public int effectiveDim;
    public int time;

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74778_a("ritual", this.ritual == null ? "" : this.ritual.getRegistryName().toString());
        tag.func_74772_a("effectivePos", this.effectivePos == null ? 0L : this.effectivePos.func_177986_g());
        tag.func_74768_a("effectiveDim", this.effectiveDim);
        tag.func_74778_a("casterId", this.casterId == null ? "" : this.casterId.toString());
        tag.func_74768_a("time", this.time);
        return super.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.ritual = tag.func_74779_i("ritual").isEmpty() ? null : (Ritual)GameRegistry.findRegistry(Ritual.class).getValue(new ResourceLocation(tag.func_74779_i("ritual")));
        this.effectivePos = BlockPos.func_177969_a((long)tag.func_74763_f("effectivePos"));
        this.effectiveDim = tag.func_74762_e("effectiveDim");
        this.casterId = tag.func_74779_i("casterId").isEmpty() ? null : UUID.fromString(tag.func_74779_i("casterId"));
        this.time = tag.func_74762_e("time");
        super.func_145839_a(tag);
    }

    @Override
    public ItemStackHandler[] getInventories() {
        return new ItemStackHandler[]{this.inventory};
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        boolean flag = super.shouldRefresh(world, pos, oldState, newState);
        if (!world.field_72995_K && flag) {
            this.stopRitual(false);
        }
        return flag;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.ritual != null) {
            for (BlockPos pos0 : new BlockPos[]{this.field_174879_c, this.effectivePos}) {
                if (this.field_145850_b.field_73012_v.nextInt(16) != 0) continue;
                Bewitchment.network.sendToDimension((IMessage)new SpawnParticle(EnumParticleTypes.END_ROD, (double)pos0.func_177958_n() + 0.5, (double)pos0.func_177956_o() + 0.5, (double)pos0.func_177952_p() + 0.5), this.effectiveDim);
            }
            if (this.caster != null) {
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    if (!MagicPower.attemptDrain(this.altarPos != null ? this.field_145850_b.func_175625_s(this.altarPos) : null, this.caster, this.ritual.runningPower)) {
                        this.stopRitual(false);
                        return;
                    }
                    ++this.time;
                }
                this.ritual.onUpdate(this.field_145850_b, this.field_174879_c, this.effectivePos, this.caster, this.inventory);
            }
            if (this.ritual.time >= 0 && this.time >= this.ritual.time) {
                this.stopRitual(true);
            }
        }
    }

    @Override
    public boolean activate(World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing face) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                int last = TileEntityGlyph.getLastNonEmptySlot(this.inventory);
                if (last > -1) {
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)this.inventory.extractItem(last, this.inventory.getStackInSlot(last).func_190916_E(), false));
                }
            } else {
                ItemStack stack = player.func_184586_b(hand);
                if (this.ritual == null) {
                    if (!stack.func_190926_b()) {
                        int slot = TileEntityGlyph.getFirstEmptySlot(this.inventory);
                        if (slot < 10 && slot > -1) {
                            this.inventory.insertItem(slot, stack.func_77979_a(1), false);
                        }
                    } else {
                        Ritual rit = GameRegistry.findRegistry(Ritual.class).getValuesCollection().stream().filter(r -> r.matches(world, pos, this.inventory)).findFirst().orElse(null);
                        if (rit != null) {
                            if (rit.isValid(world, pos, player, this.inventory)) {
                                this.startRitual(player, rit);
                            } else {
                                player.func_146105_b((ITextComponent)new TextComponentTranslation(rit.getPreconditionMessage(), new Object[0]), true);
                            }
                        } else {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("ritual.null", new Object[0]), true);
                        }
                    }
                } else if (stack.func_77973_b() == ModObjects.waystone && stack.func_77942_o() && stack.func_77978_p().func_74764_b("location")) {
                    if (this.ritual.canBePerformedRemotely) {
                        this.effectivePos = BlockPos.func_177969_a((long)stack.func_77978_p().func_74763_f("location"));
                        this.effectiveDim = stack.func_77978_p().func_74762_e("dimension");
                        stack.func_77972_a(1, (EntityLivingBase)player);
                        this.syncToClient();
                    }
                } else {
                    this.stopRitual(false);
                }
            }
        }
        return true;
    }

    public void startRitual(EntityPlayer player, Ritual rit) {
        if (!player.field_70170_p.field_72995_K) {
            if (MagicPower.attemptDrain(this.altarPos != null ? this.field_145850_b.func_175625_s(this.altarPos) : null, player, rit.startingPower)) {
                this.ritual = rit;
                ++((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).ritualsCast;
                ExtendedPlayer.syncToClient(player);
                this.casterId = player.func_146103_bH().getId();
                this.caster = Util.findPlayer(this.casterId);
                this.effectivePos = this.field_174879_c;
                this.effectiveDim = this.field_145850_b.field_73011_w.getDimension();
                this.time = 0;
                this.ritual.onStarted(this.field_145850_b, this.field_174879_c, player, this.inventory);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("ritual." + this.ritual.getRegistryName().toString().replace(":", "."), new Object[0]), true);
                this.syncToClient();
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("altar.no_power", new Object[0]), true);
            }
        }
    }

    public void stopRitual(boolean finished) {
        if (!this.field_145850_b.field_72995_K) {
            if (this.ritual != null && this.caster != null) {
                if (finished) {
                    this.ritual.onFinished(this.field_145850_b, this.field_174879_c, this.effectivePos, this.caster, this.inventory);
                } else {
                    this.ritual.onHalted(this.field_145850_b, this.field_174879_c, this.effectivePos, this.caster, this.inventory);
                }
            }
            this.ritual = null;
            this.casterId = null;
            this.caster = null;
            this.effectivePos = this.field_174879_c;
            this.effectiveDim = this.field_145850_b.field_73011_w.getDimension();
            this.time = 0;
            this.syncToClient();
        }
    }
}

