/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.block.tile.entity;

import com.bewitchment.Bewitchment;
import com.bewitchment.Util;
import com.bewitchment.api.capability.magicpower.MagicPower;
import com.bewitchment.api.message.SpawnBubble;
import com.bewitchment.api.message.SpawnParticle;
import com.bewitchment.api.registry.Brew;
import com.bewitchment.api.registry.CauldronRecipe;
import com.bewitchment.common.block.tile.entity.util.TileEntityAltarStorage;
import com.bewitchment.registry.ModObjects;
import com.bewitchment.registry.ModPotions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGlassBottle;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityWitchesCauldron
extends TileEntityAltarStorage
implements ITickable,
IWorldNameable {
    private static final AxisAlignedBB collectionZone = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.65, 1.0);
    private final ItemStackHandler inventory = new ItemStackHandler(127);
    public final FluidTank tank = new FluidTank(1000);
    public int mode = 0;
    private static final int[] defaultColor = new int[]{0, 63, 255};
    public int[] color = new int[]{defaultColor[0], defaultColor[1], defaultColor[2]};
    private int[] targetColor = new int[]{defaultColor[0], defaultColor[1], defaultColor[2]};
    private int heatTimer = 0;
    private int craftingTimer = 0;
    private boolean hasPower;
    private String name = "";

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        tag.func_74768_a("mode", this.mode);
        tag.func_74783_a("color", this.color);
        tag.func_74783_a("targetColor", this.targetColor);
        tag.func_74768_a("heatTimer", this.heatTimer);
        tag.func_74768_a("craftingTimer", this.craftingTimer);
        tag.func_74757_a("hasPower", this.hasPower);
        tag.func_74778_a("name", this.name);
        return super.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        this.mode = tag.func_74762_e("mode");
        this.color = tag.func_74759_k("color");
        this.targetColor = tag.func_74759_k("targetColor");
        this.heatTimer = tag.func_74762_e("heatTimer");
        this.craftingTimer = tag.func_74762_e("craftingTimer");
        this.hasPower = tag.func_74767_n("hasPower");
        this.name = tag.func_74764_b("name") ? tag.func_74779_i("name") : "";
        super.func_145839_a(tag);
    }

    @Override
    public ItemStackHandler[] getInventories() {
        return new ItemStackHandler[]{this.inventory};
    }

    public void func_73660_a() {
        if (this.color.length == 0 || this.targetColor.length == 0) {
            return;
        }
        if (this.mode == 2) {
            this.tank.drain(Math.min(32, this.tank.getFluidAmount()), true);
        }
        if (!this.field_145850_b.field_72995_K) {
            double height;
            boolean isLava;
            double height2;
            int i;
            if (this.color[0] != this.targetColor[0]) {
                for (i = 0; i < 6; ++i) {
                    this.color[0] = this.color[0] + (this.color[0] < this.targetColor[0] ? 1 : -1);
                }
            }
            if (this.color[1] != this.targetColor[1]) {
                for (i = 0; i < 6; ++i) {
                    this.color[1] = this.color[1] + (this.color[1] < this.targetColor[1] ? 1 : -1);
                }
            }
            if (this.color[2] != this.targetColor[2]) {
                for (i = 0; i < 6; ++i) {
                    this.color[2] = this.color[2] + (this.color[2] < this.targetColor[2] ? 1 : -1);
                }
            }
            if (this.mode > 2) {
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    this.setPower();
                    if (this.mode == 5) {
                        ++this.craftingTimer;
                    }
                }
                if (this.mode != 4 && !this.hasPower || this.mode == 5 && this.craftingTimer >= 20) {
                    this.mode = 1;
                    this.craftingTimer = 0;
                    this.setTargetColor(0x604040);
                }
            }
            if (this.mode == 4 && (height2 = (double)this.field_174879_c.func_177956_o() + this.getLiquidHeight()) > (double)this.field_174879_c.func_177956_o() + 0.2) {
                for (int i2 = 0; i2 < 6; ++i2) {
                    Bewitchment.network.sendToDimension((IMessage)new SpawnParticle(EnumParticleTypes.REDSTONE, (double)this.func_174877_v().func_177958_n() + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.6, height2, (double)this.func_174877_v().func_177952_p() + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.6, (float)this.color[0] / 255.0f, (float)this.color[1] / 255.0f, (float)this.color[2] / 255.0f), this.field_145850_b.field_73011_w.getDimension());
                }
            }
            boolean bl = isLava = this.tank.getFluid() != null && this.tank.getFluid().getFluid().getTemperature() >= FluidRegistry.LAVA.getTemperature();
            if (isLava) {
                if (this.field_145850_b.field_73012_v.nextInt(100) == 0) {
                    this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f, 0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.15f);
                    Bewitchment.network.sendToDimension((IMessage)new SpawnParticle(EnumParticleTypes.LAVA, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5), this.field_145850_b.field_73011_w.getDimension());
                }
                if (this.field_145850_b.field_73012_v.nextInt(200) == 0) {
                    this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f, 0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.15f);
                }
            }
            for (EntityLivingBase living : this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.func_174877_v()))) {
                if (isLava) {
                    living.func_70097_a(DamageSource.field_76371_c, 4.0f);
                    living.func_70015_d(15);
                    continue;
                }
                living.func_70066_B();
                if (this.mode == 4 || this.heatTimer < 5) continue;
                living.func_70097_a(DamageSource.field_190095_e, 1.0f);
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                if (this.tank.getFluid() != null && Bewitchment.config.heatSources.contains(this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c().func_149739_a()) && this.heatTimer <= 5) {
                    ++this.heatTimer;
                } else if (this.heatTimer > 0) {
                    --this.heatTimer;
                }
            }
            if (this.heatTimer >= 5 && this.tank.getFluid() != null && this.tank.getFluid().getFluid() != FluidRegistry.LAVA && (height = (double)this.field_174879_c.func_177956_o() + this.getLiquidHeight()) > (double)this.field_174879_c.func_177956_o() + 0.2) {
                for (int i3 = 0; i3 < 6; ++i3) {
                    Bewitchment.network.sendToDimension((IMessage)new SpawnBubble((double)this.func_174877_v().func_177958_n() + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.6, height, (double)this.func_174877_v().func_177952_p() + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.6, (float)this.color[0] / 255.0f, (float)this.color[1] / 255.0f, (float)this.color[2] / 255.0f), this.field_145850_b.field_73011_w.getDimension());
                }
            }
            if (this.tank.getFluidAmount() < 1) {
                this.mode = 0;
                this.resetColor();
                this.syncToClient();
            }
            if (this.mode != 2 && this.field_145850_b.func_82737_E() % 5L == 0L && (this.heatTimer >= 5 || isLava)) {
                this.insertNextItem(isLava);
            }
        }
    }

    @Override
    public boolean activate(World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing face) {
        if (!player.func_70093_af()) {
            if (!world.field_72995_K) {
                if (player.func_184586_b(hand).func_77973_b() == Items.field_151057_cb) {
                    this.name = player.func_184586_b(hand).func_82833_r();
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(hand).func_190918_g(1);
                    }
                } else if (this.mode == 0 || this.mode == 3) {
                    FluidBucketWrapper wrapper;
                    FluidStack fluid;
                    IFluidHandlerItem cap;
                    if (player.func_184586_b(hand).func_77973_b() instanceof ItemGlassBottle) {
                        if (this.tank.canDrainFluidType(this.tank.getFluid()) && this.tank.getFluid() != null && this.tank.getFluid().getFluid() != FluidRegistry.LAVA) {
                            Util.giveAndConsumeItem(player, hand, this.createPotion());
                            this.tank.drain(333, true);
                            world.func_184133_a(null, pos, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            if (this.tank.getFluidAmount() < 2) {
                                this.tank.drain(1000, true);
                                TileEntityWitchesCauldron.clear(this.inventory);
                            }
                        }
                    } else if (TileEntityWitchesCauldron.isEmpty(this.inventory) && player.func_184586_b(hand).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (cap = (IFluidHandlerItem)player.func_184586_b(hand).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) instanceof FluidBucketWrapper && ((fluid = (wrapper = (FluidBucketWrapper)cap).getFluid()) == null || fluid != null && (fluid.getFluid() == FluidRegistry.WATER || fluid.getFluid() == FluidRegistry.LAVA)) && FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)this.tank)) {
                        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 2);
                    }
                }
                this.syncToClient();
            }
            return true;
        }
        return false;
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return !this.func_70005_c_().isEmpty();
    }

    public static ItemStack createPotion(Collection<PotionEffect> effects, int arg) {
        ItemStack stack = arg == 1 ? new ItemStack((Item)Items.field_185155_bH) : (arg == 2 ? new ItemStack((Item)Items.field_185156_bI) : new ItemStack((Item)Items.field_151068_bn));
        PotionUtils.func_185184_a((ItemStack)stack, effects);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("CustomPotionColor", PotionUtils.func_185181_a(effects));
        stack.func_77978_p().func_74757_a("bewitchment_brew", true);
        return stack;
    }

    public double getLiquidHeight() {
        return ((double)this.tank.getFluidAmount() / 1000.0 - 1.0) * 0.4 + 0.6;
    }

    private ItemStack createPotion() {
        ArrayList<PotionEffect> finalEffects = new ArrayList<PotionEffect>();
        boolean noParticles = TileEntityWitchesCauldron.contains(this.inventory, new ItemStack(ModObjects.ravens_feather));
        boolean splash = TileEntityWitchesCauldron.contains(this.inventory, new ItemStack(Items.field_151016_H));
        boolean lingering = TileEntityWitchesCauldron.contains(this.inventory, new ItemStack(ModObjects.owlets_wing)) && splash;
        int duration = 1;
        int potency = 1;
        LinkedHashSet<PotionEffect> effects = new LinkedHashSet<PotionEffect>();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            for (Brew brew : GameRegistry.findRegistry(Brew.class).getValuesCollection()) {
                if (!brew.input.apply(this.inventory.getStackInSlot(i))) continue;
                effects.add(brew.effect);
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == Items.field_151137_ax) {
                ++duration;
                continue;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() != Items.field_151114_aO) continue;
            ++potency;
        }
        potency = Math.min(2, potency);
        duration = Math.min(3, duration);
        for (PotionEffect effect : effects) {
            finalEffects.add(new PotionEffect(effect.func_188419_a(), (int)((double)effect.func_76459_b() * (1.0 / (double)potency) * (double)duration), effect.func_76458_c() + potency - 1, effect.func_82720_e(), !noParticles));
        }
        ArrayList<PotionEffect> toBeginning = new ArrayList<PotionEffect>();
        for (int i = finalEffects.size() - 1; i >= 0; --i) {
            PotionEffect effect = (PotionEffect)finalEffects.get(i);
            if (effect.func_188419_a() != ModPotions.magic_resistance && effect.func_188419_a() != ModPotions.magic_weakness) continue;
            toBeginning.add(effect);
            finalEffects.remove(i);
        }
        for (PotionEffect effect : toBeginning) {
            finalEffects.add(0, effect);
        }
        ArrayList<PotionEffect> toEnd = new ArrayList<PotionEffect>();
        for (int i = finalEffects.size() - 1; i >= 0; --i) {
            PotionEffect effect = (PotionEffect)finalEffects.get(i);
            if (effect.func_188419_a() != ModPotions.absence && effect.func_188419_a() != ModPotions.purification && effect.func_188419_a() != ModPotions.corruption) continue;
            toEnd.add(effect);
            finalEffects.remove(i);
        }
        finalEffects.addAll(toEnd);
        return TileEntityWitchesCauldron.createPotion(finalEffects, lingering ? 2 : (splash ? 1 : 0));
    }

    private void insertNextItem(boolean isLava) {
        if (!this.field_145850_b.field_72995_K && this.tank.getFluid() != null) {
            List list = this.field_145850_b.func_72872_a(EntityItem.class, collectionZone.func_186670_a(this.func_174877_v()));
            if (!list.isEmpty()) {
                EntityItem entity = (EntityItem)list.get(0);
                ItemStack stack = entity.func_92059_d().func_77979_a(1);
                if (isLava) {
                    this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, (float)(0.2 * this.field_145850_b.field_73012_v.nextDouble()) + 1.0f);
                    stack.func_190918_g(stack.func_190916_E());
                } else {
                    this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 1.0f, (float)(0.2 * this.field_145850_b.field_73012_v.nextDouble()) + 1.0f);
                    if (stack.func_77973_b() == ModObjects.wood_ash) {
                        this.mode = 2;
                        TileEntityWitchesCauldron.clear(this.inventory);
                    } else {
                        int slot = TileEntityWitchesCauldron.getFirstEmptySlot(this.inventory);
                        if (slot > -1) {
                            this.setPower();
                            if (stack.func_77973_b() == ModObjects.mandrake_root && this.mode == 0) {
                                this.mode = 3;
                            } else if (stack.func_77973_b() == ModObjects.dimensional_sand && this.mode == 0) {
                                this.mode = 4;
                                this.setTargetColor(8373375);
                                TileEntityWitchesCauldron.clear(this.inventory);
                                return;
                            }
                            boolean valid = this.hasPower && this.mode != 4 && (this.mode != 3 || this.isBrewItem(stack)) && this.heatTimer >= 5;
                            this.inventory.insertItem(slot, stack, false);
                            if (valid) {
                                if (this.mode == 0) {
                                    this.mode = 5;
                                    this.craftingTimer = 0;
                                    this.setTargetColor(8323268);
                                }
                                if (this.mode == 5) {
                                    CauldronRecipe recipe = GameRegistry.findRegistry(CauldronRecipe.class).getValuesCollection().stream().filter(b -> b.matches(this.inventory)).findFirst().orElse(null);
                                    if (recipe != null) {
                                        for (ItemStack stack0 : recipe.output) {
                                            EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, stack0.func_77946_l());
                                            item.func_189654_d(true);
                                            item.field_70159_w = 0.0;
                                            item.field_70181_x = 0.0;
                                            item.field_70179_y = 0.0;
                                            this.field_145850_b.func_72838_d((Entity)item);
                                        }
                                        this.tank.drain(1000, true);
                                        TileEntityWitchesCauldron.clear(this.inventory);
                                    }
                                } else if (this.mode == 3) {
                                    this.setTargetColor(PotionUtils.func_190932_c((ItemStack)this.createPotion()));
                                    Brew brew = GameRegistry.findRegistry(Brew.class).getValuesCollection().stream().filter(b -> b.matches(stack)).findFirst().orElse(null);
                                    if (brew != null && brew.output != null && (brew.outputPredicate == null || brew.outputPredicate.test(stack))) {
                                        EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, brew.output.func_77946_l());
                                        item.func_189654_d(true);
                                        item.field_70159_w = 0.0;
                                        item.field_70181_x = 0.0;
                                        item.field_70179_y = 0.0;
                                        this.field_145850_b.func_72838_d((Entity)item);
                                    }
                                }
                            } else {
                                this.mode = 1;
                                this.setTargetColor(0x604040);
                            }
                        }
                    }
                }
            }
            this.syncToClient();
        }
    }

    private boolean isBrewItem(ItemStack stack) {
        for (Brew brew : GameRegistry.findRegistry(Brew.class).getValuesCollection()) {
            if (!brew.input.apply(stack)) continue;
            return true;
        }
        return stack.func_77973_b() == ModObjects.mandrake_root || stack.func_77973_b() == ModObjects.ravens_feather || stack.func_77973_b() == Items.field_151016_H || stack.func_77973_b() == ModObjects.owlets_wing || stack.func_77973_b() == Items.field_151137_ax || stack.func_77973_b() == Items.field_151114_aO;
    }

    private void setTargetColor(int color) {
        this.targetColor[0] = color >> 16 & 0xFF;
        this.targetColor[1] = color >> 8 & 0xFF;
        this.targetColor[2] = color & 0xFF;
    }

    private void resetColor() {
        this.color[0] = defaultColor[0];
        this.color[1] = defaultColor[1];
        this.color[2] = defaultColor[2];
        this.targetColor[0] = defaultColor[0];
        this.targetColor[1] = defaultColor[1];
        this.targetColor[2] = defaultColor[2];
    }

    private void setPower() {
        this.hasPower = MagicPower.attemptDrain(this.altarPos != null ? this.field_145850_b.func_175625_s(this.altarPos) : null, this.field_145850_b.func_184137_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 16.0, false), 16 * Math.max(0, TileEntityWitchesCauldron.getFirstEmptySlot(this.inventory)));
    }
}

