/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.world.gen;

import com.bewitchment.Bewitchment;
import com.bewitchment.common.world.gen.tree.WorldGenCypressTree;
import com.bewitchment.common.world.gen.tree.WorldGenElderTree;
import com.bewitchment.common.world.gen.tree.WorldGenJuniperTree;
import com.bewitchment.common.world.gen.tree.WorldGenYewTree;
import com.bewitchment.registry.ModObjects;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;

public class ModWorldGen
implements IWorldGenerator {
    private final WorldGenerator cypressTree = new WorldGenCypressTree(true);
    private final WorldGenerator elderTree = new WorldGenElderTree(true);
    private final WorldGenerator juniperTree = new WorldGenJuniperTree(true);
    private final WorldGenerator yewTree = new WorldGenYewTree(true);
    private final WorldGenerator silverOre;
    private final WorldGenerator saltOre;
    private final WorldGenerator amethystOre;
    private final WorldGenerator garnetOre;
    private final WorldGenerator opalOre;

    public ModWorldGen() {
        this.silverOre = new WorldGenMinable(ModObjects.silver_ore.func_176223_P(), Bewitchment.config.silverSize);
        this.saltOre = new WorldGenMinable(ModObjects.salt_ore.func_176223_P(), Bewitchment.config.saltSize);
        this.amethystOre = new WorldGenMinable(ModObjects.amethyst_ore.func_176223_P(), Bewitchment.config.amethystSize);
        this.garnetOre = new WorldGenMinable(ModObjects.garnet_ore.func_176223_P(), Bewitchment.config.garnetSize);
        this.opalOre = new WorldGenMinable(ModObjects.opal_ore.func_176223_P(), Bewitchment.config.opalSize);
        MinecraftForge.addGrassSeed((ItemStack)new ItemStack(ModObjects.aconitum_seeds), (int)3);
        MinecraftForge.addGrassSeed((ItemStack)new ItemStack(ModObjects.belladonna_seeds), (int)3);
        MinecraftForge.addGrassSeed((ItemStack)new ItemStack(ModObjects.hellebore_seeds), (int)3);
        MinecraftForge.addGrassSeed((ItemStack)new ItemStack(ModObjects.mandrake_seeds), (int)3);
        MinecraftForge.addGrassSeed((ItemStack)new ItemStack(ModObjects.wormwood_seeds), (int)3);
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("bewitchment", "chests/books"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("bewitchment", "chests/materials"));
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator generator, IChunkProvider provider) {
        if (Bewitchment.config.worldGenWhitelist.contains(world.field_73011_w.getDimension())) {
            this.generateCoquina(world, rand, chunkX, chunkZ);
            this.generateOre(world, rand, this.silverOre, chunkX, chunkZ, Bewitchment.config.silverChance, Bewitchment.config.silverMin, Bewitchment.config.silverMax);
            this.generateOre(world, rand, this.saltOre, chunkX, chunkZ, Bewitchment.config.saltChance, Bewitchment.config.saltMin, Bewitchment.config.saltMax);
            this.generateOre(world, rand, this.amethystOre, chunkX, chunkZ, Bewitchment.config.amethystChance, Bewitchment.config.amethystMin, Bewitchment.config.amethystMax);
            this.generateOre(world, rand, this.garnetOre, chunkX, chunkZ, Bewitchment.config.garnetChance, Bewitchment.config.garnetMin, Bewitchment.config.garnetMax);
            this.generateOre(world, rand, this.opalOre, chunkX, chunkZ, Bewitchment.config.opalChance, Bewitchment.config.opalMin, Bewitchment.config.opalMax);
            this.generateTree(world, rand, this.cypressTree, ModObjects.cypress_sapling, chunkX, chunkZ, Bewitchment.config.cypressChance, b -> BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && (BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)));
            this.generateTree(world, rand, this.elderTree, ModObjects.elder_sapling, chunkX, chunkZ, Bewitchment.config.elderChance, b -> BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && !BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.COLD));
            this.generateTree(world, rand, this.juniperTree, ModObjects.juniper_sapling, chunkX, chunkZ, Bewitchment.config.juniperChance, b -> BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA) || BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL));
            this.generateTree(world, rand, this.yewTree, ModObjects.yew_sapling, chunkX, chunkZ, Bewitchment.config.yewChance, b -> BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.DENSE));
        }
    }

    private void generateCoquina(World world, Random rand, int chunkX, int chunkZ) {
        if (rand.nextInt(6) == 0) {
            BlockPos pos = world.func_175645_m(new BlockPos(chunkX * 16 + rand.nextInt(16), 0, chunkZ * 16 + rand.nextInt(16)));
            if (BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.BEACH).contains(world.func_180494_b(pos)) || BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN).contains(world.func_180494_b(pos))) {
                while (world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150354_m) {
                    for (int i = 0; i < 3; ++i) {
                        int x = rand.nextInt(2);
                        int y = rand.nextInt(2);
                        int z = rand.nextInt(2);
                        for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-x, -y, -z), (BlockPos)pos.func_177982_a(x, y, z))) {
                            if (!(blockpos.func_177951_i((Vec3i)pos) <= Math.pow((float)(x + y + z) * 0.333f + 0.5f, 2.0))) continue;
                            world.func_180501_a(blockpos, ModObjects.coquina[0].func_176223_P(), 2);
                        }
                        pos = pos.func_177982_a(rand.nextInt(2) - 1, -rand.nextInt(2), rand.nextInt(2) - 1);
                    }
                    pos = pos.func_177977_b();
                }
            }
        }
    }

    private void generateOre(World world, Random rand, WorldGenerator gen, int chunkX, int chunkZ, int chance, int minHeight, int maxHeight) {
        for (int i = 0; i < chance; ++i) {
            gen.func_180709_b(world, rand, new BlockPos(chunkX * 16, rand.nextInt(maxHeight - minHeight) + minHeight, chunkZ * 16));
        }
    }

    private void generateTree(World world, Random rand, WorldGenerator gen, Block block, int chunkX, int chunkZ, int chance, Predicate<Biome> predicate) {
        int z;
        int x;
        BlockPos pos;
        Biome biome;
        if (chance != 0 && rand.nextInt(chance) == 0 && predicate.test(biome = world.func_180494_b(pos = new BlockPos(x = chunkX * 16 + 8, world.func_189649_b(x, z = chunkZ * 16 + 8), z))) && block.func_176196_c(world, pos)) {
            gen.func_180709_b(world, rand, pos);
        }
    }
}

