/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.registry;

import com.bewitchment.Bewitchment;
import com.bewitchment.Util;
import com.bewitchment.api.BewitchmentAPI;
import com.bewitchment.api.capability.extendedplayer.ExtendedPlayer;
import com.bewitchment.api.registry.Brew;
import com.bewitchment.api.registry.CauldronRecipe;
import com.bewitchment.api.registry.DistilleryRecipe;
import com.bewitchment.api.registry.Fortune;
import com.bewitchment.api.registry.FrostfireRecipe;
import com.bewitchment.api.registry.OvenRecipe;
import com.bewitchment.api.registry.Ritual;
import com.bewitchment.api.registry.SpinningWheelRecipe;
import com.bewitchment.api.registry.Tarot;
import com.bewitchment.common.block.BlockCandleBase;
import com.bewitchment.common.block.plants.util.BlockBushSpreading;
import com.bewitchment.common.block.tile.entity.TileEntityIdol;
import com.bewitchment.common.entity.misc.ModEntityPotion;
import com.bewitchment.common.entity.misc.ModEntityTippedArrow;
import com.bewitchment.common.fortune.FortuneBadLuck;
import com.bewitchment.common.fortune.FortuneCatsAndDogs;
import com.bewitchment.common.fortune.FortuneDeath;
import com.bewitchment.common.fortune.FortuneDropItem;
import com.bewitchment.common.fortune.FortuneGoodLuck;
import com.bewitchment.common.fortune.FortuneIllness;
import com.bewitchment.common.fortune.FortuneMeetBlaze;
import com.bewitchment.common.fortune.FortuneMeetDemon;
import com.bewitchment.common.fortune.FortuneMeetDireWolf;
import com.bewitchment.common.fortune.FortuneMeetMerchant;
import com.bewitchment.common.fortune.FortuneMeetPet;
import com.bewitchment.common.fortune.FortuneMeetSerpent;
import com.bewitchment.common.fortune.FortuneMeetSilverfish;
import com.bewitchment.common.fortune.FortuneMeetWitch;
import com.bewitchment.common.fortune.FortuneMeetZombie;
import com.bewitchment.common.fortune.FortuneTreasure;
import com.bewitchment.common.fortune.FortuneVitality;
import com.bewitchment.common.item.tool.ItemGrimoireMagia;
import com.bewitchment.common.ritual.RitualCallOfTheWild;
import com.bewitchment.common.ritual.RitualConjureDemon;
import com.bewitchment.common.ritual.RitualConjureImp;
import com.bewitchment.common.ritual.RitualConjureWitch;
import com.bewitchment.common.ritual.RitualConjureWither;
import com.bewitchment.common.ritual.RitualDeluge;
import com.bewitchment.common.ritual.RitualDrawing;
import com.bewitchment.common.ritual.RitualFrenziedGrowth;
import com.bewitchment.common.ritual.RitualGreaterHellmouth;
import com.bewitchment.common.ritual.RitualHellmouth;
import com.bewitchment.common.ritual.RitualHighMoon;
import com.bewitchment.common.ritual.RitualHungryFlames;
import com.bewitchment.common.ritual.RitualLesserHellMouth;
import com.bewitchment.common.ritual.RitualPerception;
import com.bewitchment.common.ritual.RitualRevealing;
import com.bewitchment.common.ritual.RitualSandsOfTime;
import com.bewitchment.common.ritual.RitualSolarGlory;
import com.bewitchment.common.ritual.RitualSpiritualRift;
import com.bewitchment.common.ritual.RitualTeleport;
import com.bewitchment.common.ritual.RitualWednesday;
import com.bewitchment.registry.ModEnchantments;
import com.bewitchment.registry.ModEntities;
import com.bewitchment.registry.ModObjects;
import com.bewitchment.registry.ModPotions;
import com.bewitchment.registry.ModSounds;
import com.ferreusveritas.dynamictrees.ModTrees;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamilyVanilla;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import rustic.common.items.ModItems;
import rustic.common.potions.PotionsRustic;

@Mod.EventBusSubscriber
public class ModRegistries {
    public static final Map<Item, String[]> ORE_DICTIONARY_ENTRIES = new HashMap<Item, String[]>();
    public static final Map<Item, List<Predicate<ItemStack>>> MODEL_PREDICATES = new HashMap<Item, List<Predicate<ItemStack>>>();

    @SubscribeEvent
    public static void registerRegistries(RegistryEvent.NewRegistry event) {
        new RegistryBuilder().setName(new ResourceLocation("bewitchment", "oven_recipe")).setType(OvenRecipe.class).create();
        new RegistryBuilder().setName(new ResourceLocation("bewitchment", "distillery_recipe")).setType(DistilleryRecipe.class).create();
        new RegistryBuilder().setName(new ResourceLocation("bewitchment", "spinning_wheel_recipe")).setType(SpinningWheelRecipe.class).create();
        new RegistryBuilder().setName(new ResourceLocation("bewitchment", "frostfire_recipe")).setType(FrostfireRecipe.class).create();
        new RegistryBuilder().setName(new ResourceLocation("bewitchment", "ritual")).setType(Ritual.class).create();
        new RegistryBuilder().setName(new ResourceLocation("bewitchment", "cauldron_recipe")).setType(CauldronRecipe.class).create();
        new RegistryBuilder().setName(new ResourceLocation("bewitchment", "brew")).setType(Brew.class).create();
        new RegistryBuilder().setName(new ResourceLocation("bewitchment", "fortune")).setType(Fortune.class).create();
        new RegistryBuilder().setName(new ResourceLocation("bewitchment", "tarot")).setType(Tarot.class).create();
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        GameRegistry.registerTileEntity(TileEntityIdol.class, (ResourceLocation)new ResourceLocation("bewitchment", "idol"));
        try {
            for (Field f : ModObjects.class.getFields()) {
                Object obj = f.get(null);
                if (obj instanceof Block) {
                    event.getRegistry().register((IForgeRegistryEntry)((Block)obj));
                    if (!(obj instanceof BlockCandleBase)) continue;
                    Bewitchment.proxy.ignoreProperty((Block)obj, new IProperty[]{BlockCandleBase.LIT});
                    continue;
                }
                if (!(obj instanceof Block[])) continue;
                for (Block block : (Block[])obj) {
                    event.getRegistry().register((IForgeRegistryEntry)block);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Bewitchment.proxy.ignoreProperty(ModObjects.embergrass, new IProperty[]{BlockBushSpreading.TIMES_SPREAD});
        Bewitchment.proxy.ignoreProperty(ModObjects.torchwood, new IProperty[]{BlockBushSpreading.TIMES_SPREAD});
        Bewitchment.proxy.ignoreProperty(ModObjects.cypress_sapling, new IProperty[]{BlockSapling.field_176479_b, BlockSapling.field_176480_a});
        Bewitchment.proxy.ignoreProperty(ModObjects.elder_sapling, new IProperty[]{BlockSapling.field_176479_b, BlockSapling.field_176480_a});
        Bewitchment.proxy.ignoreProperty(ModObjects.juniper_sapling, new IProperty[]{BlockSapling.field_176479_b, BlockSapling.field_176480_a});
        Bewitchment.proxy.ignoreProperty(ModObjects.yew_sapling, new IProperty[]{BlockSapling.field_176479_b, BlockSapling.field_176480_a});
        Bewitchment.proxy.ignoreProperty(ModObjects.cypress_leaves, new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a});
        Bewitchment.proxy.ignoreProperty(ModObjects.elder_leaves, new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a});
        Bewitchment.proxy.ignoreProperty(ModObjects.juniper_leaves, new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a});
        Bewitchment.proxy.ignoreProperty(ModObjects.yew_leaves, new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a});
        Bewitchment.proxy.ignoreProperty((Block)ModObjects.cypress_door.door, new IProperty[]{BlockDoor.field_176522_N});
        Bewitchment.proxy.ignoreProperty((Block)ModObjects.elder_door.door, new IProperty[]{BlockDoor.field_176522_N});
        Bewitchment.proxy.ignoreProperty((Block)ModObjects.juniper_door.door, new IProperty[]{BlockDoor.field_176522_N});
        Bewitchment.proxy.ignoreProperty((Block)ModObjects.yew_door.door, new IProperty[]{BlockDoor.field_176522_N});
        Bewitchment.proxy.ignoreProperty(ModObjects.cypress_fence_gate, new IProperty[]{BlockFenceGate.field_176465_b});
        Bewitchment.proxy.ignoreProperty(ModObjects.elder_fence_gate, new IProperty[]{BlockFenceGate.field_176465_b});
        Bewitchment.proxy.ignoreProperty(ModObjects.juniper_fence_gate, new IProperty[]{BlockFenceGate.field_176465_b});
        Bewitchment.proxy.ignoreProperty(ModObjects.yew_fence_gate, new IProperty[]{BlockFenceGate.field_176465_b});
        ModObjects.crop_aconitum.setItems(ModObjects.aconitum_seeds, ModObjects.aconitum);
        ModObjects.crop_belladonna.setItems(ModObjects.belladonna_seeds, ModObjects.belladonna);
        ModObjects.crop_garlic.setItems(ModObjects.garlic_seeds, ModObjects.garlic);
        ModObjects.crop_hellebore.setItems(ModObjects.hellebore_seeds, ModObjects.hellebore);
        ModObjects.crop_mandrake.setItems(ModObjects.mandrake_seeds, ModObjects.mandrake_root);
        ModObjects.crop_white_sage.setItems(ModObjects.white_sage_seeds, ModObjects.white_sage);
        ModObjects.crop_wormwood.setItems(ModObjects.wormwood_seeds, ModObjects.wormwood);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        try {
            for (Field f : ModObjects.class.getFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof Item)) continue;
                Item item = (Item)obj;
                List<Predicate<ItemStack>> predicates = MODEL_PREDICATES.get(item);
                event.getRegistry().register((IForgeRegistryEntry)item);
                if (predicates.isEmpty()) {
                    Bewitchment.proxy.registerTexture(item, "normal");
                    continue;
                }
                Bewitchment.proxy.registerTextureVariant(item, predicates);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Item item : ORE_DICTIONARY_ENTRIES.keySet()) {
            for (String ore : ORE_DICTIONARY_ENTRIES.get(item)) {
                OreDictionary.registerOre((String)ore, (Item)item);
            }
        }
        OreDictionary.registerOre((String)"gemAll", (ItemStack)new ItemStack(Items.field_151128_bU));
        OreDictionary.registerOre((String)"gemAll", (ItemStack)new ItemStack(Items.field_151045_i));
        OreDictionary.registerOre((String)"gemAll", (ItemStack)new ItemStack(Items.field_151166_bC));
        OreDictionary.registerOre((String)"gemAll", (ItemStack)new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()));
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        try {
            for (Field f : ModEntities.class.getFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof EntityEntry)) continue;
                event.getRegistry().register((IForgeRegistryEntry)((EntityEntry)obj));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(ModEntityPotion.class).id(new ResourceLocation("bewitchment", "potion"), ModEntities.entity_id++).name("ThrownPotion").tracker(64, 1, true).build());
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(ModEntityTippedArrow.class).id(new ResourceLocation("bewitchment", "arrow"), ModEntities.entity_id++).name("Arrow").tracker(64, 1, true).build());
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("bewitchment", "entities/lizard"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("bewitchment", "entities/newt"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("bewitchment", "entities/owl"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("bewitchment", "entities/snake"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("bewitchment", "entities/raven"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("bewitchment", "entities/toad"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("bewitchment", "entities/black_dog"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("bewitchment", "entities/hellhound"));
        for (int i = 0; i < 4; ++i) {
            LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("bewitchment", "entities/demon" + i));
        }
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("bewitchment", "entities/imp"));
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        try {
            for (Field f : ModSounds.class.getFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof SoundEvent)) continue;
                event.getRegistry().register((IForgeRegistryEntry)((SoundEvent)obj));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        try {
            for (Field f : ModEnchantments.class.getFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof Enchantment)) continue;
                event.getRegistry().register((IForgeRegistryEntry)((Enchantment)obj));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        try {
            for (Field f : ModPotions.class.getFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof Potion)) continue;
                event.getRegistry().register((IForgeRegistryEntry)((Potion)obj));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void registerRituals(RegistryEvent.Register<Ritual> event) {
        event.getRegistry().register((IForgeRegistryEntry)new RitualSolarGlory());
        event.getRegistry().register((IForgeRegistryEntry)new RitualHighMoon());
        event.getRegistry().register((IForgeRegistryEntry)new RitualSandsOfTime());
        event.getRegistry().register((IForgeRegistryEntry)new RitualDeluge());
        event.getRegistry().register((IForgeRegistryEntry)new RitualTeleport());
        event.getRegistry().register((IForgeRegistryEntry)new RitualPerception());
        event.getRegistry().register((IForgeRegistryEntry)new RitualHungryFlames());
        event.getRegistry().register((IForgeRegistryEntry)new RitualFrenziedGrowth());
        event.getRegistry().register((IForgeRegistryEntry)new RitualRevealing());
        event.getRegistry().register((IForgeRegistryEntry)new RitualCallOfTheWild());
        event.getRegistry().register((IForgeRegistryEntry)new RitualLesserHellMouth());
        event.getRegistry().register((IForgeRegistryEntry)new RitualHellmouth());
        event.getRegistry().register((IForgeRegistryEntry)new RitualGreaterHellmouth());
        event.getRegistry().register((IForgeRegistryEntry)new RitualConjureWitch());
        event.getRegistry().register((IForgeRegistryEntry)new RitualConjureWither());
        event.getRegistry().register((IForgeRegistryEntry)new RitualConjureDemon());
        event.getRegistry().register((IForgeRegistryEntry)new RitualConjureImp());
        event.getRegistry().register((IForgeRegistryEntry)new RitualSpiritualRift());
        event.getRegistry().register((IForgeRegistryEntry)new RitualDrawing(new ResourceLocation("bewitchment", "draw_small"), Collections.singletonList(Util.get(Items.field_151119_aD)), 150, 4, -1, -1, Ritual.small));
        event.getRegistry().register((IForgeRegistryEntry)new RitualDrawing(new ResourceLocation("bewitchment", "draw_medium"), Arrays.asList(Util.get(Items.field_151119_aD), Util.get(ModObjects.wood_ash)), 300, 4, 4, -1, Ritual.medium));
        event.getRegistry().register((IForgeRegistryEntry)new RitualDrawing(new ResourceLocation("bewitchment", "draw_large"), Arrays.asList(Util.get(Items.field_151119_aD), Util.get(Items.field_151119_aD), Util.get(ModObjects.wood_ash), Util.get(ModObjects.wood_ash)), 450, 4, 4, 4, Ritual.large));
        event.getRegistry().register((IForgeRegistryEntry)new Ritual(new ResourceLocation("bewitchment", "crystal_ball"), Arrays.asList(Util.get("blockGlass"), Util.get("gemQuartz"), Util.get("gemQuartz"), Util.get("gemQuartz"), Util.get(ModObjects.droplet_of_wisdom)), null, Collections.singletonList(new ItemStack(ModObjects.crystal_ball)), 5, 500, 50, 1, 3, -1));
        event.getRegistry().register((IForgeRegistryEntry)new Ritual(new ResourceLocation("bewitchment", "tarot_table"), Arrays.asList(Util.get(Blocks.field_150417_aV), Util.get(ModObjects.liquid_witchcraft), Util.get(ModObjects.juniper_planks), Util.get(new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE))), null, Collections.singletonList(new ItemStack(ModObjects.tarot_table)), 7, 750, 60, 1, 1, -1));
        event.getRegistry().register((IForgeRegistryEntry)new Ritual(new ResourceLocation("bewitchment", "tarot_cards"), Arrays.asList(Util.get("dye"), Util.get("dye"), Util.get("dye"), Util.get("paper"), Util.get("materialWax", "materialBeeswax", "wax", "tallow", "materialPressedWax", "itemBeeswax", "clumpWax", "beeswax", "itemWax")), null, Collections.singletonList(new ItemStack(ModObjects.tarot_cards)), 4, 500, 25, 1, -1, -1));
        event.getRegistry().register((IForgeRegistryEntry)new Ritual(new ResourceLocation("bewitchment", "grimoire_magia"), Arrays.asList(Util.get("leather"), Util.get("leather"), Util.get("paper"), Util.get("paper"), Util.get("paper"), Util.get(ModObjects.liquid_witchcraft), Util.get(ModObjects.opal)), null, Collections.singletonList(ItemGrimoireMagia.create(0)), 5, 150, 20, 1, -1, -1));
        event.getRegistry().register((IForgeRegistryEntry)new Ritual(new ResourceLocation("bewitchment", "purifying_earth"), Arrays.asList(Util.get("dirt"), Util.get("dirt"), Util.get("dirt"), Util.get("dirt"), Util.get("cropWhiteSage"), Util.get("cropWhiteSage"), Util.get("salt"), Util.get("salt")), null, Collections.singletonList(new ItemStack(ModObjects.purifying_earth, 16)), 2, 200, 20, 1, 1, -1));
        event.getRegistry().register((IForgeRegistryEntry)new Ritual(new ResourceLocation("bewitchment", "cypress_broom"), Arrays.asList(Util.get(ModObjects.broom), Util.get(ModObjects.cypress_wood), Util.get(ModObjects.cypress_sapling), Util.get(ModObjects.flying_ointment), Util.get(ModObjects.ebb_of_death)), null, Collections.singletonList(new ItemStack(ModObjects.cypress_broom)), 10, 1250, 60, 1, 1, 3));
        event.getRegistry().register((IForgeRegistryEntry)new Ritual(new ResourceLocation("bewitchment", "elder_broom"), Arrays.asList(Util.get(ModObjects.broom), Util.get(ModObjects.elder_wood), Util.get(ModObjects.elder_sapling), Util.get(ModObjects.flying_ointment), Util.get(ModObjects.droplet_of_wisdom)), null, Collections.singletonList(new ItemStack(ModObjects.elder_broom)), 10, 1250, 60, 1, 1, 3));
        event.getRegistry().register((IForgeRegistryEntry)new Ritual(new ResourceLocation("bewitchment", "juniper_broom"), Arrays.asList(Util.get(ModObjects.broom), Util.get(ModObjects.juniper_wood), Util.get(ModObjects.juniper_sapling), Util.get(ModObjects.flying_ointment), Util.get(ModObjects.liquid_witchcraft)), null, Collections.singletonList(new ItemStack(ModObjects.juniper_broom)), 10, 1250, 60, 1, 1, 3));
        event.getRegistry().register((IForgeRegistryEntry)new Ritual(new ResourceLocation("bewitchment", "yew_broom"), Arrays.asList(Util.get(ModObjects.broom), Util.get(ModObjects.yew_wood), Util.get(ModObjects.yew_sapling), Util.get(ModObjects.flying_ointment), Util.get(ModObjects.essence_of_vitality)), null, Collections.singletonList(new ItemStack(ModObjects.yew_broom)), 10, 1250, 60, 1, 1, 3));
        if (Bewitchment.config.wednesday) {
            event.getRegistry().register((IForgeRegistryEntry)new RitualWednesday());
        }
    }

    @SubscribeEvent
    public static void registerCauldronRecipes(RegistryEvent.Register<CauldronRecipe> event) {
        event.getRegistry().register((IForgeRegistryEntry)new CauldronRecipe(new ResourceLocation("bewitchment", "focal_chalk"), Arrays.asList(Util.get(ModObjects.ritual_chalk), Util.get(ModObjects.liquid_witchcraft), Util.get("nuggetGold")), Arrays.asList(new ItemStack(ModObjects.focal_chalk), new ItemStack(ModObjects.empty_jar))));
        event.getRegistry().register((IForgeRegistryEntry)new CauldronRecipe(new ResourceLocation("bewitchment", "fiery_chalk"), Arrays.asList(Util.get(ModObjects.ritual_chalk), Util.get(Items.field_151065_br), Util.get("netherrack")), Collections.singletonList(new ItemStack(ModObjects.fiery_chalk))));
        event.getRegistry().register((IForgeRegistryEntry)new CauldronRecipe(new ResourceLocation("bewitchment", "phasing_chalk"), Arrays.asList(Util.get(ModObjects.ritual_chalk), Util.get(ModObjects.dimensional_sand), Util.get("dustGlowstone")), Collections.singletonList(new ItemStack(ModObjects.phasing_chalk))));
        event.getRegistry().register((IForgeRegistryEntry)new CauldronRecipe(new ResourceLocation("bewitchment", "filled_goblet"), Arrays.asList(Util.get(ModObjects.goblet), Util.get(ModObjects.cloudy_oil), Util.get(Items.field_151073_bk), Util.get("dustRedstone"), Util.get("dustRedstone"), Util.get("dustRedstone")), Arrays.asList(new ItemStack(ModObjects.filled_goblet), new ItemStack(ModObjects.empty_jar))));
        event.getRegistry().register((IForgeRegistryEntry)new CauldronRecipe(new ResourceLocation("bewitchment", "embergrass"), Arrays.asList(Util.get(new ItemStack((Block)Blocks.field_150329_H, 1, 1)), Util.get(ModObjects.liquid_witchcraft), Util.get(Items.field_151065_br), Util.get(new ItemStack((Block)Blocks.field_150327_N, 1, Short.MAX_VALUE), new ItemStack((Block)Blocks.field_150328_O, 1, Short.MAX_VALUE))), Arrays.asList(new ItemStack(ModObjects.embergrass), new ItemStack(ModObjects.empty_jar))));
        event.getRegistry().register((IForgeRegistryEntry)new CauldronRecipe(new ResourceLocation("bewitchment", "torchwood"), Arrays.asList(Util.get(new ItemStack((Block)Blocks.field_150329_H, 1, 1)), Util.get(ModObjects.liquid_witchcraft), Util.get("logWood"), Util.get("glowstone")), Arrays.asList(new ItemStack(ModObjects.torchwood), new ItemStack(ModObjects.empty_jar))));
        event.getRegistry().register((IForgeRegistryEntry)new CauldronRecipe(new ResourceLocation("bewitchment", "tallow"), Arrays.asList(Util.get(Items.field_151078_bh), Util.get(Items.field_151078_bh)), Collections.singletonList(new ItemStack(ModObjects.tallow))));
        event.getRegistry().register((IForgeRegistryEntry)new CauldronRecipe(new ResourceLocation("bewitchment", "slimeball"), Collections.singletonList(Util.get(ModObjects.hoof)), Collections.singletonList(new ItemStack(Items.field_151123_aH))));
        event.getRegistry().register((IForgeRegistryEntry)new CauldronRecipe(new ResourceLocation("bewitchment", "iron_gall_ink"), Arrays.asList(Util.get(ModObjects.oak_apple_gall), Util.get(ModObjects.oak_apple_gall), Util.get("nuggetIron")), Collections.singletonList(new ItemStack(ModObjects.iron_gall_ink, 3))));
        event.getRegistry().register((IForgeRegistryEntry)new CauldronRecipe(new ResourceLocation("bewitchment", "catechu_brown"), Collections.singletonList(Util.get("logWood")), Collections.singletonList(new ItemStack(ModObjects.catechu_brown, 4))));
        event.getRegistry().register((IForgeRegistryEntry)new CauldronRecipe(new ResourceLocation("bewitchment", "banner_pattern_removal"), Collections.singletonList(Util.get(new ItemStack(Items.field_179564_cE, 1, Short.MAX_VALUE))), Collections.singletonList(new ItemStack(Items.field_179564_cE, 1, EnumDyeColor.WHITE.func_176767_b()))));
        event.getRegistry().register((IForgeRegistryEntry)new CauldronRecipe(new ResourceLocation("bewitchment", "stew_of_the_grotesque"), Arrays.asList(Util.get(ModObjects.demonic_elixir), Util.get(ModObjects.heart), Util.get(Items.field_179561_bm), Util.get(ModObjects.eye_of_newt), Util.get(ModObjects.lizard_leg), Util.get(ModObjects.toe_of_frog), Util.get(ModObjects.adders_fork), Util.get(ModObjects.belladonna), Util.get(ModObjects.hellebore)), Arrays.asList(new ItemStack(ModObjects.stew_of_the_grotesque), new ItemStack(ModObjects.empty_jar))));
    }

    @SubscribeEvent
    public static void registerBrews(RegistryEvent.Register<Brew> event) {
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "instant_health"), Util.get(Items.field_151034_e), new PotionEffect(MobEffects.field_76432_h, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "instant_damage"), Util.get(Items.field_151070_bp), new PotionEffect(MobEffects.field_76433_i, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "regeneration"), Util.get(Items.field_151060_bw), new PotionEffect(MobEffects.field_76428_l, 400)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "poison"), Util.get(ModObjects.snake_venom, ModObjects.belladonna), s -> s.func_77973_b() == ModObjects.snake_venom, new ItemStack(Items.field_151069_bo), new PotionEffect(MobEffects.field_76436_u, 400)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "wither"), Util.get(ModObjects.liquid_wroth), new ItemStack(Items.field_151069_bo), new PotionEffect(MobEffects.field_82731_v, 300)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "night_vision"), Util.get(Items.field_151172_bF, ModObjects.eye_of_old), new PotionEffect(MobEffects.field_76439_r, 2400)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "blindness"), Util.get(ModObjects.iron_gall_ink, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLACK.func_176767_b())), new PotionEffect(MobEffects.field_76440_q, 200)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "strength"), Util.get(Items.field_151147_al, Items.field_151082_bd, Items.field_179561_bm, Items.field_151076_bf, Items.field_179558_bo), new PotionEffect(MobEffects.field_76420_g, 1300)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "weakness"), Util.get(ModObjects.hellebore), new PotionEffect(MobEffects.field_76437_t, 900)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "resistance"), Util.get(Items.field_151157_am, Items.field_151083_be, Items.field_179557_bn, Items.field_151077_bg, Items.field_179559_bp), new PotionEffect(MobEffects.field_76429_m, 600)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "fire_resistance"), Util.get(ModObjects.embergrass), new PotionEffect(MobEffects.field_76426_n, 3000)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "absorption"), Util.get("treeSapling"), new PotionEffect(MobEffects.field_76444_x, 700)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "jump_boost"), Util.get(Items.field_179555_bs, ModObjects.hoof), new PotionEffect(MobEffects.field_76430_j, 900)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "speed"), Util.get(Items.field_151102_aT), new PotionEffect(MobEffects.field_76424_c, 900)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "slowness"), Util.get(Blocks.field_150338_P, "slimeball"), new PotionEffect(MobEffects.field_76421_d, 800)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "haste"), Util.get("sugarcane"), new PotionEffect(MobEffects.field_76422_e, 600)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "mining_fatigue"), Util.get(ModObjects.lizard_leg), new PotionEffect(MobEffects.field_76419_f, 600)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "luck"), Util.get(Items.field_179556_br), new PotionEffect(MobEffects.field_188425_z, 2400)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "unluck"), Util.get(ModObjects.adders_fork), new PotionEffect(MobEffects.field_189112_A, 2400)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "water_breathing"), Util.get(Items.field_151115_aP, ModObjects.eye_of_old), new PotionEffect(MobEffects.field_76427_o, 3000)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "invisibility"), Util.get(ModObjects.ectoplasm), new PotionEffect(MobEffects.field_76441_p, 500)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "hunger"), Util.get(ModObjects.tongue_of_dog), new PotionEffect(MobEffects.field_76438_s, 600)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "nausea"), Util.get(Blocks.field_150337_Q), new PotionEffect(MobEffects.field_76431_k, 200)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "glowing"), Util.get(ModObjects.spectral_dust), new PotionEffect(MobEffects.field_188423_x, 800)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "levitation"), Util.get(Items.field_185161_cS), new PotionEffect(MobEffects.field_188424_y, 80)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "absence"), Util.get(Items.field_151117_aB), new PotionEffect(ModPotions.absence, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "purification"), Util.get(Items.field_151127_ba), new PotionEffect(ModPotions.purification, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "corruption"), Util.get(Items.field_151071_bq), new PotionEffect(ModPotions.corruption, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "magic_resistance"), Util.get(ModObjects.yew_aril), new PotionEffect(ModPotions.magic_resistance, 1200)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "magic_weakness"), Util.get(ModObjects.juniper_berries), new PotionEffect(ModPotions.magic_weakness, 1200)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "hellworld"), Util.get(ModObjects.hellhound_horn), new PotionEffect(ModPotions.hellworld, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "iceworld"), Util.get(Blocks.field_150432_aD, Blocks.field_150403_cj, Blocks.field_150433_aE), new PotionEffect(ModPotions.iceworld, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "rubedo"), Util.get(ModObjects.acacia_resin), new ItemStack(ModObjects.empty_jar), new PotionEffect(ModPotions.rubedo, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "citrinitas"), Util.get(ModObjects.birch_soul), new ItemStack(ModObjects.empty_jar), new PotionEffect(ModPotions.citrinitas, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "desertification"), Util.get(new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE)), new PotionEffect(ModPotions.desertification, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "fertility"), Util.get(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.BLUE_ORCHID.func_176968_b())), new PotionEffect(ModPotions.fertility, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "harvest"), Util.get(Blocks.field_150423_aK), new PotionEffect(ModPotions.harvest, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "spore_cloud"), Util.get(Items.field_151009_A), new ItemStack(Items.field_151054_z), new PotionEffect(ModPotions.spore_cloud, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "blight"), Util.get(Items.field_151078_bh), new PotionEffect(ModPotions.blight, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "ruin"), Util.get(Blocks.field_150434_aF, Blocks.field_150330_I), new PotionEffect(ModPotions.ruin, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "pesticide"), Util.get("cropWormwood"), new PotionEffect(ModPotions.pesticide, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "arachnophobia"), Util.get(Blocks.field_150321_G), new PotionEffect(ModPotions.arachnophobia, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "mending"), Util.get(Items.field_151153_ao, new ItemStack(Items.field_151153_ao, 1, 1)), new PotionEffect(ModPotions.mending, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "holy_water"), Util.get("cropWhiteSage", "cropGarlic", new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.ALLIUM.func_176968_b())), new PotionEffect(ModPotions.holy_water, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "wolfsbane"), Util.get("cropAconitum"), new PotionEffect(ModPotions.wolfsbane, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "deviants_decomposure"), Util.get(ModObjects.elderberries), new PotionEffect(ModPotions.deviants_decomposure, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "sleeping"), Util.get(Blocks.field_150328_O), new PotionEffect(ModPotions.sleeping, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "volatility"), Util.get(Items.field_151059_bz), new PotionEffect(ModPotions.volatility, 900)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "grace"), Util.get("feather"), new PotionEffect(ModPotions.grace, 600)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "shell_armor"), Util.get("coquina"), new PotionEffect(ModPotions.shell_armor, 600)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "deflection"), Util.get(Items.field_185162_cT), new PotionEffect(ModPotions.deflection, 600)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "revealing"), Util.get(ModObjects.eye_of_newt), new PotionEffect(ModPotions.revealing, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "disrobing"), Util.get(ModObjects.tallow), new PotionEffect(ModPotions.disrobing, 1)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "sinking"), Util.get("nuggetGold", "nuggetIron", "nuggetColdIron", "nuggetCopper", "nuggetTin", "nuggetBronze", "nuggetLead"), new PotionEffect(ModPotions.sinking, 400)));
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "cursed_leaps"), Util.get(ModObjects.toe_of_frog), new PotionEffect(ModPotions.cursed_leaps, 1)));
        if (Loader.isModLoaded((String)"rustic")) {
            event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "blazing_trail"), Util.get(ModItems.CHILI_PEPPER), new PotionEffect(PotionsRustic.BLAZING_TRAIL_POTION, 600)));
            event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "iron_skin"), Util.get(ModItems.IRONBERRIES), new PotionEffect(PotionsRustic.IRON_SKIN_POTION, 600)));
        }
    }

    @SubscribeEvent
    public static void registerOvenRecipes(RegistryEvent.Register<OvenRecipe> event) {
        event.getRegistry().register((IForgeRegistryEntry)new OvenRecipe(new ResourceLocation("bewitchment", "oak_spirit"), new ItemStack(Blocks.field_150345_g, 1), new ItemStack(ModObjects.wood_ash, 4), new ItemStack(ModObjects.oak_spirit), 0.75f));
        event.getRegistry().register((IForgeRegistryEntry)new OvenRecipe(new ResourceLocation("bewitchment", "oak_spirit_alt"), new ItemStack(Blocks.field_150345_g, 1, 5), new ItemStack(ModObjects.wood_ash, 4), new ItemStack(ModObjects.oak_spirit), 0.75f));
        event.getRegistry().register((IForgeRegistryEntry)new OvenRecipe(new ResourceLocation("bewitchment", "spruce_heart"), new ItemStack(Blocks.field_150345_g, 1, 1), new ItemStack(ModObjects.wood_ash, 4), new ItemStack(ModObjects.spruce_heart), 0.75f));
        event.getRegistry().register((IForgeRegistryEntry)new OvenRecipe(new ResourceLocation("bewitchment", "birch_soul"), new ItemStack(Blocks.field_150345_g, 1, 2), new ItemStack(ModObjects.wood_ash, 4), new ItemStack(ModObjects.birch_soul), 0.75f));
        event.getRegistry().register((IForgeRegistryEntry)new OvenRecipe(new ResourceLocation("bewitchment", "cloudy_oil"), new ItemStack(Blocks.field_150345_g, 1, 3), new ItemStack(ModObjects.wood_ash, 4), new ItemStack(ModObjects.cloudy_oil), 0.75f));
        event.getRegistry().register((IForgeRegistryEntry)new OvenRecipe(new ResourceLocation("bewitchment", "acacia_resin"), new ItemStack(Blocks.field_150345_g, 1, 4), new ItemStack(ModObjects.wood_ash, 4), new ItemStack(ModObjects.acacia_resin), 0.75f));
        event.getRegistry().register((IForgeRegistryEntry)new OvenRecipe(new ResourceLocation("bewitchment", "ebb_of_death"), new ItemStack(ModObjects.cypress_sapling), new ItemStack(ModObjects.wood_ash, 4), new ItemStack(ModObjects.ebb_of_death), 0.75f));
        event.getRegistry().register((IForgeRegistryEntry)new OvenRecipe(new ResourceLocation("bewitchment", "droplet_of_wisdom"), new ItemStack(ModObjects.elder_sapling), new ItemStack(ModObjects.wood_ash, 4), new ItemStack(ModObjects.droplet_of_wisdom), 0.75f));
        event.getRegistry().register((IForgeRegistryEntry)new OvenRecipe(new ResourceLocation("bewitchment", "liquid_witchcraft"), new ItemStack(ModObjects.juniper_sapling), new ItemStack(ModObjects.wood_ash, 4), new ItemStack(ModObjects.liquid_witchcraft), 0.75f));
        event.getRegistry().register((IForgeRegistryEntry)new OvenRecipe(new ResourceLocation("bewitchment", "essence_of_vitality"), new ItemStack(ModObjects.yew_sapling), new ItemStack(ModObjects.wood_ash, 4), new ItemStack(ModObjects.essence_of_vitality), 0.75f));
        if (Loader.isModLoaded((String)"dynamictrees")) {
            for (TreeFamilyVanilla family : ModTrees.baseFamilies) {
                Species species = family.getCommonSpecies();
                String name = species.getSaplingName().toString().toLowerCase();
                name = name.substring(name.indexOf(":") + 1);
                event.getRegistry().register((IForgeRegistryEntry)new OvenRecipe(new ResourceLocation("bewitchment", name), species.getSeedStack(1), new ItemStack(ModObjects.wood_ash, 4), new ItemStack(name.contains("oak") ? ModObjects.oak_spirit : (name.contains("spruce") ? ModObjects.spruce_heart : (name.contains("birch") ? ModObjects.birch_soul : (name.contains("acacia") ? ModObjects.acacia_resin : ModObjects.cloudy_oil)))), 0.75f));
            }
        }
        event.getRegistry().register((IForgeRegistryEntry)new OvenRecipe(new ResourceLocation("bewitchment", "cloudy_oil_alt0"), new ItemStack((Block)Blocks.field_150434_aF), new ItemStack(Items.field_151100_aR, 1, 2), new ItemStack(ModObjects.cloudy_oil), 0.55f));
        event.getRegistry().register((IForgeRegistryEntry)new OvenRecipe(new ResourceLocation("bewitchment", "cloudy_oil_alt1"), new ItemStack(ModObjects.mandrake_root), new ItemStack(ModObjects.wood_ash), new ItemStack(ModObjects.cloudy_oil), 0.85f));
        event.getRegistry().register((IForgeRegistryEntry)new OvenRecipe(new ResourceLocation("bewitchment", "ectoplasm"), new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151116_aA), new ItemStack(ModObjects.ectoplasm, 3), 0.65f, false));
        event.getRegistry().register((IForgeRegistryEntry)new OvenRecipe(new ResourceLocation("bewitchment", "ectoplasm_alt"), new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151100_aR, 1, 15), new ItemStack(ModObjects.ectoplasm), 0.65f, false));
        event.getRegistry().register((IForgeRegistryEntry)new OvenRecipe(new ResourceLocation("bewitchment", "dimensional_sand"), new ItemStack(Items.field_151061_bv), new ItemStack(Items.field_151065_br, 1, 0), new ItemStack(ModObjects.dimensional_sand, 2), 0.8f, false));
        event.getRegistry().register((IForgeRegistryEntry)new OvenRecipe(new ResourceLocation("bewitchment", "dimensional_sand_alt0"), new ItemStack(Items.field_190930_cZ), new ItemStack(Items.field_185162_cT, 1, 0), new ItemStack(ModObjects.dimensional_sand, 4), 1.0f, false));
        event.getRegistry().register((IForgeRegistryEntry)new OvenRecipe(new ResourceLocation("bewitchment", "dimensional_sand_alt1"), new ItemStack(Items.field_185161_cS), new ItemStack(Items.field_185162_cT), new ItemStack(ModObjects.dimensional_sand, 2), 0.75f, false));
    }

    @SubscribeEvent
    public static void registerDistilleryRecipes(RegistryEvent.Register<DistilleryRecipe> event) {
        event.getRegistry().register((IForgeRegistryEntry)new DistilleryRecipe(new ResourceLocation("bewitchment", "bottled_frostfire"), Arrays.asList(Util.get(Items.field_151069_bo), Util.get(ModObjects.perpetual_ice), Util.get(ModObjects.cleansing_balm), Util.get(ModObjects.fiery_unguent)), Arrays.asList(new ItemStack(ModObjects.bottled_frostfire), new ItemStack(ModObjects.empty_jar, 2))));
        event.getRegistry().register((IForgeRegistryEntry)new DistilleryRecipe(new ResourceLocation("bewitchment", "cleansing_balm"), Arrays.asList(Util.get(ModObjects.acacia_resin), Util.get("cropWhiteSage"), Util.get("salt"), Util.get("cropGarlic")), Arrays.asList(new ItemStack(ModObjects.cleansing_balm), new ItemStack(ModObjects.wood_ash))));
        event.getRegistry().register((IForgeRegistryEntry)new DistilleryRecipe(new ResourceLocation("bewitchment", "demonic_elixir"), Arrays.asList(Util.get(ModObjects.demon_heart), Util.get(ModObjects.fiery_unguent), Util.get(ModObjects.empty_jar), Util.get(ModObjects.empty_jar)), Collections.singletonList(new ItemStack(ModObjects.demonic_elixir, 3))));
        event.getRegistry().register((IForgeRegistryEntry)new DistilleryRecipe(new ResourceLocation("bewitchment", "fiery_unguent"), Arrays.asList(Util.get(Items.field_151065_br), Util.get(ModObjects.cloudy_oil), Util.get("wax")), Collections.singletonList(new ItemStack(ModObjects.fiery_unguent))));
    }

    @SubscribeEvent
    public static void registerSpinningWheelRecipes(RegistryEvent.Register<SpinningWheelRecipe> event) {
        event.getRegistry().register((IForgeRegistryEntry)new SpinningWheelRecipe(new ResourceLocation("bewitchment", "cobweb"), Arrays.asList(Util.get("string"), Util.get("string"), Util.get("string")), Collections.singletonList(new ItemStack(Blocks.field_150321_G))));
        event.getRegistry().register((IForgeRegistryEntry)new SpinningWheelRecipe(new ResourceLocation("bewitchment", "witches_stitching"), Arrays.asList(Util.get("string"), Util.get("string"), Util.get(ModObjects.liquid_witchcraft), Util.get(ModObjects.liquid_witchcraft)), Arrays.asList(new ItemStack(ModObjects.witches_stitching, 2), new ItemStack(ModObjects.empty_jar, 2))));
        event.getRegistry().register((IForgeRegistryEntry)new SpinningWheelRecipe(new ResourceLocation("bewitchment", "diabolical_vein"), Arrays.asList(Util.get(ModObjects.witches_stitching), Util.get(ModObjects.witches_stitching), Util.get(ModObjects.fiery_unguent), Util.get(ModObjects.heart)), Arrays.asList(new ItemStack(ModObjects.diabolical_vein, 2), new ItemStack(ModObjects.empty_jar))));
        event.getRegistry().register((IForgeRegistryEntry)new SpinningWheelRecipe(new ResourceLocation("bewitchment", "pure_filament"), Arrays.asList(Util.get(ModObjects.witches_stitching), Util.get(ModObjects.witches_stitching), Util.get(ModObjects.acacia_resin), Util.get("cropWhiteSage")), Arrays.asList(new ItemStack(ModObjects.pure_filament, 2), new ItemStack(ModObjects.empty_jar))));
    }

    @SubscribeEvent
    public static void registerFrostfireRecipes(RegistryEvent.Register<FrostfireRecipe> event) {
        event.getRegistry().register((IForgeRegistryEntry)new FrostfireRecipe(new ResourceLocation("bewitchment", "cold_iron_ingot"), Util.get("oreIron"), new ItemStack(ModObjects.cold_iron_ingot)));
        if (!Arrays.asList(Util.get("clusterIron").func_193365_a()).isEmpty()) {
            event.getRegistry().register((IForgeRegistryEntry)new FrostfireRecipe(new ResourceLocation("bewitchment", "cold_iron_cluster"), Util.get("clusterIron"), new ItemStack(ModObjects.cold_iron_nugget, 18)));
        }
        if (!Arrays.asList(Util.get("dustIron", "gritIron").func_193365_a()).isEmpty()) {
            event.getRegistry().register((IForgeRegistryEntry)new FrostfireRecipe(new ResourceLocation("bewitchment", "cold_iron_ingot_alt"), Util.get("dustIron", "gritIron"), new ItemStack(ModObjects.cold_iron_ingot)));
        }
        if (!Arrays.asList(Util.get("dustTinyIron").func_193365_a()).isEmpty()) {
            event.getRegistry().register((IForgeRegistryEntry)new FrostfireRecipe(new ResourceLocation("bewitchment", "cold_iron_nugget"), Util.get("dustTinyIron"), new ItemStack(ModObjects.cold_iron_nugget)));
        }
    }

    @SubscribeEvent
    public static void registerFortunes(RegistryEvent.Register<Fortune> event) {
        event.getRegistry().register((IForgeRegistryEntry)new FortuneBadLuck());
        event.getRegistry().register((IForgeRegistryEntry)new FortuneGoodLuck());
        event.getRegistry().register((IForgeRegistryEntry)new FortuneIllness());
        event.getRegistry().register((IForgeRegistryEntry)new FortuneVitality());
        event.getRegistry().register((IForgeRegistryEntry)new FortuneMeetPet());
        event.getRegistry().register((IForgeRegistryEntry)new FortuneMeetMerchant());
        event.getRegistry().register((IForgeRegistryEntry)new FortuneMeetDemon());
        event.getRegistry().register((IForgeRegistryEntry)new FortuneMeetSerpent());
        event.getRegistry().register((IForgeRegistryEntry)new FortuneMeetBlaze());
        event.getRegistry().register((IForgeRegistryEntry)new FortuneMeetDireWolf());
        event.getRegistry().register((IForgeRegistryEntry)new FortuneMeetSilverfish());
        event.getRegistry().register((IForgeRegistryEntry)new FortuneMeetWitch());
        event.getRegistry().register((IForgeRegistryEntry)new FortuneMeetZombie());
        event.getRegistry().register((IForgeRegistryEntry)new FortuneDeath());
        event.getRegistry().register((IForgeRegistryEntry)new FortuneDropItem());
        event.getRegistry().register((IForgeRegistryEntry)new FortuneTreasure());
        if (Bewitchment.config.enableCatsAndDogsFortune) {
            event.getRegistry().register((IForgeRegistryEntry)new FortuneCatsAndDogs());
        }
    }

    @SubscribeEvent
    public static void registerTarots(RegistryEvent.Register<Tarot> event) {
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "player"), new ResourceLocation("bewitchment", "textures/gui/tarot/00player.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return BewitchmentAPI.isWitch((EntityLivingBase)player);
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "witch"), new ResourceLocation("bewitchment", "textures/gui/tarot/01witch.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return false;
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "enderman"), new ResourceLocation("bewitchment", "textures/gui/tarot/02enderman.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return false;
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "cat"), new ResourceLocation("bewitchment", "textures/gui/tarot/03cat.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return false;
            }

            @Override
            public boolean isReversed(EntityPlayer player) {
                return false;
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "guardian"), new ResourceLocation("bewitchment", "textures/gui/tarot/04guardian.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return this.getNumber(player) > 0;
            }

            @Override
            public int getNumber(EntityPlayer player) {
                return ((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).uniqueDefeatedBosses.func_74745_c();
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "illusioner"), new ResourceLocation("bewitchment", "textures/gui/tarot/05illusioner.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return !player.func_70651_bq().isEmpty();
            }

            @Override
            public int getNumber(EntityPlayer player) {
                int max = 0;
                for (PotionEffect effect : player.func_70651_bq()) {
                    if (effect.func_76458_c() <= max) continue;
                    max = effect.func_76458_c();
                }
                return max;
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "companions"), new ResourceLocation("bewitchment", "textures/gui/tarot/06companions.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return false;
            }

            @Override
            public boolean isReversed(EntityPlayer player) {
                return false;
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "mounts"), new ResourceLocation("bewitchment", "textures/gui/tarot/07mounts.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return false;
            }

            @Override
            public int getNumber(EntityPlayer player) {
                return 0;
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "silver_sword"), new ResourceLocation("bewitchment", "textures/gui/tarot/08silver_sword.png")){

            @Override
            public boolean isReversed(EntityPlayer player) {
                return BewitchmentAPI.isWitchHunter((EntityLivingBase)player);
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "evoker"), new ResourceLocation("bewitchment", "textures/gui/tarot/09evoker.png")){

            @Override
            public boolean isReversed(EntityPlayer player) {
                return BewitchmentAPI.isSpectre((EntityLivingBase)player);
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "diamonds"), new ResourceLocation("bewitchment", "textures/gui/tarot/10diamonds.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return ((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).fortune != null;
            }

            @Override
            public boolean isReversed(EntityPlayer player) {
                return this.isCounted(player) && ((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).fortune.isNegative;
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "iron_golem"), new ResourceLocation("bewitchment", "textures/gui/tarot/11iron_golem.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return false;
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "zombie"), new ResourceLocation("bewitchment", "textures/gui/tarot/12zombie.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return false;
            }

            @Override
            public int getNumber(EntityPlayer player) {
                return 0;
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "wither_skeleton"), new ResourceLocation("bewitchment", "textures/gui/tarot/13wither_skeleton.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return false;
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "villager"), new ResourceLocation("bewitchment", "textures/gui/tarot/14villager.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return false;
            }

            @Override
            public int getNumber(EntityPlayer player) {
                return 0;
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "wither"), new ResourceLocation("bewitchment", "textures/gui/tarot/15wither.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return false;
            }

            @Override
            public int getNumber(EntityPlayer player) {
                return 0;
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "ender_dragon"), new ResourceLocation("bewitchment", "textures/gui/tarot/16ender_dragon.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return this.getNumber(player) > 0;
            }

            @Override
            public int getNumber(EntityPlayer player) {
                return ((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).mobsKilled / 100;
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "star"), new ResourceLocation("bewitchment", "textures/gui/tarot/17star.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return false;
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "moon"), new ResourceLocation("bewitchment", "textures/gui/tarot/18moon.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return BewitchmentAPI.isVampire((EntityLivingBase)player) || BewitchmentAPI.isWerewolf((EntityLivingBase)player);
            }

            @Override
            public boolean isReversed(EntityPlayer player) {
                return BewitchmentAPI.isWerewolf((EntityLivingBase)player);
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "sun"), new ResourceLocation("bewitchment", "textures/gui/tarot/19sun.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return false;
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "stronghold"), new ResourceLocation("bewitchment", "textures/gui/tarot/20stronghold.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return this.getNumber(player) > 0;
            }

            @Override
            public int getNumber(EntityPlayer player) {
                return ((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).ritualsCast;
            }
        });
        event.getRegistry().register((IForgeRegistryEntry)new Tarot(new ResourceLocation("bewitchment", "world"), new ResourceLocation("bewitchment", "textures/gui/tarot/21world.png")){

            @Override
            public boolean isCounted(EntityPlayer player) {
                return this.getNumber(player) > 0;
            }

            @Override
            public int getNumber(EntityPlayer player) {
                return ((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).exploredChunks.func_74745_c() / 100;
            }
        });
    }
}

