/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.audio.storage;

import java.io.ByteArrayOutputStream;
import java.io.File;
import javax.sound.sampled.AudioFormat;
import org.apache.commons.lang3.tuple.Pair;
import paulscode.sound.ICodec;
import paulscode.sound.SoundBuffer;
import pl.asie.charset.module.audio.storage.IAudioDataDumper;

public class AudioDataDumperPaul
implements IAudioDataDumper {
    private final ICodec codec;

    public AudioDataDumperPaul(ICodec codec) {
        this.codec = codec;
    }

    @Override
    public Pair<byte[], AudioFormat> getAudioData(long maxSize) {
        long dataPartLength;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        AudioFormat format = this.codec.getAudioFormat();
        long maxLength = maxSize * (long)format.getSampleSizeInBits() / 8L * (long)format.getChannels() * (long)((int)format.getSampleRate()) / 1000L;
        for (long dataLength = 0L; !this.codec.endOfStream() && dataLength < maxLength; dataLength += dataPartLength) {
            SoundBuffer buffer = this.codec.read();
            if (buffer == null) {
                return null;
            }
            dataPartLength = Math.min(maxLength - dataLength, (long)buffer.audioData.length);
            data.write(buffer.audioData, 0, (int)dataPartLength);
        }
        return Pair.of((Object)data.toByteArray(), (Object)format);
    }

    @Override
    public void initialize(File f) {
        try {
            this.codec.initialize(f.toURI().toURL());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean initialized() {
        return this.codec.initialized();
    }
}

