/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.audio.storage;

import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.charset.api.tape.IDataStorage;
import pl.asie.charset.lib.inventory.GuiHandlerCharset;
import pl.asie.charset.lib.item.ItemBlockBase;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.lib.resources.ColorPaletteUpdateEvent;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.module.audio.storage.BlockRecordPlayer;
import pl.asie.charset.module.audio.storage.ContainerRecordPlayer;
import pl.asie.charset.module.audio.storage.GuiRecordPlayer;
import pl.asie.charset.module.audio.storage.ItemQuartzDisc;
import pl.asie.charset.module.audio.storage.PacketDriveData;
import pl.asie.charset.module.audio.storage.PacketDriveState;
import pl.asie.charset.module.audio.storage.PacketUpdateProgressClient;
import pl.asie.charset.module.audio.storage.TileRecordPlayer;
import pl.asie.charset.module.audio.storage.TileRecordPlayerRenderer;
import pl.asie.charset.module.audio.storage.system.DataStorage;
import pl.asie.charset.module.audio.storage.system.DataStorageCapStorage;
import pl.asie.charset.module.audio.storage.system.DataStorageManager;

@CharsetModule(name="audio.storage", description="Audio storage, recording and playback - Quartz Discs", profile=ModuleProfile.FORCED)
public class CharsetAudioStorage {
    @CapabilityInject(value=IDataStorage.class)
    public static Capability<IDataStorage> DATA_STORAGE;
    @CharsetModule.PacketRegistry
    public static PacketRegistry packet;
    public static DataStorageManager storageManager;
    public static BlockRecordPlayer blockRecordPlayer;
    public static Item itemRecordPlayer;
    public static ItemQuartzDisc quartzDisc;
    public static int PLAYER_LASER_COLOR;

    public static void addTimeToTooltip(List<String> tooltip, int mins, int secs) {
        String secStr = secs + " second" + (secs != 1 ? "s" : "");
        if (mins != 0) {
            tooltip.add(TextFormatting.GRAY + "" + mins + " minute" + (mins != 1 ? "s" : "") + (secs != 0 ? " " + secStr : ""));
        } else {
            tooltip.add(TextFormatting.GRAY + secStr);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onColorPaletteUpdate(ColorPaletteUpdateEvent event) {
        PLAYER_LASER_COLOR = event.getParser().hasColor("charset:laser", "white") ? RenderUtils.asMcIntColor((double[])event.getParser().getColor("charset:laser", "white")) : -1073741825;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(IDataStorage.class, (Capability.IStorage)new DataStorageCapStorage(), DataStorage::new);
        blockRecordPlayer = new BlockRecordPlayer();
        itemRecordPlayer = new ItemBlockBase((Block)blockRecordPlayer);
        quartzDisc = new ItemQuartzDisc();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        RegistryUtils.register(TileRecordPlayer.class, (String)"record_player");
        packet.registerPacket(1, PacketUpdateProgressClient.class);
        packet.registerPacket(2, PacketDriveState.class);
        packet.registerPacket(3, PacketDriveData.class);
        GuiHandlerCharset.INSTANCE.register(259, Side.SERVER, r -> {
            TileEntity tile = r.getTileEntity();
            if (tile instanceof TileRecordPlayer) {
                return new ContainerRecordPlayer((TileRecordPlayer)tile, r.player.field_71071_by);
            }
            return null;
        });
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileRecordPlayer.class, (TileEntitySpecialRenderer)TileRecordPlayerRenderer.INSTANCE);
        GuiHandlerCharset.INSTANCE.register(259, Side.CLIENT, r -> new GuiRecordPlayer((ContainerRecordPlayer)r.getContainer(ContainerRecordPlayer.class)));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        storageManager = new DataStorageManager();
        MinecraftForge.EVENT_BUS.register((Object)storageManager);
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        if (storageManager != null) {
            try {
                storageManager.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            MinecraftForge.EVENT_BUS.unregister((Object)storageManager);
        }
        storageManager = null;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        for (int i = 0; i <= 6; i += 2) {
            RegistryUtils.registerModel((Item)quartzDisc, (int)i, (String)("charset:quartz_disc#inventory_" + (i + 10) + "_blank"));
            RegistryUtils.registerModel((Item)quartzDisc, (int)(i + 1), (String)("charset:quartz_disc#inventory_" + (i + 10)));
        }
        RegistryUtils.registerModel((Item)itemRecordPlayer, (int)0, (String)"charset:record_player#inventory");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        TileRecordPlayerRenderer.INSTANCE.arm = RenderUtils.getModelWithTextures((ResourceLocation)new ResourceLocation("charset:block/record_player_arm"), (TextureMap)event.getMap());
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)blockRecordPlayer, (String)"record_player");
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)itemRecordPlayer, (String)"record_player");
        RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)quartzDisc, (String)"quartz_disc");
    }

    static {
        PLAYER_LASER_COLOR = -1073741825;
    }
}

