/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.items;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import jotato.quantumflux.ConfigMan;
import jotato.quantumflux.QuantumFlux;
import jotato.quantumflux.items.ModItems;
import jotato.quantumflux.util.NbtUtils;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.EnumHelper;

public class ItemBattleSuit
extends ItemArmor
implements IEnergyContainerItem,
ISpecialArmor {
    public static Map<EntityPlayer, Boolean> entitiesFlying = new WeakHashMap<EntityPlayer, Boolean>();
    public static Map<EntityPlayer, Boolean> entitiesRunning = new WeakHashMap<EntityPlayer, Boolean>();
    public static ItemArmor.ArmorMaterial material = EnumHelper.addArmorMaterial((String)"battleSuitMatieral", (int)33, (int[])new int[]{3, 8, 6, 3}, (int)50);
    private static final String energy_tag = "Energy";
    private int energyUsedPerDamageTaken = 150;

    public ItemBattleSuit(String name, int type) {
        super(material, 0, type);
        this.func_77655_b(name);
        this.func_111206_d("quantumflux:" + name);
        this.func_77637_a(QuantumFlux.tab);
        GameRegistry.registerItem((Item)this, (String)name);
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.canRepair = false;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(ItemBattleSuit.newArmorPiece(item, 0, false));
        list.add(ItemBattleSuit.newArmorPiece(item, 0, true));
        list.add(ItemBattleSuit.newArmorPiece(item, 1, true));
    }

    public boolean func_77636_d(ItemStack item) {
        return item.func_77960_j() == 1;
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean p_77624_4_) {
        if (stack.func_77973_b() == ModItems.battlesuit_chest && ItemBattleSuit.isArmorSpecialCapable(stack)) {
            info.add(StatCollector.func_74838_a((String)"tooltip.capabilityFlight"));
        }
        if (stack.func_77973_b() == ModItems.battlesuit_boots && ItemBattleSuit.isArmorSpecialCapable(stack)) {
            info.add(StatCollector.func_74838_a((String)"tooltip.capabilityMomentum"));
        }
        if (stack.func_77973_b() == ModItems.battlesuit_legs && ItemBattleSuit.isArmorSpecialCapable(stack)) {
            info.add(StatCollector.func_74838_a((String)"tooltip.capabilityStrength"));
        }
        if (stack.func_77973_b() == ModItems.battlesuit_helm && ItemBattleSuit.isArmorSpecialCapable(stack)) {
            info.add(StatCollector.func_74838_a((String)"tooltip.capabilityVisibility"));
        }
        info.add(EnumChatFormatting.RED + String.format(StatCollector.func_74838_a((String)"tooltip.charge"), this.getEnergyStored(stack)));
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)NbtUtils.getInt(stack, energy_tag) / (double)this.getMaxEnergyStored(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) < this.getMaxEnergyStored(stack);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "quantumflux:textures/armor/battlesuit_layer_" + (this.field_77881_a == 2 ? "2" : "1") + ".png";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!world.field_72995_K && world.func_82737_E() % 100L == 0L) {
            this.drainArmor(itemStack, player);
        }
        super.onArmorTick(world, player, itemStack);
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int stored = this.getEnergyStored(container);
        int maxICanReceive = Math.min(ConfigMan.battlesuit_maxEnergy - stored, ConfigMan.battlesuit_chargeRate);
        int toGet = Math.min(maxReceive, maxICanReceive);
        if (simulate) {
            return toGet;
        }
        NbtUtils.setInt(container, energy_tag, stored += toGet);
        return toGet;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int stored = this.getEnergyStored(container);
        int toSend = Math.min(maxExtract, stored);
        if (simulate) {
            return toSend;
        }
        NbtUtils.setInt(container, energy_tag, stored -= toSend);
        return toSend;
    }

    public int getEnergyStored(ItemStack container) {
        return NbtUtils.getInt(container, energy_tag);
    }

    public int getMaxEnergyStored(ItemStack container) {
        return ConfigMan.battlesuit_maxEnergy;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        double percentFull = (double)this.getEnergyStored(armor) / (double)this.getMaxEnergyStored(armor);
        int maxToAbsorb = this.getEnergyStored(armor) / this.energyUsedPerDamageTaken * MathHelper.func_76143_f((double)percentFull);
        return new ISpecialArmor.ArmorProperties(1, 0.25, maxToAbsorb);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        double percentFull = (double)this.getEnergyStored(armor) / (double)this.getMaxEnergyStored(armor);
        return percentFull <= 0.0 ? 0 : 1 + MathHelper.func_76143_f((double)(4.0 * percentFull));
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        int totalEnergyCost = damage * this.energyUsedPerDamageTaken;
        this.extractEnergy(stack, totalEnergyCost, false);
    }

    public static ItemStack newArmorPiece(Item item, int meta, boolean charged) {
        if (charged) {
            return NbtUtils.setInt(new ItemStack(item, 1, meta), energy_tag, ConfigMan.battlesuit_maxEnergy);
        }
        return NbtUtils.setInt(new ItemStack(item, 1, meta), energy_tag, 0);
    }

    public static void doSpecial(Side side, int slot, EntityPlayer player) {
        switch (slot) {
            case 0: {
                if (side == Side.CLIENT) {
                    player.field_71075_bZ.func_75092_a(0.12f);
                    entitiesRunning.put(player, true);
                }
                player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 2, 2, true));
                break;
            }
            case 1: {
                player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 2, 1, true));
                player.func_70690_d(new PotionEffect(Potion.field_76422_e.field_76415_H, 2, 1, true));
                break;
            }
            case 2: {
                player.field_71075_bZ.field_75101_c = true;
                entitiesFlying.put(player, true);
                break;
            }
            case 3: {
                player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 220, 0, true));
                player.func_70690_d(new PotionEffect(Potion.field_76427_o.field_76415_H, 2, 0, true));
            }
        }
    }

    public static void removeSpecial(int slot, EntityPlayer player) {
        switch (slot) {
            case 0: {
                if (!entitiesRunning.containsKey(player)) break;
                player.field_71075_bZ.func_75092_a(0.05f);
                player.field_71075_bZ.func_82877_b(0.1f);
                entitiesRunning.remove(player);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (!entitiesFlying.containsKey(player)) break;
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75100_b = false;
                entitiesFlying.remove(player);
                break;
            }
        }
    }

    public static boolean isArmorSpecialCapable(ItemStack armor) {
        return armor.func_77960_j() == 1;
    }

    public void drainArmor(ItemStack item, EntityPlayer player) {
        int used;
        if (ConfigMan.battlesuit_drain > 0 && ItemBattleSuit.isArmorSpecialCapable(item) && (used = this.extractEnergy(item, ConfigMan.battlesuit_drain, false)) == 0) {
            player.func_70097_a(DamageSource.field_76377_j, 0.07f);
        }
    }
}

