/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machine.cluster;

import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import jotato.quantumflux.items.ItemBlockBase;
import jotato.quantumflux.machine.cluster.BlockQuibitCluster;
import jotato.quantumflux.machine.cluster.QuibitClusterSettings;
import jotato.quantumflux.util.NbtUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class ItemBlockQuibitCluster
extends ItemBlockBase
implements IEnergyContainerItem {
    private static final String energy_tag = "Energy";

    public ItemBlockQuibitCluster(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    public int func_77647_b(int i) {
        return i;
    }

    @Override
    public boolean hasAdvancedTooltip() {
        return true;
    }

    @Override
    public void addSimpleTooltipInformation(ItemStack itemstack, EntityPlayer player, List list) {
        list.add(StatCollector.func_74838_a((String)"tooltip.quibitcluster.help"));
        list.add(EnumChatFormatting.RED + String.format(StatCollector.func_74838_a((String)"tooltip.charge"), this.getEnergyStored(itemstack)));
    }

    @Override
    public void addAdvancedTooltipInformation(ItemStack itemstack, EntityPlayer player, List list) {
        QuibitClusterSettings s = BlockQuibitCluster.getQuibitClusterSettings(itemstack);
        list.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tooltip.quibitcluster.capacity", (Object[])new Object[]{s.getCapacityFormatted()}));
        list.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tooltip.quibitcluster.transfer", (Object[])new Object[]{s.getTransferRateFormatted()}));
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int stored = this.getEnergyStored(container);
        int toReceive = Math.min(maxReceive, Math.min(this.getMaxEnergyStored(container) - stored, this.getTransferRate(container)));
        if (!simulate) {
            NbtUtils.setInt(container, energy_tag, stored += toReceive);
        }
        return toReceive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int stored = this.getEnergyStored(container);
        int toExtract = Math.min(maxExtract, stored);
        if (!simulate) {
            NbtUtils.setInt(container, energy_tag, stored -= toExtract);
        }
        return toExtract;
    }

    public int getEnergyStored(ItemStack container) {
        return NbtUtils.getInt(container, energy_tag);
    }

    public int getMaxEnergyStored(ItemStack container) {
        return BlockQuibitCluster.getQuibitClusterSettings((ItemStack)container).capacity;
    }

    public int getTransferRate(ItemStack container) {
        return BlockQuibitCluster.getQuibitClusterSettings((ItemStack)container).transferRate;
    }

    public void setEnergyStored(ItemStack container, int energy) {
        NbtUtils.setInt(container, energy_tag, energy);
    }
}

