/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machine.fabricator;

import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.util.ComparableItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jotato.quantumflux.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ItemFabricatorRecipeManager {
    private static Map<List<ComparableItemStack>, InfuserRecipe> recipeMap = new HashMap<List<ComparableItemStack>, InfuserRecipe>();

    public static void addDefaultRecipes() {
        ItemFabricatorRecipeManager.addRecipe(new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Blocks.field_150371_ca), new ItemStack(ModItems.silica, 4));
        ItemFabricatorRecipeManager.addRecipe(new ItemStack(ModItems.silica), new ItemStack(Items.field_151121_aF), new ItemStack(ModItems.blankCircuit));
        ItemFabricatorRecipeManager.addRecipe("ingotTitanium", new ItemStack(Items.field_151128_bU), new ItemStack(ModItems.mysticQuartz));
        ItemFabricatorRecipeManager.addRecipe(new ItemStack(ModItems.mysticQuartz), new ItemStack(ModItems.blankCircuit), new ItemStack(ModItems.advancedCircuit));
        ItemFabricatorRecipeManager.addRecipe(new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151137_ax), new ItemStack(ModItems.enderCrystal));
    }

    public static Map<List<ComparableItemStack>, InfuserRecipe> getRecipes() {
        return recipeMap;
    }

    public static void refreshRecipes() {
        recipeMap.clear();
        ItemFabricatorRecipeManager.addDefaultRecipes();
    }

    public static InfuserRecipe addRecipe(ItemStack first, ItemStack second, ItemStack result) {
        InfuserRecipe recipe = null;
        if (first == null || second == null || result == null) {
            return recipe;
        }
        recipe = ItemFabricatorRecipeManager.getRecipe(first, second);
        if (recipe == null) {
            recipe = new InfuserRecipe(first, second, result);
            recipeMap.put(Arrays.asList(new ComparableItemStack(first), new ComparableItemStack(second)), recipe);
        }
        return recipe;
    }

    public static InfuserRecipe addRecipe(String first, String second, ItemStack result) {
        ArrayList firstOreList = OreDictionary.getOres((String)first);
        ArrayList secondOreList = OreDictionary.getOres((String)second);
        if (firstOreList.size() > 0 && secondOreList.size() > 0) {
            return ItemFabricatorRecipeManager.addRecipe((ItemStack)firstOreList.get(0), (ItemStack)secondOreList.get(0), result);
        }
        return null;
    }

    public static InfuserRecipe addRecipe(String first, ItemStack second, ItemStack result) {
        ArrayList firstOreList = OreDictionary.getOres((String)first);
        if (firstOreList.size() > 0) {
            return ItemFabricatorRecipeManager.addRecipe(((ItemStack)firstOreList.get(0)).func_77946_l(), second, result);
        }
        return null;
    }

    public static InfuserRecipe getRecipe(ItemStack first, ItemStack second) {
        if (first == null || second == null) {
            return null;
        }
        ComparableItemStack q1 = new ComparableItemStack(first);
        ComparableItemStack q2 = new ComparableItemStack(second);
        InfuserRecipe recipe = recipeMap.get(Arrays.asList(q1, q2));
        if (recipe == null) {
            recipe = recipeMap.get(Arrays.asList(q2, q1));
        }
        return recipe;
    }

    public static class InfuserRecipe {
        private final ItemStack first;
        private final ItemStack second;
        private final ItemStack result;

        public InfuserRecipe(ItemStack first, ItemStack second, ItemStack result) {
            first.field_77994_a = Math.max(first.field_77994_a, 1);
            second.field_77994_a = Math.max(second.field_77994_a, 1);
            result.field_77994_a = Math.max(result.field_77994_a, 1);
            this.first = first;
            this.second = second;
            this.result = result;
        }

        public ItemStack getFirstInput() {
            return this.first.func_77946_l();
        }

        public ItemStack getSecondInput() {
            return this.second.func_77946_l();
        }

        public ItemStack getResult() {
            return this.result.func_77946_l();
        }

        public boolean matches(ItemStack first, ItemStack second) {
            ComparableItemStack orig_first = new ComparableItemStack(this.getFirstInput());
            ComparableItemStack orig_second = new ComparableItemStack(this.getSecondInput());
            ComparableItemStack new_first = new ComparableItemStack(first);
            ComparableItemStack new_second = new ComparableItemStack(second);
            if (orig_first.isEqual((ComparableItem)new_first) && orig_second.isEqual((ComparableItem)new_second)) {
                return true;
            }
            return orig_first.isEqual((ComparableItem)new_second) && orig_second.isEqual((ComparableItem)new_first);
        }
    }
}

