/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machine.zpe;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import jotato.quantumflux.ConfigMan;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityZeroPointExtractor
extends TileEntity
implements IEnergyProvider {
    private EnergyStorage energy = new EnergyStorage(ConfigMan.zpe_maxPowerGen, Integer.MAX_VALUE);

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.energy.writeToNBT(energyTag);
        tag.func_74782_a("Energy", (NBTBase)energyTag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound energyTag = tag.func_74775_l("Energy");
        this.energy.readFromNBT(energyTag);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.energy.receiveEnergy(Math.max(ConfigMan.zpe_maxPowerGen - this.field_145848_d, 1), false);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IEnergyReceiver receiver;
            int targetX = this.field_145851_c + dir.offsetX;
            int targetY = this.field_145848_d + dir.offsetY;
            int targetZ = this.field_145849_e + dir.offsetZ;
            TileEntity tile = this.field_145850_b.func_147438_o(targetX, targetY, targetZ);
            if (!(tile instanceof IEnergyReceiver) || !(receiver = (IEnergyReceiver)tile).canConnectEnergy(dir.getOpposite())) continue;
            int tosend = this.energy.extractEnergy(ConfigMan.zpe_maxPowerGen, true);
            int used = ((IEnergyReceiver)tile).receiveEnergy(dir.getOpposite(), tosend, false);
            if (used > 0) {
                this.func_70296_d();
            }
            this.energy.extractEnergy(used, false);
        }
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.energy.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.energy.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energy.getMaxEnergyStored();
    }
}

