/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.world;

import cofh.lib.world.WorldGenSparseMinableCluster;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import jotato.quantumflux.ConfigMan;
import jotato.quantumflux.blocks.ModBlocks;
import jotato.quantumflux.world.WorldGenInfo;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.OreGenEvent;

public class OreGenerator
implements IWorldGenerator {
    public static final OreGenerator INSTANCE = new OreGenerator();
    private final List<WorldGenInfo> generators = new ArrayList<WorldGenInfo>();

    public OreGenerator() {
        if (ConfigMan.enableTitaniumGen) {
            WorldGenSparseMinableCluster titaniumGen = new WorldGenSparseMinableCluster(new ItemStack(ModBlocks.titaniumOre), 4, Blocks.field_150348_b);
            this.generators.add(new WorldGenInfo((WorldGenerator)titaniumGen, 7, 13, 6, 0.2));
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        for (WorldGenInfo gen : this.generators) {
            this.genOre(gen, world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void genOre(WorldGenInfo info, World world, Random random, int x, int z) {
        OreGenEvent.GenerateMinable event = new OreGenEvent.GenerateMinable(world, random, info.generator, x, z, OreGenEvent.GenerateMinable.EventType.CUSTOM);
        MinecraftForge.ORE_GEN_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        for (int i = 0; i < info.chances; ++i) {
            if (!(random.nextDouble() < info.rarity)) continue;
            int avgX = x + random.nextInt(16);
            int avgY = info.minY + random.nextInt(info.maxY - info.minY) + 1;
            int avgZ = z + random.nextInt(16);
            info.generator.func_76484_a(world, random, avgX, avgY, avgZ);
        }
    }
}

