/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.signs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.beans.ConstructorProperties;
import java.util.List;
import logisticspipes.modules.ModuleCrafter;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.cpipe.CPipeSatelliteImportBack;
import logisticspipes.pipes.PipeItemsCraftingLogistics;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.signs.IPipeSign;
import logisticspipes.pipes.signs.IPipeSignData;
import logisticspipes.renderer.LogisticsRenderPipe;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class CraftingPipeSign
implements IPipeSign {
    public CoreRoutedPipe pipe;
    public ForgeDirection dir;

    @Override
    public boolean isAllowedFor(CoreRoutedPipe pipe) {
        return pipe instanceof PipeItemsCraftingLogistics;
    }

    @Override
    public void addSignTo(CoreRoutedPipe pipe, ForgeDirection dir, EntityPlayer player) {
        pipe.addPipeSign(dir, new CraftingPipeSign(), player);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public ModernPacket getPacket() {
        PipeItemsCraftingLogistics cpipe = (PipeItemsCraftingLogistics)this.pipe;
        return PacketHandler.getPacket(CPipeSatelliteImportBack.class).setInventory(cpipe.getDummyInventory()).setType(LogisticsModule.ModulePositionType.IN_PIPE).setPosX(cpipe.getX()).setPosY(cpipe.getY()).setPosZ(cpipe.getZ());
    }

    @Override
    public void updateServerSide() {
    }

    @Override
    public void init(CoreRoutedPipe pipe, ForgeDirection dir) {
        this.pipe = pipe;
        this.dir = dir;
    }

    @Override
    public void activate(EntityPlayer player) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(CoreRoutedPipe pipe, LogisticsRenderPipe renderer) {
        PipeItemsCraftingLogistics cpipe = (PipeItemsCraftingLogistics)pipe;
        FontRenderer var17 = renderer.func_147498_b();
        if (cpipe != null) {
            List<ItemIdentifierStack> craftables = cpipe.getCraftedItems();
            String name = "";
            if (craftables != null && craftables.size() > 0) {
                ItemStack itemstack = craftables.get(0).unsafeMakeNormalStack();
                renderer.renderItemStackOnSign(itemstack);
                Item item = itemstack.func_77973_b();
                GL11.glDepthMask((boolean)false);
                GL11.glRotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.5f, (float)0.08f, (float)0.0f);
                GL11.glScalef((float)0.011111111f, (float)0.011111111f, (float)0.011111111f);
                try {
                    name = item.func_77653_i(itemstack);
                }
                catch (Exception e) {
                    try {
                        name = item.func_77658_a();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                var17.func_78276_b("ID: " + String.valueOf(Item.func_150891_b((Item)item)), -var17.func_78256_a("ID: " + String.valueOf(Item.func_150891_b((Item)item))) / 2, -20, 0);
                ModuleCrafter logisticsMod = cpipe.getLogisticsModule();
                if (logisticsMod.satelliteId != 0) {
                    var17.func_78276_b("Sat ID: " + String.valueOf(logisticsMod.satelliteId), -var17.func_78256_a("Sat ID: " + String.valueOf(logisticsMod.satelliteId)) / 2, -10, 0);
                }
            } else {
                GL11.glRotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.5f, (float)0.08f, (float)0.0f);
                GL11.glScalef((float)0.011111111f, (float)0.011111111f, (float)0.011111111f);
                name = "Empty";
            }
            name = renderer.cut(name, var17);
            var17.func_78276_b(name, -var17.func_78256_a(name) / 2 - 15, 10, 0);
            GL11.glDepthMask((boolean)true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public IPipeSignData getRenderData(CoreRoutedPipe pipe) {
        PipeItemsCraftingLogistics cpipe = (PipeItemsCraftingLogistics)pipe;
        if (cpipe != null) {
            List<ItemIdentifierStack> craftables = cpipe.getCraftedItems();
            if (craftables != null && craftables.size() > 0) {
                ItemIdentifierStack itemIdentifierStack = craftables.get(0);
                ModuleCrafter logisticsMod = cpipe.getLogisticsModule();
                return new CraftingPipeSignData(itemIdentifierStack, logisticsMod.satelliteId);
            }
            return new CraftingPipeSignData(null, -1);
        }
        return null;
    }

    private static class CraftingPipeSignData
    implements IPipeSignData {
        private final ItemIdentifierStack item;
        private final int satID;

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean isListCompatible(LogisticsRenderPipe render) {
            return this.item == null || this.item.getItem().isRenderListCompatible(render);
        }

        @ConstructorProperties(value={"item", "satID"})
        public CraftingPipeSignData(ItemIdentifierStack item, int satID) {
            this.item = item;
            this.satID = satID;
        }

        public ItemIdentifierStack getItem() {
            return this.item;
        }

        public int getSatID() {
            return this.satID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CraftingPipeSignData)) {
                return false;
            }
            CraftingPipeSignData other = (CraftingPipeSignData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ItemIdentifierStack this$item = this.getItem();
            ItemIdentifierStack other$item = other.getItem();
            if (this$item == null ? other$item != null : !((Object)this$item).equals(other$item)) {
                return false;
            }
            return this.getSatID() == other.getSatID();
        }

        protected boolean canEqual(Object other) {
            return other instanceof CraftingPipeSignData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ItemIdentifierStack $item = this.getItem();
            result = result * 59 + ($item == null ? 0 : ((Object)$item).hashCode());
            result = result * 59 + this.getSatID();
            return result;
        }

        public String toString() {
            return "CraftingPipeSign.CraftingPipeSignData(item=" + this.getItem() + ", satID=" + this.getSatID() + ")";
        }
    }
}

