/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.flower;

import binnie.botany.Botany;
import binnie.botany.api.EnumFlowerStage;
import binnie.botany.api.IFlower;
import binnie.botany.api.IFlowerType;
import binnie.botany.core.BotanyCore;
import binnie.botany.flower.RendererBotany;
import binnie.botany.flower.TileEntityFlower;
import binnie.botany.gardening.Gardening;
import binnie.botany.genetics.EnumFlowerType;
import binnie.core.BinnieCore;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFlower
extends BlockContainer {
    public int func_149645_b() {
        return RendererBotany.renderID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        for (EnumFlowerType type : EnumFlowerType.values()) {
            type.registerIcons(par1IconRegister);
        }
    }

    public BlockFlower() {
        super(Material.field_151585_k);
        float f = 0.2f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 3.0f, 0.5f + f);
        this.func_149675_a(true);
        this.func_149663_c("flower");
    }

    public TileEntity func_149915_a(World var1, int i) {
        return new TileEntityFlower();
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        super.func_149689_a(world, x, y, z, living, stack);
        TileEntity flower = world.func_147438_o(x, y, z);
        if (!BinnieCore.proxy.isSimulating(world)) {
            if (flower != null && flower instanceof TileEntityFlower) {
                IFlower f = BotanyCore.getFlowerRoot().getMember(stack);
                ((TileEntityFlower)flower).setRender(new TileEntityFlower.RenderInfo(f, (TileEntityFlower)flower));
            }
            return;
        }
        TileEntity below = world.func_147438_o(x, y - 1, z);
        if (flower != null && flower instanceof TileEntityFlower) {
            if (below instanceof TileEntityFlower) {
                ((TileEntityFlower)flower).setSection(((TileEntityFlower)below).getSection());
            } else {
                GameProfile owner = living instanceof EntityPlayer ? ((EntityPlayer)living).func_146103_bH() : null;
                ((TileEntityFlower)flower).create(stack, owner);
            }
        }
        Gardening.tryGrowSection(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityFlower) {
            TileEntityFlower f = (TileEntityFlower)tile;
            EnumFlowerStage stage = f.getAge() == 0 ? EnumFlowerStage.SEED : EnumFlowerStage.FLOWER;
            IFlowerType flower = f.getType();
            int section = f.getRenderSection();
            boolean flowered = f.isFlowered();
            return RendererBotany.pass == 0 ? flower.getStem(stage, flowered, section) : (RendererBotany.pass == 1 ? flower.getPetalIcon(stage, flowered, section) : flower.getVariantIcon(stage, flowered, section));
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityFlower) {
            TileEntityFlower f = (TileEntityFlower)tile;
            return RendererBotany.pass == 0 ? f.getStemColour() : (RendererBotany.pass == 1 ? f.getPrimaryColour() : f.getSecondaryColour());
        }
        return 0xFFFFFF;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) && this.func_149718_j(world, x, y, z);
    }

    protected boolean canPlaceBlockOn(Block block) {
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak || Gardening.isSoil(block);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntityFlower flower;
        super.func_149695_a(world, x, y, z, block);
        this.checkAndDropBlock(world, x, y, z);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityFlower && (flower = (TileEntityFlower)tile).getSection() == 0 && flower.getFlower() != null && flower.getFlower().getAge() > 0 && flower.getFlower().getGenome().getPrimary().getType().getSections() > 1 && world.func_147439_a(x, y + 1, z) != Botany.flower) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileEntityFlower)) {
            world.func_147468_f(x, y, z);
            return;
        }
        ((TileEntityFlower)tile).randomUpdate(rand);
        this.checkAndDropBlock(world, x, y, z);
    }

    protected void checkAndDropBlock(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityFlower && ((TileEntityFlower)tile).getSection() > 0) {
            return world.func_147439_a(x, y - 1, z) == Botany.flower;
        }
        return this.canPlaceBlockOn(world.func_147439_a(x, y - 1, z));
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int blockMeta, int fortune) {
        ItemStack flower;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityFlower && ((TileEntityFlower)tile).getSection() == 0 && (flower = ((TileEntityFlower)tile).getItemStack()) != null) {
            drops.add(flower);
        }
        return drops;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        ArrayList<ItemStack> drops = this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
        boolean hasBeenBroken = world.func_147468_f(x, y, z);
        if (hasBeenBroken && BinnieCore.proxy.isSimulating(world) && drops.size() > 0 && (player == null || !player.field_71075_bZ.field_75098_d)) {
            for (ItemStack drop : drops) {
                this.func_149642_a(world, x, y, z, drop);
            }
        }
        return hasBeenBroken;
    }
}

