/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.Binnie;
import binnie.core.machines.Machine;
import binnie.core.machines.MachinePackage;
import binnie.core.machines.base.TileEntityMachineBase;
import binnie.core.machines.component.IInteraction;
import binnie.core.network.INetworkedEntity;
import binnie.core.network.packet.PacketPayload;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;

public class TileEntityMachine
extends TileEntityMachineBase
implements INetworkedEntity {
    private Machine machine;

    public void func_145845_h() {
        super.func_145845_h();
        if (this.machine != null) {
            this.machine.onUpdate();
        }
    }

    public boolean canUpdate() {
        return super.canUpdate();
    }

    public TileEntityMachine(MachinePackage pack) {
        this.setMachine(pack);
    }

    public TileEntityMachine() {
    }

    public void setMachine(MachinePackage pack) {
        if (pack != null) {
            this.machine = new Machine(pack, this);
        }
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        String name = nbtTagCompound.func_74779_i("name");
        String group = nbtTagCompound.func_74779_i("group");
        MachinePackage pack = Binnie.Machine.getPackage(group, name);
        if (pack == null) {
            this.func_145843_s();
            return;
        }
        this.setMachine(pack);
        this.getMachine().readFromNBT(nbtTagCompound);
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        String name = this.machine.getPackage().getUID();
        String group = this.machine.getPackage().getGroup().getUID();
        nbtTagCompound.func_74778_a("group", group);
        nbtTagCompound.func_74778_a("name", name);
        this.getMachine().writeToNBT(nbtTagCompound);
    }

    @Override
    public void writeToPacket(PacketPayload payload) {
        this.machine.writeToPacket(payload);
    }

    @Override
    public void readFromPacket(PacketPayload payload) {
        this.machine.readFromPacket(payload);
    }

    public Machine getMachine() {
        return this.machine;
    }

    public void onBlockDestroy() {
        if (this.getMachine() != null) {
            this.getMachine().onBlockDestroy();
        }
    }

    public final Packet func_145844_m() {
        return this.getMachine() != null ? this.getMachine().getDescriptionPacket() : null;
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (IInteraction.Invalidation c : this.getMachine().getInterfaces(IInteraction.Invalidation.class)) {
            c.onInvalidation();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        for (IInteraction.ChunkUnload c : this.getMachine().getInterfaces(IInteraction.ChunkUnload.class)) {
            c.onChunkUnload();
        }
    }
}

