/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.power;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public enum PowerSystem {
    MJ(100.0),
    RF(10.0),
    EU(40.0);

    double conversion;

    private PowerSystem(double conversion) {
        this.conversion = conversion;
    }

    public double convertTo(int value) {
        return (double)value / this.conversion;
    }

    public int convertFrom(double value) {
        return (int)(value * this.conversion);
    }

    public static PowerSystem get(int i) {
        return PowerSystem.values()[i % PowerSystem.values().length];
    }

    public String getUnitName() {
        return this.name();
    }

    public ItemStack saveTo(ItemStack stack) {
        NBTTagCompound tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        tag.func_74774_a("power-system", (byte)this.ordinal());
        stack.func_77982_d(tag);
        return stack;
    }
}

