/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.botany;

import binnie.Binnie;
import binnie.botany.Botany;
import binnie.botany.api.IFlowerColour;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.core.AbstractMod;
import binnie.craftgui.botany.ControlColourOption;
import binnie.craftgui.botany.PageColourMix;
import binnie.craftgui.botany.PageColourMixResultant;
import binnie.craftgui.botany.PageSpeciesFlowerGenome;
import binnie.craftgui.controls.listbox.ControlList;
import binnie.craftgui.controls.listbox.ControlListBox;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.mod.database.DatabaseTab;
import binnie.craftgui.mod.database.IDatabaseMode;
import binnie.craftgui.mod.database.PageBranchOverview;
import binnie.craftgui.mod.database.PageBranchSpecies;
import binnie.craftgui.mod.database.PageBreeder;
import binnie.craftgui.mod.database.PageSpeciesClassification;
import binnie.craftgui.mod.database.PageSpeciesMutations;
import binnie.craftgui.mod.database.PageSpeciesOverview;
import binnie.craftgui.mod.database.PageSpeciesResultant;
import binnie.craftgui.mod.database.WindowAbstractDatabase;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;

public class WindowBotanistDatabase
extends WindowAbstractDatabase {
    ControlListBox<EnumFlowerColor> selectionBoxColors;

    public WindowBotanistDatabase(EntityPlayer player, Side side, boolean nei) {
        super(player, side, nei, Binnie.Genetics.flowerBreedingSystem, 130.0f);
    }

    public static Window create(EntityPlayer player, Side side, boolean nei) {
        return new WindowBotanistDatabase(player, side, nei);
    }

    @Override
    protected void addTabs() {
        new PageSpeciesOverview((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.Species), new DatabaseTab(Botany.instance, "species.overview", 0));
        new PageSpeciesFlowerGenome((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.Species), new DatabaseTab(Botany.instance, "species.genome", 0));
        new PageSpeciesClassification((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.Species), new DatabaseTab(Botany.instance, "species.classification", 0));
        new PageSpeciesResultant((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.Species), new DatabaseTab(Botany.instance, "species.resultant", 0));
        new PageSpeciesMutations((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.Species), new DatabaseTab(Botany.instance, "species.further", 0));
        new PageBranchOverview((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.Branches), new DatabaseTab(Botany.instance, "branches.overview", 0));
        new PageBranchSpecies((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.Branches), new DatabaseTab(Botany.instance, "branches.species", 0));
        this.createMode(FlowerMode.Colour, new WindowAbstractDatabase.ModeWidgets(FlowerMode.Colour, this){

            @Override
            public void createListBox(IArea area) {
                this.listBox = new ControlListBox<IFlowerColour>((IWidget)this.modePage, area.x(), area.y(), area.w(), area.h(), 12.0f){

                    @Override
                    public IWidget createOption(IFlowerColour value, int y) {
                        return new ControlColourOption((ControlList)this.getContent(), value, y);
                    }
                };
                ArrayList<EnumFlowerColor> colors = new ArrayList<EnumFlowerColor>();
                for (EnumFlowerColor c : EnumFlowerColor.values()) {
                    colors.add(c);
                }
                this.listBox.setOptions(colors);
            }
        });
        new PageColourMixResultant((IWidget)this.getInfoPages(FlowerMode.Colour), new DatabaseTab(Botany.instance, "colour.resultant", 0));
        new PageColourMix((IWidget)this.getInfoPages(FlowerMode.Colour), new DatabaseTab(Botany.instance, "colour.further", 0));
        new PageBreeder(this.getInfoPages(WindowAbstractDatabase.Mode.Breeder), this.getUsername(), new DatabaseTab(Botany.instance, "breeder", 0));
    }

    @Override
    protected AbstractMod getMod() {
        return Botany.instance;
    }

    @Override
    protected String getName() {
        return "FlowerDatabase";
    }

    static enum FlowerMode implements IDatabaseMode
    {
        Colour;


        @Override
        public String getName() {
            return Botany.proxy.localise("gui.database.mode." + this.name().toLowerCase());
        }
    }
}

