/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft.control;

import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.inventory.SlotValidator;
import binnie.craftgui.core.CraftGUI;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.minecraft.CustomSlot;
import binnie.craftgui.minecraft.GuiCraftGUI;
import binnie.craftgui.minecraft.InventoryType;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.minecraft.WindowInventory;
import binnie.craftgui.minecraft.control.ControlPlayerInventory;
import binnie.craftgui.minecraft.control.ControlSlotArray;
import binnie.craftgui.minecraft.control.ControlSlotBase;
import binnie.craftgui.minecraft.control.EnumHighlighting;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ControlSlot
extends ControlSlotBase {
    public static Map<EnumHighlighting, List<Integer>> highlighting = new HashMap<EnumHighlighting, List<Integer>>();
    public static boolean shiftClickActive = false;
    public Slot slot = null;

    public ControlSlot(IWidget parent, float x, float y) {
        super(parent, x, y);
        this.addSelfEventHandler((EventHandler)new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                if (ControlSlot.this.slot != null) {
                    PlayerControllerMP playerControllerMP = ((Window)ControlSlot.this.getSuperParent()).getGui().getMinecraft().field_71442_b;
                    int n = ((Window)ControlSlot.this.getSuperParent()).getContainer().field_75152_c;
                    int n2 = ControlSlot.this.slot.field_75222_d;
                    int n3 = event.getButton();
                    ((Window)Window.get(ControlSlot.this.getWidget())).getGui();
                    playerControllerMP.func_78753_a(n, n2, n3, GuiCraftGUI.func_146272_n() ? 1 : 0, (EntityPlayer)((Window)ControlSlot.this.getSuperParent()).getGui().getMinecraft().field_71439_g);
                }
            }
        });
    }

    public ControlSlot(IWidget parent, int x, int y, Slot slot) {
        super(parent, x, y);
        this.slot = slot;
    }

    @Override
    public void onRenderBackground() {
        IIcon icon;
        CraftGUI.Render.texture((Object)CraftGUITexture.Slot, IPoint.ZERO);
        if (this.slot == null) {
            return;
        }
        InventorySlot islot = this.getInventorySlot();
        if (islot != null && islot.getValidator() != null && (icon = islot.getValidator().getIcon(!islot.getInputSides().isEmpty())) != null) {
            CraftGUI.Render.iconItem(new IPoint(1.0f, 1.0f), icon);
        }
        boolean highlighted = false;
        for (Map.Entry<EnumHighlighting, List<Integer>> highlight : highlighting.entrySet()) {
            if (highlight.getKey() == EnumHighlighting.ShiftClick && !shiftClickActive || highlighted || !highlight.getValue().contains(this.slot.field_75222_d)) continue;
            highlighted = true;
            int c = -1442840576 + Math.min(highlight.getKey().getColour(), 0xFFFFFF);
            CraftGUI.Render.gradientRect(new IArea(1.0f, 1.0f, 16.0f, 16.0f), c, c);
        }
        if (!highlighted && this.getSuperParent().getMousedOverWidget() == this) {
            if (((Window)Window.get(this)).getGui().getDraggedItem() != null && !this.slot.func_75214_a(((Window)Window.get(this)).getGui().getDraggedItem())) {
                CraftGUI.Render.gradientRect(new IArea(1.0f, 1.0f, 16.0f, 16.0f), -1426089575, -1426089575);
            } else {
                CraftGUI.Render.gradientRect(new IArea(1.0f, 1.0f, 16.0f, 16.0f), -2130706433, -2130706433);
            }
        }
    }

    @Override
    public void onRenderOverlay() {
        if (this.slot == null) {
            return;
        }
        boolean highlighted = false;
        for (Map.Entry<EnumHighlighting, List<Integer>> highlight : highlighting.entrySet()) {
            if (highlight.getKey() == EnumHighlighting.ShiftClick && !shiftClickActive || highlighted || !highlight.getValue().contains(this.slot.field_75222_d)) continue;
            highlighted = true;
            int c = highlight.getKey().getColour();
            IArea area = this.getArea();
            if (this.getParent() instanceof ControlSlotArray || this.getParent() instanceof ControlPlayerInventory) {
                area = this.getParent().getArea();
                area.setPosition(IPoint.ZERO.sub(this.getPosition()));
            }
            CraftGUI.Render.colour(c);
            CraftGUI.Render.texture((Object)CraftGUITexture.Outline, area.outset(1));
        }
    }

    @Override
    public void onUpdateClient() {
        super.onUpdateClient();
        if (this.slot == null) {
            return;
        }
        if (this.isMouseOver() && GuiScreen.func_146272_n()) {
            ((Window)Window.get(this)).getContainer().setMouseOverSlot(this.slot);
            shiftClickActive = true;
        }
        if (((Window)Window.get(this)).getGui().isHelpMode() && this.isMouseOver()) {
            for (ControlSlot slot2 : this.getControlSlots()) {
                if (slot2.slot == null) continue;
                highlighting.get((Object)EnumHighlighting.Help).add(slot2.slot.field_75222_d);
            }
        }
    }

    private List<ControlSlot> getControlSlots() {
        ArrayList<ControlSlot> slots = new ArrayList<ControlSlot>();
        if (this.getParent() instanceof ControlSlotArray || this.getParent() instanceof ControlPlayerInventory) {
            for (IWidget child : this.getParent().getWidgets()) {
                slots.add((ControlSlot)child);
            }
        } else {
            slots.add(this);
        }
        return slots;
    }

    @Override
    public ItemStack getItemStack() {
        if (this.slot != null) {
            return this.slot.func_75211_c();
        }
        return null;
    }

    public ControlSlot assign(int index) {
        return this.assign(InventoryType.Machine, index);
    }

    public ControlSlot assign(InventoryType inventory, int index) {
        if (this.slot != null) {
            return this;
        }
        this.slot = ((Window)this.getSuperParent()).getContainer().getOrCreateSlot(inventory, index);
        return this;
    }

    @Override
    public void getHelpTooltip(Tooltip tooltip) {
        if (this.slot == null) {
            return;
        }
        InventorySlot slot = this.getInventorySlot();
        if (this.getInventorySlot() != null) {
            tooltip.add(slot.getName());
            tooltip.add("Insert Side: " + MachineSide.asString(slot.getInputSides()));
            tooltip.add("Extract Side: " + MachineSide.asString(slot.getOutputSides()));
            if (slot.isReadOnly()) {
                tooltip.add("Pickup Only Slot");
            }
            tooltip.add("Accepts: " + (slot.getValidator() == null ? "Any Item" : slot.getValidator().getTooltip()));
        } else if (this.slot.field_75224_c instanceof WindowInventory) {
            SlotValidator s = ((WindowInventory)this.slot.field_75224_c).getValidator(this.slot.getSlotIndex());
            tooltip.add("Accepts: " + (s == null ? "Any Item" : s.getTooltip()));
        } else if (this.slot.field_75224_c instanceof InventoryPlayer) {
            tooltip.add("Player Inventory");
        }
    }

    public InventorySlot getInventorySlot() {
        return this.slot instanceof CustomSlot ? ((CustomSlot)this.slot).getInventorySlot() : null;
    }

    static {
        for (EnumHighlighting h : EnumHighlighting.values()) {
            highlighting.put(h, new ArrayList());
        }
    }
}

