/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.extratrees.api.IDesign;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.api.IDesignSystem;
import binnie.extratrees.api.ILayout;
import binnie.extratrees.api.IToolHammer;
import binnie.extratrees.carpentry.BlockCarpentryPanel;
import binnie.extratrees.carpentry.EnumDesign;
import binnie.extratrees.carpentry.ModuleCarpentry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DesignBlock {
    IDesign design;
    IDesignMaterial primaryMaterial;
    IDesignMaterial secondaryMaterial;
    int rotation = 0;
    ForgeDirection facing = ForgeDirection.UP;
    boolean panel = false;

    public String toString() {
        return super.toString() + " { design:" + this.design + " }, { primary:" + this.primaryMaterial + " }, { secondary:" + this.secondaryMaterial + " }, { rotation:" + this.rotation + " }, { facing:" + this.facing + " }";
    }

    public IDesign getDesign() {
        return this.design;
    }

    public IDesignMaterial getPrimaryMaterial() {
        return this.primaryMaterial;
    }

    public IDesignMaterial getSecondaryMaterial() {
        return this.secondaryMaterial;
    }

    DesignBlock(IDesignSystem system, IDesignMaterial primaryWood, IDesignMaterial secondaryWood, IDesign design, int rotation, ForgeDirection dir) {
        this.design = design;
        this.primaryMaterial = primaryWood;
        this.secondaryMaterial = secondaryWood;
        this.rotation = rotation;
        this.facing = dir;
        if (design == null) {
            this.design = EnumDesign.Blank;
        }
        if (primaryWood == null) {
            this.primaryMaterial = system.getDefaultMaterial();
        }
        if (secondaryWood == null) {
            this.secondaryMaterial = system.getDefaultMaterial();
        }
        if (this.rotation > 3 || this.rotation < 0) {
            this.rotation = 0;
        }
        if (this.facing == null || this.facing == ForgeDirection.UNKNOWN) {
            this.facing = ForgeDirection.UP;
        }
    }

    public int getPrimaryColour() {
        return this.getPrimaryMaterial().getColour();
    }

    public int getSecondaryColour() {
        return this.getSecondaryMaterial().getColour();
    }

    ForgeDirection getRotation(ForgeDirection dir, ModuleCarpentry.Axis axis) {
        if (axis == ModuleCarpentry.Axis.Y) {
            switch (dir) {
                case EAST: {
                    return ForgeDirection.NORTH;
                }
                case NORTH: {
                    return ForgeDirection.WEST;
                }
                case SOUTH: {
                    return ForgeDirection.EAST;
                }
                case WEST: {
                    return ForgeDirection.SOUTH;
                }
            }
            return dir;
        }
        if (axis == ModuleCarpentry.Axis.X) {
            switch (dir) {
                case EAST: {
                    return ForgeDirection.UP;
                }
                case UP: {
                    return ForgeDirection.WEST;
                }
                case WEST: {
                    return ForgeDirection.DOWN;
                }
                case DOWN: {
                    return ForgeDirection.EAST;
                }
            }
            return dir;
        }
        switch (dir) {
            case SOUTH: {
                return ForgeDirection.UP;
            }
            case UP: {
                return ForgeDirection.NORTH;
            }
            case NORTH: {
                return ForgeDirection.DOWN;
            }
            case DOWN: {
                return ForgeDirection.SOUTH;
            }
        }
        return dir;
    }

    public ILayout getLayout(ForgeDirection dir) {
        ILayout layout;
        ForgeDirection adjustedDir = dir = dir.getRotation(ForgeDirection.DOWN);
        switch (this.getFacing()) {
            case DOWN: {
                adjustedDir = adjustedDir.getRotation(ForgeDirection.EAST);
                adjustedDir = adjustedDir.getRotation(ForgeDirection.EAST);
                break;
            }
            case EAST: {
                adjustedDir = adjustedDir.getRotation(ForgeDirection.EAST);
                adjustedDir = adjustedDir.getRotation(ForgeDirection.NORTH);
                break;
            }
            case NORTH: {
                adjustedDir = adjustedDir.getRotation(ForgeDirection.EAST);
                adjustedDir = adjustedDir.getRotation(ForgeDirection.SOUTH);
                adjustedDir = adjustedDir.getRotation(ForgeDirection.SOUTH);
                break;
            }
            case SOUTH: {
                adjustedDir = adjustedDir.getRotation(ForgeDirection.EAST);
                break;
            }
            case WEST: {
                adjustedDir = adjustedDir.getRotation(ForgeDirection.EAST);
                adjustedDir = adjustedDir.getRotation(ForgeDirection.SOUTH);
                break;
            }
        }
        for (int i = 0; i < this.rotation; ++i) {
            adjustedDir = adjustedDir.getRotation(ForgeDirection.DOWN);
        }
        switch (adjustedDir) {
            case EAST: {
                layout = this.getDesign().getEastPattern();
                break;
            }
            case NORTH: {
                layout = this.getDesign().getNorthPattern();
                break;
            }
            case SOUTH: {
                layout = this.getDesign().getSouthPattern();
                break;
            }
            case WEST: {
                layout = this.getDesign().getWestPattern();
                break;
            }
            case DOWN: {
                layout = this.getDesign().getBottomPattern();
                break;
            }
            default: {
                layout = this.getDesign().getTopPattern();
            }
        }
        block14 : switch (this.getFacing()) {
            case UP: {
                if (dir != ForgeDirection.DOWN && dir != ForgeDirection.UP) break;
                for (int i = 0; i < this.rotation; ++i) {
                    layout = layout.rotateRight();
                }
                break;
            }
            case DOWN: {
                switch (dir) {
                    case UP: 
                    case DOWN: {
                        layout = layout.flipVertical();
                        break;
                    }
                    case EAST: 
                    case NORTH: 
                    case SOUTH: 
                    case WEST: {
                        layout = layout.rotateRight().rotateRight();
                        break;
                    }
                }
                if (dir != ForgeDirection.DOWN && dir != ForgeDirection.UP) break;
                for (int i = 0; i < this.rotation; ++i) {
                    layout = layout.rotateLeft();
                }
                break;
            }
            case EAST: {
                int i;
                switch (dir) {
                    case SOUTH: 
                    case UP: {
                        layout = layout.rotateRight();
                        break;
                    }
                    case NORTH: {
                        layout = layout.rotateLeft();
                        break;
                    }
                    case DOWN: {
                        layout = layout.rotateLeft().flipHorizontal();
                        break;
                    }
                    case WEST: {
                        layout = layout.flipHorizontal();
                        break;
                    }
                }
                if (dir == ForgeDirection.EAST) {
                    for (i = 0; i < this.rotation; ++i) {
                        layout = layout.rotateRight();
                    }
                }
                if (dir != ForgeDirection.WEST) break;
                for (i = 0; i < this.rotation; ++i) {
                    layout = layout.rotateLeft();
                }
                break;
            }
            case WEST: {
                switch (dir) {
                    case NORTH: {
                        layout = layout.rotateRight();
                        break;
                    }
                    case SOUTH: 
                    case UP: {
                        layout = layout.rotateLeft();
                        break;
                    }
                    case DOWN: {
                        layout = layout.rotateLeft().flipVertical();
                        break;
                    }
                    case EAST: {
                        layout = layout.flipHorizontal();
                        for (int i = 0; i < this.rotation; ++i) {
                            layout = layout.rotateLeft();
                        }
                        break block14;
                    }
                    case WEST: {
                        for (int i = 0; i < this.rotation; ++i) {
                            layout = layout.rotateRight();
                        }
                    }
                }
                break;
            }
            case NORTH: {
                switch (dir) {
                    case WEST: {
                        layout = layout.rotateLeft();
                        break;
                    }
                    case EAST: {
                        layout = layout.rotateRight();
                        break;
                    }
                    case DOWN: {
                        layout = layout.flipHorizontal();
                        break;
                    }
                    case SOUTH: {
                        layout = layout.flipHorizontal();
                        for (int i = 0; i < this.rotation; ++i) {
                            layout = layout.rotateLeft();
                        }
                        break block14;
                    }
                    case NORTH: {
                        for (int i = 0; i < this.rotation; ++i) {
                            layout = layout.rotateRight();
                        }
                        break block14;
                    }
                }
                break;
            }
            case SOUTH: {
                switch (dir) {
                    case EAST: {
                        layout = layout.rotateLeft();
                        break;
                    }
                    case WEST: {
                        layout = layout.rotateRight();
                        break;
                    }
                    case UP: {
                        layout = layout.rotateRight().rotateRight();
                        break;
                    }
                    case DOWN: {
                        layout = layout.flipVertical();
                        break;
                    }
                    case NORTH: {
                        layout = layout.flipHorizontal();
                        for (int i = 0; i < this.rotation; ++i) {
                            layout = layout.rotateLeft();
                        }
                        break block14;
                    }
                    case SOUTH: {
                        for (int i = 0; i < this.rotation; ++i) {
                            layout = layout.rotateRight();
                        }
                        break block14;
                    }
                }
                break;
            }
        }
        return layout;
    }

    public IIcon getPrimaryIcon(IDesignSystem system, ForgeDirection dir) {
        ILayout l = this.getLayout(dir);
        return l == null ? null : l.getPrimaryIcon(system);
    }

    public IIcon getSecondaryIcon(IDesignSystem system, ForgeDirection dir) {
        ILayout l = this.getLayout(dir);
        return l == null ? null : l.getSecondaryIcon(system);
    }

    public IIcon getIcon(IDesignSystem system, boolean secondary, ForgeDirection dir) {
        return secondary ? this.getSecondaryIcon(system, dir) : this.getPrimaryIcon(system, dir);
    }

    public ForgeDirection getFacing() {
        return this.facing;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void rotate(int face, ItemStack hammer, EntityPlayer player, World world, int x, int y, int z) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)face);
        IToolHammer hammerI = (IToolHammer)hammer.func_77973_b();
        if (player.func_70093_af()) {
            if (this.panel) {
                ForgeDirection newFacing = this.getFacing();
                do {
                    if ((newFacing = ForgeDirection.getOrientation((int)(newFacing.ordinal() + 1))) != ForgeDirection.UNKNOWN) continue;
                    newFacing = ForgeDirection.DOWN;
                } while (newFacing != this.getFacing() && !BlockCarpentryPanel.isValidPanelPlacement(world, x, y, z, newFacing));
                if (newFacing != this.getFacing()) {
                    hammerI.onHammerUsed(hammer, player);
                }
                this.setFacing(newFacing);
            } else {
                if (dir != this.getFacing()) {
                    hammerI.onHammerUsed(hammer, player);
                }
                this.setFacing(dir);
            }
        } else {
            ++this.rotation;
            hammerI.onHammerUsed(hammer, player);
        }
        if (this.rotation > 3) {
            this.rotation = 0;
        }
        if (this.rotation < 0) {
            this.rotation = 3;
        }
    }

    public void setFacing(ForgeDirection facing) {
        this.facing = facing;
    }

    public int getBlockMetadata(IDesignSystem system) {
        return ModuleCarpentry.getBlockMetadata(system, this);
    }

    public int getItemMetadata(IDesignSystem system) {
        return ModuleCarpentry.getItemMetadata(system, this);
    }

    public void setPanel() {
        this.panel = true;
    }

    public String getString() {
        String type = "";
        type = this.getPrimaryMaterial() != this.getSecondaryMaterial() ? this.getPrimaryMaterial().getName() + " and " + this.getSecondaryMaterial().getName() : this.getPrimaryMaterial().getName();
        return super.toString() + " " + "{" + type + " " + this.getDesign().getName() + " " + (this.panel ? "Panel" : "Tile") + ", Facing:" + this.getFacing().toString() + ", Rotation:" + this.getRotation() + "}";
    }
}

