/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.core.BinnieCore;
import binnie.core.IInitializable;
import binnie.core.block.ItemMetadata;
import binnie.core.block.MultipassItemRenderer;
import binnie.core.block.TileEntityMetadata;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.api.IDesignSystem;
import binnie.extratrees.carpentry.BlockCarpentry;
import binnie.extratrees.carpentry.BlockCarpentryPanel;
import binnie.extratrees.carpentry.BlockDesign;
import binnie.extratrees.carpentry.BlockStainedDesign;
import binnie.extratrees.carpentry.CarpentryInterface;
import binnie.extratrees.carpentry.DesignBlock;
import binnie.extratrees.carpentry.EnumDesign;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class ModuleCarpentry
implements IInitializable {
    @Override
    public void preInit() {
        ExtraTrees.blockCarpentry = new BlockCarpentry();
        ExtraTrees.blockPanel = new BlockCarpentryPanel();
        ExtraTrees.blockStained = new BlockStainedDesign();
        GameRegistry.registerBlock((Block)ExtraTrees.blockCarpentry, ItemMetadata.class, (String)"carpentry");
        GameRegistry.registerBlock((Block)ExtraTrees.blockPanel, ItemMetadata.class, (String)"panel");
        GameRegistry.registerBlock((Block)ExtraTrees.blockStained, ItemMetadata.class, (String)"stainedglass");
        BinnieCore.proxy.registerCustomItemRenderer(Item.func_150898_a((Block)ExtraTrees.blockCarpentry), new MultipassItemRenderer());
        BinnieCore.proxy.registerCustomItemRenderer(Item.func_150898_a((Block)ExtraTrees.blockStained), new MultipassItemRenderer());
        MinecraftForge.EVENT_BUS.register((Object)ExtraTrees.blockCarpentry);
        BinnieCore.proxy.registerCustomItemRenderer(Item.func_150898_a((Block)ExtraTrees.blockPanel), new MultipassItemRenderer());
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        for (EnumDesign design : EnumDesign.values()) {
            CarpentryManager.carpentryInterface.registerDesign(design.ordinal(), design);
        }
    }

    public static ItemStack getItemStack(BlockDesign block, IDesignMaterial type1, IDesignMaterial type2, IDesign design) {
        return ModuleCarpentry.getItemStack(block, block.getDesignSystem().getMaterialIndex(type1), block.getDesignSystem().getMaterialIndex(type2), CarpentryManager.carpentryInterface.getDesignIndex(design));
    }

    public static ItemStack getItemStack(BlockDesign block, int type1, int type2, int design) {
        return TileEntityMetadata.getItemStack((Block)block, ModuleCarpentry.getMetadata(type1, type2, design, 0, ForgeDirection.UP.ordinal()));
    }

    public static ItemStack getItemStack(BlockDesign blockC, DesignBlock block) {
        return ModuleCarpentry.getItemStack(blockC, block.getPrimaryMaterial(), block.getSecondaryMaterial(), block.getDesign());
    }

    public static int getMetadata(int plank1, int plank2, int design, int rotation, int facing) {
        return plank1 + (plank2 << 8) + (design << 16) + (rotation << 26) + (facing << 28);
    }

    public static DesignBlock getDesignBlock(IDesignSystem system, int meta) {
        int damage = meta;
        int plankID1 = damage & 0xFF;
        int plankID2 = damage >> 8 & 0xFF;
        int tile = damage >> 16 & 0x3FF;
        int rotation = damage >> 26 & 3;
        int axis = damage >> 28 & 7;
        IDesignMaterial type1 = system.getMaterial(plankID1);
        IDesignMaterial type2 = system.getMaterial(plankID2);
        IDesign type = CarpentryManager.carpentryInterface.getDesign(tile);
        return new DesignBlock(system, type1, type2, type, rotation, ForgeDirection.getOrientation((int)axis));
    }

    public static DesignBlock getCarpentryPanel(IDesignSystem system, int meta) {
        DesignBlock block = ModuleCarpentry.getDesignBlock(system, meta);
        block.setPanel();
        return block;
    }

    public static int getBlockMetadata(IDesignSystem system, DesignBlock block) {
        int plank1 = system.getMaterialIndex(block.getPrimaryMaterial());
        int plank2 = system.getMaterialIndex(block.getSecondaryMaterial());
        int design = CarpentryManager.carpentryInterface.getDesignIndex(block.getDesign());
        int rotation = block.getRotation();
        int facing = block.getFacing().ordinal();
        return ModuleCarpentry.getMetadata(plank1, plank2, design, rotation, facing);
    }

    public static int getItemMetadata(IDesignSystem system, DesignBlock block) {
        int plank1 = system.getMaterialIndex(block.getPrimaryMaterial());
        int plank2 = system.getMaterialIndex(block.getSecondaryMaterial());
        int design = CarpentryManager.carpentryInterface.getDesignIndex(block.getDesign());
        return ModuleCarpentry.getMetadata(plank1, plank2, design, 0, ForgeDirection.UP.ordinal());
    }

    static {
        CarpentryManager.carpentryInterface = new CarpentryInterface();
    }

    static enum Axis {
        Y,
        X,
        Z;

    }
}

