/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.genetics;

import binnie.core.genetics.Gene;
import binnie.core.network.packet.MessageNBT;
import binnie.genetics.Genetics;
import binnie.genetics.api.IGene;
import binnie.genetics.core.GeneticsPacket;
import com.mojang.authlib.GameProfile;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class GeneTracker
extends WorldSavedData {
    private ArrayList<IGene> discoveredGenes = new ArrayList();
    GameProfile username;

    public GeneTracker(String s, GameProfile username) {
        super(s);
        this.username = username;
    }

    public GeneTracker(String s) {
        super(s);
    }

    protected static GeneTracker getCommonTracker(EntityPlayer player) {
        return GeneTracker.getTracker(player.field_70170_p, null);
    }

    public static GeneTracker getTracker(World world, GameProfile player) {
        String filename = "GeneTracker." + (player == null ? "common" : player.getId());
        GeneTracker tracker = (GeneTracker)world.func_72943_a(GeneTracker.class, filename);
        if (tracker == null) {
            tracker = new GeneTracker(filename, player);
            world.func_72823_a(filename, (WorldSavedData)tracker);
        } else {
            tracker.username = player;
        }
        return tracker;
    }

    public void synchToPlayer(EntityPlayer player) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_76187_b(nbttagcompound);
        Genetics.proxy.sendToPlayer(new MessageNBT(GeneticsPacket.GeneTrackerSync.ordinal(), nbttagcompound), player);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        for (ISpeciesRoot root : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
            if (!nbt.func_74764_b(root.getUID())) continue;
            NBTTagCompound nbtRoot = nbt.func_74775_l(root.getUID());
            for (IChromosomeType chromo : root.getKaryotype()) {
                if (!nbtRoot.func_74764_b("" + chromo.ordinal())) continue;
                NBTTagList nbtChromo = nbtRoot.func_150295_c("" + chromo.ordinal(), 8);
                for (int i = 0; i < nbtChromo.func_74745_c(); ++i) {
                    String uid = nbtChromo.func_150307_f(i);
                    IAllele allele = AlleleManager.alleleRegistry.getAllele(uid);
                    Gene gene = new Gene(allele, chromo, root);
                    if (allele == null || this.discoveredGenes.contains(gene)) continue;
                    this.discoveredGenes.add(gene);
                }
            }
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        for (ISpeciesRoot root : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
            NBTTagCompound nbtRoot = new NBTTagCompound();
            for (IChromosomeType chromo : root.getKaryotype()) {
                NBTTagList nbtChromo = new NBTTagList();
                for (IGene gene : this.discoveredGenes) {
                    if (gene.getSpeciesRoot() != root || gene.getChromosome() != chromo) continue;
                    nbtChromo.func_74742_a((NBTBase)new NBTTagString(gene.getAllele().getUID()));
                }
                nbtRoot.func_74782_a("" + chromo.ordinal(), (NBTBase)nbtChromo);
            }
            nbt.func_74782_a(root.getUID(), (NBTBase)nbtRoot);
        }
    }

    public void registerGene(IGene iGene) {
        if (!this.discoveredGenes.contains(iGene)) {
            this.discoveredGenes.add(iGene);
        }
        this.func_76185_a();
    }

    public int getGenesSequenced() {
        return this.discoveredGenes.size();
    }

    public boolean isSequenced(Gene gene) {
        return this.discoveredGenes.contains(gene);
    }
}

