/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.Binnie;
import binnie.botany.api.IFlower;
import binnie.craftgui.controls.ControlTextCentered;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.minecraft.control.ControlIconDisplay;
import binnie.genetics.gui.ControlAnalystPage;
import binnie.genetics.item.ModuleItem;
import forestry.api.apiculture.IBee;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.ITree;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.IButterfly;
import forestry.plugins.PluginApiculture;
import java.text.DecimalFormat;
import net.minecraftforge.common.EnumPlantType;

public class AnalystPageBiology
extends ControlAnalystPage {
    public AnalystPageBiology(IWidget parent, IArea area, IIndividual ind) {
        super(parent, area);
        int fertility;
        IBee bee;
        this.setColour(26214);
        int y = 4;
        new ControlTextCentered((IWidget)this, y, "\u00a7nBiology").setColour(this.getColour());
        y += 12;
        if (ind instanceof IBee) {
            bee = (IBee)ind;
            if (bee.getGenome().getNocturnal()) {
                new ControlIconDisplay(this, (this.w() - 64.0f) / 2.0f, y, ModuleItem.iconAllDay.getIcon()).addTooltip("Active all day and night");
            } else if (bee.getGenome().getPrimary().isNocturnal()) {
                new ControlIconDisplay(this, (this.w() - 64.0f) / 2.0f, y, ModuleItem.iconNight.getIcon()).addTooltip("Active at night");
            } else {
                new ControlIconDisplay(this, (this.w() - 64.0f) / 2.0f, y, ModuleItem.iconDaytime.getIcon()).addTooltip("Active during the day");
            }
            if (!bee.getGenome().getTolerantFlyer()) {
                new ControlIconDisplay(this, (this.w() - 64.0f) / 2.0f + 24.0f, y, ModuleItem.iconNoRain.getIcon()).addTooltip("Cannot work during rain");
            } else {
                new ControlIconDisplay(this, (this.w() - 64.0f) / 2.0f + 24.0f, y, ModuleItem.iconRain.getIcon()).addTooltip("Can work during rain");
            }
            if (bee.getGenome().getCaveDwelling()) {
                new ControlIconDisplay(this, (this.w() - 64.0f) / 2.0f + 48.0f, y, ModuleItem.iconNoSky.getIcon()).addTooltip("Can work underground");
            } else {
                new ControlIconDisplay(this, (this.w() - 64.0f) / 2.0f + 48.0f, y, ModuleItem.iconSky.getIcon()).addTooltip("Cannot work underground");
            }
            y += 30;
        } else if (ind instanceof IButterfly) {
            IButterfly moth = (IButterfly)ind;
            if (moth.getGenome().getNocturnal()) {
                new ControlIconDisplay(this, (this.w() - 64.0f) / 2.0f, y, ModuleItem.iconAllDay.getIcon()).addTooltip("Active all day and night");
            } else if (moth.getGenome().getPrimary().isNocturnal()) {
                new ControlIconDisplay(this, (this.w() - 64.0f) / 2.0f, y, ModuleItem.iconNight.getIcon()).addTooltip("Active at night");
            } else {
                new ControlIconDisplay(this, (this.w() - 64.0f) / 2.0f, y, ModuleItem.iconDaytime.getIcon()).addTooltip("Active during the day");
            }
            if (!moth.getGenome().getTolerantFlyer()) {
                new ControlIconDisplay(this, (this.w() - 64.0f) / 2.0f + 24.0f, y, ModuleItem.iconNoRain.getIcon()).addTooltip("Cannot work during rain");
            } else {
                new ControlIconDisplay(this, (this.w() - 64.0f) / 2.0f + 24.0f, y, ModuleItem.iconRain.getIcon()).addTooltip("Can work during rain");
            }
            if (moth.getGenome().getFireResist()) {
                new ControlIconDisplay(this, (this.w() - 64.0f) / 2.0f + 48.0f, y, ModuleItem.iconNoFire.getIcon()).addTooltip("Nonflammable");
            } else {
                new ControlIconDisplay(this, (this.w() - 64.0f) / 2.0f + 48.0f, y, ModuleItem.iconFire.getIcon()).addTooltip("Flammable");
            }
            y += 30;
        } else if (ind instanceof ITree) {
            new ControlTextCentered((IWidget)this, y, "\u00a7oSappiness: " + Binnie.Genetics.treeBreedingSystem.getAlleleName((IChromosomeType)EnumTreeChromosome.SAPPINESS, ind.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.SAPPINESS))).setColour(this.getColour());
            y += 20;
        } else {
            y += 10;
        }
        if (ind instanceof IBee) {
            bee = (IBee)ind;
            fertility = bee.getGenome().getFertility();
            new ControlTextCentered((IWidget)this, y, "\u00a7l" + fertility + "\u00a7r drone" + (fertility > 1 ? "s" : "") + " per hive").setColour(this.getColour());
            int lifespan = bee.getGenome().getLifespan() * PluginApiculture.ticksPerBeeWorkCycle;
            new ControlTextCentered((IWidget)this, y += 22, "Average Lifespan").setColour(this.getColour());
            new ControlTextCentered((IWidget)this, y += 12, "\u00a7l" + this.getMCDayString((float)lifespan * (bee.getGenome().getNocturnal() ? 1.0f : 2.0f))).setColour(this.getColour());
            y += 22;
        }
        if (ind instanceof IButterfly) {
            bee = (IButterfly)ind;
            fertility = bee.getGenome().getFertility();
            new ControlTextCentered((IWidget)this, y, "Lays \u00a7l" + fertility + "\u00a7r caterpillar" + (fertility > 1 ? "s" : "") + " before dying").setColour(this.getColour());
            float caterpillarMatureTime = 1365.3999f * (float)Math.round((float)bee.getGenome().getLifespan() / (float)(bee.getGenome().getFertility() * 2));
            new ControlTextCentered((IWidget)this, y += 32, "Caterpillar Gestation").setColour(this.getColour());
            new ControlTextCentered((IWidget)this, y += 12, "\u00a7l" + this.getMCDayString(caterpillarMatureTime)).setColour(this.getColour());
            int speed = (int)(20.0f * bee.getGenome().getSpeed());
            new ControlTextCentered((IWidget)this, y += 22, "Flight Speed").setColour(this.getColour());
            new ControlTextCentered((IWidget)this, y += 12, "\u00a7l" + speed + "\u00a7r blocks per second").setColour(this.getColour());
            y += 22;
        }
        if (ind instanceof ITree) {
            ITree tree = (ITree)ind;
            fertility = (int)(1.0f / tree.getGenome().getFertility());
            new ControlTextCentered((IWidget)this, y, "1 Sapling per \u00a7l" + fertility + "\u00a7r leave" + (fertility > 1 ? "s" : "")).setColour(this.getColour());
            float butterflySpawn = 1365.3999f / (tree.getGenome().getSappiness() * tree.getGenome().getYield() * 0.5f);
            new ControlTextCentered((IWidget)this, y += 22, "Butterfies spawn every\n" + this.getTimeString(butterflySpawn) + " per leaf").setColour(this.getColour());
            new ControlTextCentered((IWidget)this, y += 34, "Plant Types").setColour(this.getColour());
            y += 12;
            for (EnumPlantType type : tree.getGenome().getPlantTypes()) {
                new ControlTextCentered((IWidget)this, y, "\u00a7o" + type.name()).setColour(this.getColour());
                y += 12;
            }
        }
        if (ind instanceof IFlower) {
            IFlower flower = (IFlower)ind;
            float butterflySpawn = 1365.3999f / (flower.getGenome().getSappiness() * 0.2f);
            new ControlTextCentered((IWidget)this, y, "Butterfies spawn every\n" + this.getTimeString(butterflySpawn)).setColour(this.getColour());
            y += 30;
            float CHANCE_DISPERSAL = 0.8f;
            CHANCE_DISPERSAL += 0.2f * (float)flower.getGenome().getFertility();
            float CHANCE_POLLINATE = 0.6f;
            float CHANCE_SELFPOLLINATE = 0.2f * (CHANCE_POLLINATE += 0.25f * (float)flower.getGenome().getFertility());
            if (CHANCE_DISPERSAL > 1.0f) {
                CHANCE_DISPERSAL = 1.0f;
            }
            if (CHANCE_POLLINATE > 1.0f) {
                CHANCE_POLLINATE = 1.0f;
            }
            float dispersalTime = 1365.3999f / CHANCE_DISPERSAL;
            float pollinateTime = 1365.3999f / CHANCE_POLLINATE;
            float lifespan = (float)flower.getMaxAge() * 20.0f * 68.27f / flower.getGenome().getAgeChance();
            float floweringLifespan = (float)(flower.getMaxAge() - 1) * 20.0f * 68.27f / flower.getGenome().getAgeChance();
            new ControlTextCentered((IWidget)this, y, "Average Lifespan").setColour(this.getColour());
            new ControlTextCentered((IWidget)this, y += 12, "\u00a7l" + this.getMCDayString(lifespan)).setColour(this.getColour());
            new ControlTextCentered((IWidget)this, y += 22, "Seed Dispersal").setColour(this.getColour());
            new ControlTextCentered((IWidget)this, y += 12, "\u00a7o" + (int)((floweringLifespan -= 1365.3999f) / dispersalTime) + " per lifetime").setColour(this.getColour());
            new ControlTextCentered((IWidget)this, y += 22, "Pollination").setColour(this.getColour());
            new ControlTextCentered((IWidget)this, y += 12, "\u00a7o" + (int)(floweringLifespan / pollinateTime) + " per lifetime").setColour(this.getColour());
            y += 22;
        }
        this.setSize(new IPoint(this.w(), y));
    }

    private String getMCDayString(float time) {
        float seconds = time / 20.0f;
        float minutes = seconds / 60.0f;
        float days = minutes / 20.0f;
        DecimalFormat df = new DecimalFormat("#.0");
        return df.format(days) + " MC days";
    }

    @Override
    public String getTitle() {
        return "Biology";
    }
}

