/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.CraftGUI;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.IPoint;
import forestry.core.render.TextureManager;
import net.minecraft.util.IIcon;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class ControlBiome
extends Control
implements ITooltip {
    BiomeGenBase biome = null;
    String iconCategory = "plains";

    public ControlBiome(IWidget parent, float x, float y, float w, float h, BiomeGenBase biome) {
        super(parent, x, y, w, h);
        this.biome = biome;
    }

    @Override
    public void onRenderBackground() {
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
            this.iconCategory = "hills";
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS)) {
            this.iconCategory = "hills";
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            this.iconCategory = "desert";
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            this.iconCategory = "snow";
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            this.iconCategory = "forest";
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            this.iconCategory = "swamp";
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            this.iconCategory = "jungle";
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            this.iconCategory = "taiga";
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
            this.iconCategory = "mushroom";
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            this.iconCategory = "ocean";
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            this.iconCategory = "nether";
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
            this.iconCategory = "end";
        }
        IIcon icon = TextureManager.getInstance().getDefault("habitats/" + this.iconCategory);
        CraftGUI.Render.iconItem(IPoint.ZERO, icon);
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        tooltip.add(this.biome.field_76791_y.replaceAll("(\\p{Ll})(\\p{Lu})", "$1 $2"));
    }
}

