/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.bt.nodes;

import CoroUtil.bt.Behavior;
import CoroUtil.bt.BlackboardBase;
import CoroUtil.bt.EnumBehaviorState;
import CoroUtil.bt.leaf.LeafAction;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.Vec3;

public class SenseEnvironment
extends LeafAction {
    public BlackboardBase blackboard;

    public SenseEnvironment(Behavior parParent, BlackboardBase parBlackboard) {
        super(parParent);
        this.blackboard = parBlackboard;
    }

    @Override
    public EnumBehaviorState tick() {
        double horizSpeed;
        this.blackboard.manageCallbackQueue();
        Entity target = this.blackboard.getTarget();
        if (target != null && (target.field_70128_L || target instanceof EntityLivingBase && ((EntityLivingBase)target).field_70725_aQ > 0)) {
            this.blackboard.setTarget(null);
        }
        int distLevel = 0;
        if (this.blackboard.posMoveTo != null) {
            boolean canSeeCoord;
            double distToPos = this.blackboard.agent.ent.func_70011_f(this.blackboard.posMoveTo.field_72450_a, this.blackboard.posMoveTo.field_72448_b, this.blackboard.posMoveTo.field_72449_c);
            boolean bl = canSeeCoord = this.blackboard.agent.ent.field_70170_p.func_72933_a(Vec3.func_72443_a((double)this.blackboard.agent.ent.field_70165_t, (double)(this.blackboard.agent.ent.field_70163_u + (double)this.blackboard.agent.ent.func_70047_e()), (double)this.blackboard.agent.ent.field_70161_v), Vec3.func_72443_a((double)this.blackboard.posMoveTo.field_72450_a, (double)(this.blackboard.posMoveTo.field_72448_b + 1.5), (double)this.blackboard.posMoveTo.field_72449_c)) == null;
            distLevel = !canSeeCoord || target != null && !this.blackboard.agent.ent.func_70685_l(target) || distToPos > (double)this.blackboard.distMed.getValue().intValue() ? 2 : (distToPos < (double)this.blackboard.distClose.getValue().intValue() ? 0 : 1);
        }
        this.blackboard.shouldChaseTarget.setValue(this.blackboard.agent.profile.shouldChaseTarget());
        this.blackboard.shouldWander.setValue(this.blackboard.agent.profile.shouldWander());
        if (!this.safetyCheck()) {
            this.blackboard.shouldTrySurvival.setValue(true);
            float huntRange = 32.0f;
            if (this.blackboard.agent.ent.field_70170_p.func_82737_E() % 10L == 0L) {
                boolean found = false;
                Entity clEnt = null;
                float closest = 9999.0f;
                List list = this.blackboard.agent.ent.field_70170_p.func_72839_b((Entity)this.blackboard.agent.ent, this.blackboard.agent.ent.field_70121_D.func_72314_b((double)huntRange, (double)(huntRange / 2.0f), (double)huntRange));
                for (int j = 0; j < list.size(); ++j) {
                    float dist;
                    Entity entity1 = (Entity)list.get(j);
                    if (!this.blackboard.agent.isEnemy(entity1) || !((EntityLivingBase)entity1).func_70685_l((Entity)this.blackboard.agent.ent) || !((dist = this.blackboard.agent.ent.func_70032_d(entity1)) < closest)) continue;
                    closest = dist;
                    clEnt = entity1;
                }
                if (clEnt != null) {
                    this.blackboard.lastFleeTarget = clEnt;
                }
            }
        } else {
            this.blackboard.shouldTrySurvival.setValue(false);
        }
        this.blackboard.shouldFollowOrders.setValue(this.blackboard.agent.ordersHandler.activeOrders != null && this.blackboard.agent.profile.shouldFollowOrders());
        boolean isSafe = false;
        this.blackboard.isPathSafe.setValue(isSafe);
        this.blackboard.isLongPath.setValue(distLevel == 2);
        this.blackboard.isClosePath.setValue(distLevel == 0);
        this.blackboard.isSafeOrClosePath.setValue(isSafe || distLevel == 0);
        if ((this.blackboard.canFlyPath.getValue().booleanValue() || this.blackboard.canSwimPath.getValue().booleanValue()) && this.blackboard.posMoveTo != null) {
            if (this.canPosBeSeen(this.blackboard.posMoveTo)) {
                this.blackboard.isLongPath.setValue(false);
                this.blackboard.isSafeOrClosePath.setValue(true);
                this.blackboard.isClosePath.setValue(true);
                this.blackboard.isPathSafe.setValue(true);
            } else {
                this.blackboard.isLongPath.setValue(true);
            }
        }
        this.blackboard.moveCondition.setValue(distLevel);
        this.blackboard.isFighting.setValue(this.blackboard.shouldTrySurvival.getValue() == false && this.blackboard.getTarget() != null);
        if (this.blackboard.isFighting.getValue().booleanValue()) {
            // empty if block
        }
        if ((horizSpeed = Math.sqrt(this.blackboard.agent.ent.field_70159_w * this.blackboard.agent.ent.field_70159_w + this.blackboard.agent.ent.field_70179_y * this.blackboard.agent.ent.field_70179_y)) > 0.01) {
            this.blackboard.isMoving.setValue(true);
        } else {
            this.blackboard.isMoving.setValue(false);
        }
        if (this.blackboard.isWaitingForPath.booleanValue() && this.blackboard.lastTimeRequestedPFThreaded + this.blackboard.PFThreadedTimeout > System.currentTimeMillis()) {
            this.blackboard.resetReceived();
        }
        return super.tick();
    }

    public boolean safetyCheck() {
        return !this.blackboard.agent.profile.shouldTrySurvival();
    }

    public boolean canPosBeSeen(Vec3 parPos) {
        boolean entCheck = this.blackboard.agent.ent.field_70170_p.func_72933_a(Vec3.func_72443_a((double)this.blackboard.agent.ent.field_70165_t, (double)this.blackboard.agent.ent.field_70163_u, (double)this.blackboard.agent.ent.field_70161_v), Vec3.func_72443_a((double)parPos.field_72450_a, (double)parPos.field_72448_b, (double)parPos.field_72449_c)) == null;
        return entCheck;
    }

    public boolean canEntityBeSeen(Entity par1Entity) {
        return this.blackboard.agent.ent.field_70170_p.func_72933_a(Vec3.func_72443_a((double)this.blackboard.agent.ent.field_70165_t, (double)this.blackboard.agent.ent.field_70163_u, (double)this.blackboard.agent.ent.field_70161_v), Vec3.func_72443_a((double)par1Entity.field_70165_t, (double)(par1Entity.field_70163_u + (double)par1Entity.func_70047_e()), (double)par1Entity.field_70161_v)) == null;
    }
}

