/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.pets;

import CoroPets.ai.BehaviorModifier;
import CoroUtil.pets.PetEntry;
import CoroUtil.util.CoroUtilFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PetsManager {
    private static PetsManager instance = null;
    public List<PetEntry> pets = new ArrayList<PetEntry>();
    public HashMap<UUID, PetEntry> lookupUUIDToPet = new HashMap();

    public static PetsManager instance() {
        if (instance == null) {
            instance = new PetsManager();
        }
        return instance;
    }

    public void addPet(UUID parOwner, EntityLiving parEnt) {
        PetEntry entry = new PetEntry();
        entry.ownerUUID = parOwner;
        entry.entUUID = parEnt.func_110124_au();
        this.addPetEntry(entry);
    }

    public void addPetEntry(PetEntry parEntry) {
        this.pets.add(parEntry);
        this.lookupUUIDToPet.put(parEntry.entUUID, parEntry);
    }

    public void removePet(EntityLiving parEnt) {
        PetEntry entry = this.lookupUUIDToPet.get(parEnt.func_110124_au());
        this.pets.remove(entry);
        this.lookupUUIDToPet.remove(parEnt.func_110124_au());
    }

    public void hookPetInstanceReloaded(EntityCreature ent) {
        System.out.println("pet reloaded: " + ent);
        UUID uuid = ent.func_110124_au();
        this.initPetsNewInstance(ent);
    }

    public void hookPetInstanceUnloaded(EntityCreature ent) {
        System.out.println("pet unloaded: " + ent);
    }

    public void initPetsNewInstance(EntityCreature ent) {
        PetEntry entry = this.lookupUUIDToPet.get(ent.func_110124_au());
        if (entry != null) {
            BehaviorModifier.tameMob(ent, entry.ownerUUID, false);
        } else {
            System.out.println("WARNING!!! failed to find entry for this reloaded mob that is marked tame ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nbtReadFromDisk() {
        FileInputStream fis = null;
        try {
            String URL2 = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "CoroPets" + File.separator;
            File file = new File(URL2 + "tamedPets" + ".dat");
            if (file.exists()) {
                fis = new FileInputStream(file);
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fis);
                this.nbtRead(nbttagcompound);
                if (fis != null) {
                    fis.close();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void nbtWriteToDisk() {
        try {
            NBTTagCompound nbt = this.nbtWrite();
            String URL2 = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "CoroPets" + File.separator;
            File fl = new File(URL2);
            if (!fl.exists()) {
                fl.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(URL2 + "tamedPets" + ".dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)fos);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void nbtRead(NBTTagCompound parNBT) {
        for (String tagName : parNBT.func_150296_c()) {
            NBTTagCompound entry = parNBT.func_74775_l(tagName);
            PetEntry petEntry = new PetEntry();
            petEntry.nbtRead(entry);
            this.addPetEntry(petEntry);
        }
    }

    public NBTTagCompound nbtWrite() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (int i = 0; i < this.pets.size(); ++i) {
            NBTTagCompound nbtEntry = this.pets.get(i).nbtWrite();
            nbt.func_74782_a("entry_" + i, (NBTBase)nbtEntry);
        }
        return nbt;
    }

    public void reset() {
        this.pets.clear();
    }
}

