/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.movingworld.common.chunk;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class LocatedBlock {
    public final Block block;
    public final int blockMeta;
    public final TileEntity tileEntity;
    public final ChunkPosition coords;
    public final ChunkPosition coordsNoOffset;

    public LocatedBlock(Block block, int meta, ChunkPosition coords) {
        this(block, meta, null, coords, null);
    }

    public LocatedBlock(Block block, int meta, TileEntity tileentity, ChunkPosition coords, ChunkPosition coordsNoOffset) {
        this.block = block;
        this.blockMeta = meta;
        this.tileEntity = tileentity;
        this.coords = coords;
        this.coordsNoOffset = coordsNoOffset;
    }

    public LocatedBlock(NBTTagCompound comp, World world) {
        this.block = Block.func_149729_e((int)comp.func_74762_e("block"));
        this.blockMeta = comp.func_74762_e("meta");
        this.coords = new ChunkPosition(comp.func_74762_e("x"), comp.func_74762_e("y"), comp.func_74762_e("z"));
        this.coordsNoOffset = null;
        this.tileEntity = world == null ? null : world.func_147438_o(this.coords.field_151329_a, this.coords.field_151327_b, this.coords.field_151328_c);
    }

    public String toString() {
        return "LocatedBlock [block=" + this.block + ", meta=" + this.blockMeta + ", coords=[" + this.coords.field_151329_a + ", " + this.coords.field_151327_b + ", " + this.coords.field_151328_c + "]]";
    }

    public void writeToNBT(NBTTagCompound comp) {
        comp.func_74777_a("block", (short)Block.func_149682_b((Block)this.block));
        comp.func_74768_a("meta", this.blockMeta);
        comp.func_74768_a("x", this.coords.field_151329_a);
        comp.func_74768_a("y", this.coords.field_151327_b);
        comp.func_74768_a("z", this.coords.field_151328_c);
    }
}

