/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.movingworld.common.chunk.assembly;

import darkevilmac.movingworld.MovingWorld;
import darkevilmac.movingworld.common.block.BlockMovingWorldMarker;
import darkevilmac.movingworld.common.chunk.LocatedBlock;
import darkevilmac.movingworld.common.chunk.MovingWorldSizeOverflowException;
import darkevilmac.movingworld.common.chunk.assembly.AssembleResult;
import darkevilmac.movingworld.common.chunk.assembly.CanAssemble;
import darkevilmac.movingworld.common.chunk.assembly.MovingWorldAssemblyInteractor;
import darkevilmac.movingworld.common.tile.TileMovingWorldMarkingBlock;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class ChunkAssembler {
    public final int startX;
    public final int startY;
    public final int startZ;
    private final int maxBlocks;
    private World worldObj;

    public ChunkAssembler(World world, int x, int y, int z, int maxMovingWorldBlocks) {
        this.worldObj = world;
        this.startX = x;
        this.startY = y;
        this.startZ = z;
        this.maxBlocks = maxMovingWorldBlocks;
    }

    public AssembleResult doAssemble(MovingWorldAssemblyInteractor interactor) {
        AssembleResult result = new AssembleResult();
        result.xOffset = this.startX;
        result.yOffset = this.startY;
        result.zOffset = this.startZ;
        result.assemblyInteractor = interactor;
        try {
            if (MovingWorld.instance.mConfig.iterativeAlgorithm) {
                this.assembleIterative(result, result.assemblyInteractor, this.startX, this.startY, this.startZ);
            } else {
                this.assembleRecursive(result, new HashSet<ChunkPosition>(), result.assemblyInteractor, this.startX, this.startY, this.startZ);
            }
            result.resultCode = result.movingWorldMarkingBlock == null ? 3 : 1;
        }
        catch (MovingWorldSizeOverflowException e) {
            result.resultCode = 2;
        }
        catch (Error e) {
            result.resultCode = 4;
        }
        result.assemblyInteractor.chunkAssembled(result);
        return result;
    }

    private void assembleIterative(AssembleResult result, MovingWorldAssemblyInteractor assemblyInteractor, int sX, int sY, int sZ) throws MovingWorldSizeOverflowException {
        HashSet<ChunkPosition> openSet = new HashSet<ChunkPosition>();
        HashSet<ChunkPosition> closedSet = new HashSet<ChunkPosition>();
        ArrayList<ChunkPosition> iterator = new ArrayList<ChunkPosition>();
        LocatedBlock movingWorldMarker = null;
        int x = sX;
        int y = sY;
        int z = sZ;
        openSet.add(new ChunkPosition(sX, sY, sZ));
        while (!openSet.isEmpty()) {
            iterator.addAll(openSet);
            for (ChunkPosition pos : iterator) {
                openSet.remove(pos);
                if (closedSet.contains(pos)) continue;
                if (result.assembledBlocks.size() > this.maxBlocks) {
                    throw new MovingWorldSizeOverflowException();
                }
                x = pos.field_151329_a;
                y = pos.field_151327_b;
                z = pos.field_151328_c;
                closedSet.add(pos);
                Block block = this.worldObj.func_147439_a(x, y, z);
                CanAssemble canAssemble = this.canUseBlockForVehicle(block, assemblyInteractor, x, y, z);
                if (canAssemble.justCancel) continue;
                LocatedBlock lb = new LocatedBlock(block, this.worldObj.func_72805_g(x, y, z), this.worldObj.func_147438_o(x, y, z), pos, null);
                assemblyInteractor.blockAssembled(lb);
                if ((lb.block != null && lb.block instanceof BlockMovingWorldMarker || lb.tileEntity != null && lb.tileEntity instanceof TileMovingWorldMarkingBlock) && movingWorldMarker == null) {
                    movingWorldMarker = lb;
                }
                result.assembleBlock(lb);
                if (canAssemble.assembleThenCancel) continue;
                openSet.add(new ChunkPosition(x - 1, y, z));
                openSet.add(new ChunkPosition(x, y - 1, z));
                openSet.add(new ChunkPosition(x, y, z - 1));
                openSet.add(new ChunkPosition(x + 1, y, z));
                openSet.add(new ChunkPosition(x, y + 1, z));
                openSet.add(new ChunkPosition(x, y, z + 1));
                if (!assemblyInteractor.doDiagonalAssembly()) continue;
                openSet.add(new ChunkPosition(x - 1, y - 1, z));
                openSet.add(new ChunkPosition(x + 1, y - 1, z));
                openSet.add(new ChunkPosition(x + 1, y + 1, z));
                openSet.add(new ChunkPosition(x - 1, y + 1, z));
                openSet.add(new ChunkPosition(x - 1, y, z - 1));
                openSet.add(new ChunkPosition(x + 1, y, z - 1));
                openSet.add(new ChunkPosition(x + 1, y, z + 1));
                openSet.add(new ChunkPosition(x - 1, y, z + 1));
                openSet.add(new ChunkPosition(x, y - 1, z - 1));
                openSet.add(new ChunkPosition(x, y + 1, z - 1));
                openSet.add(new ChunkPosition(x, y + 1, z + 1));
                openSet.add(new ChunkPosition(x, y - 1, z + 1));
            }
        }
        result.movingWorldMarkingBlock = movingWorldMarker;
    }

    private void assembleRecursive(AssembleResult result, HashSet<ChunkPosition> set, MovingWorldAssemblyInteractor assemblyInteractor, int x, int y, int z) throws MovingWorldSizeOverflowException {
        LocatedBlock movingWorldMarker = null;
        if (result.assembledBlocks.size() > this.maxBlocks) {
            throw new MovingWorldSizeOverflowException();
        }
        ChunkPosition pos = new ChunkPosition(x, y, z);
        if (set.contains(pos)) {
            return;
        }
        set.add(pos);
        Block block = this.worldObj.func_147439_a(x, y, z);
        CanAssemble canAssemble = this.canUseBlockForVehicle(block, assemblyInteractor, x, y, z);
        if (canAssemble.justCancel) {
            return;
        }
        LocatedBlock lb = new LocatedBlock(block, this.worldObj.func_72805_g(x, y, z), this.worldObj.func_147438_o(x, y, z), pos, null);
        assemblyInteractor.blockAssembled(lb);
        if ((lb.block != null && lb.block instanceof BlockMovingWorldMarker || lb.tileEntity != null && lb.tileEntity instanceof TileMovingWorldMarkingBlock) && movingWorldMarker == null) {
            movingWorldMarker = lb;
        }
        result.assembleBlock(lb);
        if (!canAssemble.assembleThenCancel) {
            this.assembleRecursive(result, set, assemblyInteractor, x - 1, y, z);
            this.assembleRecursive(result, set, assemblyInteractor, x, y - 1, z);
            this.assembleRecursive(result, set, assemblyInteractor, x, y, z - 1);
            this.assembleRecursive(result, set, assemblyInteractor, x + 1, y, z);
            this.assembleRecursive(result, set, assemblyInteractor, x, y + 1, z);
            this.assembleRecursive(result, set, assemblyInteractor, x, y, z + 1);
            if (assemblyInteractor.doDiagonalAssembly()) {
                this.assembleRecursive(result, set, assemblyInteractor, x - 1, y - 1, z);
                this.assembleRecursive(result, set, assemblyInteractor, x + 1, y - 1, z);
                this.assembleRecursive(result, set, assemblyInteractor, x + 1, y + 1, z);
                this.assembleRecursive(result, set, assemblyInteractor, x - 1, y + 1, z);
                this.assembleRecursive(result, set, assemblyInteractor, x - 1, y, z - 1);
                this.assembleRecursive(result, set, assemblyInteractor, x + 1, y, z - 1);
                this.assembleRecursive(result, set, assemblyInteractor, x + 1, y, z + 1);
                this.assembleRecursive(result, set, assemblyInteractor, x - 1, y, z + 1);
                this.assembleRecursive(result, set, assemblyInteractor, x, y - 1, z - 1);
                this.assembleRecursive(result, set, assemblyInteractor, x, y + 1, z - 1);
                this.assembleRecursive(result, set, assemblyInteractor, x, y + 1, z + 1);
                this.assembleRecursive(result, set, assemblyInteractor, x, y - 1, z + 1);
            }
        }
        result.movingWorldMarkingBlock = movingWorldMarker;
    }

    public CanAssemble canUseBlockForVehicle(Block block, MovingWorldAssemblyInteractor assemblyInteractor, int x, int y, int z) {
        return assemblyInteractor.isBlockAllowed(this.worldObj, block, x, y, z);
    }
}

