/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.movingworld.common.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import darkevilmac.movingworld.MovingWorld;
import darkevilmac.movingworld.common.chunk.ChunkIO;
import darkevilmac.movingworld.common.chunk.LocatedBlock;
import darkevilmac.movingworld.common.chunk.MovingWorldSizeOverflowException;
import darkevilmac.movingworld.common.chunk.assembly.ChunkDisassembler;
import darkevilmac.movingworld.common.chunk.assembly.MovingWorldAssemblyInteractor;
import darkevilmac.movingworld.common.chunk.mobilechunk.MobileChunk;
import darkevilmac.movingworld.common.chunk.mobilechunk.MobileChunkClient;
import darkevilmac.movingworld.common.chunk.mobilechunk.MobileChunkServer;
import darkevilmac.movingworld.common.entity.MovingWorldCapabilities;
import darkevilmac.movingworld.common.entity.MovingWorldHandlerCommon;
import darkevilmac.movingworld.common.entity.MovingWorldInfo;
import darkevilmac.movingworld.common.util.AABBRotator;
import darkevilmac.movingworld.common.util.MathHelperMod;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public abstract class EntityMovingWorld
extends EntityBoat
implements IEntityAdditionalSpawnData {
    public float motionYaw;
    public int frontDirection;
    public int riderDestinationX;
    public int riderDestinationY;
    public int riderDestinationZ;
    public boolean isFlying;
    public Entity prevRiddenByEntity;
    protected float groundFriction;
    protected float horFriction;
    protected float vertFriction;
    protected int[] layeredBlockVolumeCount;
    private MobileChunk mobileChunk;
    private MovingWorldInfo info = new MovingWorldInfo();
    private ChunkDisassembler disassembler;
    private boolean noControl;
    private boolean syncPosWithServer;
    @SideOnly(value=Side.CLIENT)
    private double controlPosRotationIncrements;
    @SideOnly(value=Side.CLIENT)
    private double controlX;
    @SideOnly(value=Side.CLIENT)
    private double controlY;
    @SideOnly(value=Side.CLIENT)
    private double controlZ;
    @SideOnly(value=Side.CLIENT)
    private double controlPitch;
    @SideOnly(value=Side.CLIENT)
    private double controlYaw;
    @SideOnly(value=Side.CLIENT)
    private double controlVelX;
    @SideOnly(value=Side.CLIENT)
    private double controlVelY;
    @SideOnly(value=Side.CLIENT)
    private double controlVelZ;

    public EntityMovingWorld(World world) {
        super(world);
        if (world.field_72995_K) {
            this.initClient();
        } else {
            this.initCommon();
        }
        this.motionYaw = 0.0f;
        this.layeredBlockVolumeCount = null;
        this.frontDirection = 0;
        this.field_70129_M = 0.0f;
        this.groundFriction = 0.9f;
        this.horFriction = 0.994f;
        this.vertFriction = 0.95f;
        this.prevRiddenByEntity = null;
        this.isFlying = false;
    }

    public static boolean isAABBInLiquidNotFall(World world, AxisAlignedBB aabb) {
        int i = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)aabb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0));
        for (int x = i; x < j; ++x) {
            for (int y = k; y < l; ++y) {
                for (int z = i1; z < j1; ++z) {
                    double d0;
                    int j2;
                    Block block = world.func_147439_a(x, y, z);
                    if (block == null || block.func_149688_o() != Material.field_151586_h && block.func_149688_o() != Material.field_151587_i || (j2 = world.func_72805_g(x, y, z)) >= 8 || !((d0 = (double)(y + 1) - (double)j2 / 8.0) >= aabb.field_72338_b)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return false;
    }

    public abstract MovingWorldHandlerCommon getHandler();

    public int[] getLayeredBlockVolumeCount() {
        return this.layeredBlockVolumeCount;
    }

    public void setLayeredBlockVolumeCount(int[] layeredBlockVolumeCount) {
        this.layeredBlockVolumeCount = layeredBlockVolumeCount;
    }

    @SideOnly(value=Side.CLIENT)
    private void initClient() {
        this.mobileChunk = new MobileChunkClient(this.field_70170_p, this);
        this.initMovingWorldClient();
    }

    private void initCommon() {
        this.mobileChunk = new MobileChunkServer(this.field_70170_p, this);
        this.initMovingWorldCommon();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(30, (Object)0);
        this.initMovingWorld();
    }

    public abstract void initMovingWorld();

    public abstract void initMovingWorldClient();

    public abstract void initMovingWorldCommon();

    public MobileChunk getMovingWorldChunk() {
        return this.mobileChunk;
    }

    public abstract MovingWorldCapabilities getCapabilities();

    public abstract void setCapabilities(MovingWorldCapabilities var1);

    public ChunkDisassembler getDisassembler() {
        if (this.disassembler == null) {
            this.disassembler = new ChunkDisassembler(this);
        }
        return this.disassembler;
    }

    public MovingWorldInfo getInfo() {
        return this.info;
    }

    public void setInfo(MovingWorldInfo movingWorldInfo) {
        if (movingWorldInfo == null) {
            throw new NullPointerException("Cannot set null moving world info");
        }
        this.info = movingWorldInfo;
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        return this.getHandler().interact(entityplayer);
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.mobileChunk.onChunkUnload();
        this.getCapabilities().clear();
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.mobileChunk.isModified) {
            this.mobileChunk.isModified = false;
            this.getHandler().onChunkUpdate();
        }
    }

    public void setRotatedBoundingBox() {
        if (this.mobileChunk == null) {
            float hw = this.field_70130_N / 2.0f;
            this.field_70121_D.func_72324_b(this.field_70165_t - (double)hw, this.field_70163_u, this.field_70161_v - (double)hw, this.field_70165_t + (double)hw, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + (double)hw);
        } else {
            this.field_70121_D.func_72324_b(this.field_70165_t - (double)this.mobileChunk.getCenterX(), this.field_70163_u, this.field_70161_v - (double)this.mobileChunk.getCenterZ(), this.field_70165_t + (double)this.mobileChunk.getCenterX(), this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + (double)this.mobileChunk.getCenterZ());
            AABBRotator.rotateAABBAroundY(this.field_70121_D, this.field_70165_t, this.field_70161_v, (float)Math.toRadians(this.field_70177_z));
        }
    }

    public void func_70105_a(float w, float h) {
        float f;
        if (w != this.field_70130_N || h != this.field_70131_O) {
            this.field_70130_N = w;
            this.field_70131_O = h;
            float hw = w / 2.0f;
            this.field_70121_D.func_72324_b(this.field_70165_t - (double)hw, this.field_70163_u, this.field_70161_v - (double)hw, this.field_70165_t + (double)hw, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + (double)hw);
        }
        this.field_70168_am = (double)(f = w % 2.0f) < 0.375 ? Entity.EnumEntitySize.SIZE_1 : ((double)f < 0.75 ? Entity.EnumEntitySize.SIZE_2 : ((double)f < 1.0 ? Entity.EnumEntitySize.SIZE_3 : ((double)f < 1.375 ? Entity.EnumEntitySize.SIZE_4 : ((double)f < 1.75 ? Entity.EnumEntitySize.SIZE_5 : Entity.EnumEntitySize.SIZE_6))));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int incr) {
        if (this.noControl) {
            this.controlPosRotationIncrements = incr + 5;
        } else {
            double dx = x - this.field_70165_t;
            double dy = y - this.field_70163_u;
            double dz = z - this.field_70161_v;
            double d = dx * dx + dy * dy + dz * dz;
            if (d < 0.3) {
                return;
            }
            this.syncPosWithServer = true;
            this.controlPosRotationIncrements = incr;
        }
        this.controlX = x;
        this.controlY = y;
        this.controlZ = z;
        this.controlYaw = yaw;
        this.controlPitch = pitch;
        this.field_70159_w = this.controlVelX;
        this.field_70181_x = this.controlVelY;
        this.field_70179_y = this.controlVelZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.controlVelX = this.field_70159_w = x;
        this.controlVelY = this.field_70181_x = y;
        this.controlVelZ = this.field_70179_y = z;
    }

    public void func_70071_h_() {
        this.func_70030_z();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        double horvel = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70153_n == null) {
                this.func_70270_d(true);
            }
            this.spawnParticles(horvel);
        }
        if (this.field_70170_p.field_72995_K && (this.noControl || this.syncPosWithServer)) {
            this.handleClientUpdate();
            if (this.controlPosRotationIncrements == 0.0) {
                this.syncPosWithServer = false;
            }
        } else {
            this.handleServerUpdate(horvel);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void handleClientUpdate() {
        if (this.controlPosRotationIncrements > 0.0) {
            double dx = this.field_70165_t + (this.controlX - this.field_70165_t) / this.controlPosRotationIncrements;
            double dy = this.field_70163_u + (this.controlY - this.field_70163_u) / this.controlPosRotationIncrements;
            double dz = this.field_70161_v + (this.controlZ - this.field_70161_v) / this.controlPosRotationIncrements;
            double ang = MathHelper.func_76138_g((double)(this.controlYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + ang / this.controlPosRotationIncrements);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.controlPitch - (double)this.field_70125_A) / this.controlPosRotationIncrements);
            this.controlPosRotationIncrements -= 1.0;
            this.func_70107_b(dx, dy, dz);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        } else {
            this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (this.field_70122_E) {
                this.field_70159_w *= (double)this.groundFriction;
                this.field_70181_x *= (double)this.groundFriction;
                this.field_70179_y *= (double)this.groundFriction;
            }
            this.field_70159_w *= (double)this.horFriction;
            this.field_70181_x *= (double)this.vertFriction;
            this.field_70179_y *= (double)this.horFriction;
        }
        this.setRotatedBoundingBox();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70270_d(boolean flag) {
        this.noControl = flag;
    }

    protected void handleServerUpdate(double horvel) {
        float gravity = 0.05f;
        if (!this.isFlying()) {
            this.field_70181_x -= (double)gravity;
        }
        this.handleControl(horvel);
        double newhorvel = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        double maxvel = this.getCapabilities().getSpeedLimit();
        if (newhorvel > maxvel) {
            double d = maxvel / newhorvel;
            this.field_70159_w *= d;
            this.field_70179_y *= d;
            newhorvel = maxvel;
        }
        this.field_70181_x = MathHelperMod.clamp_double(this.field_70181_x, -maxvel, maxvel);
        if (this.field_70122_E) {
            this.field_70159_w *= (double)this.groundFriction;
            this.field_70181_x *= (double)this.groundFriction;
            this.field_70179_y *= (double)this.groundFriction;
        }
        this.field_70125_A += (this.motionYaw * this.getCapabilities().getBankingMultiplier() - this.field_70125_A) * 0.15f;
        this.motionYaw *= 0.7f;
        this.field_70177_z += this.motionYaw;
        this.setRotatedBoundingBox();
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70163_u = Math.min(this.field_70163_u, (double)this.field_70170_p.func_72800_K());
        this.field_70159_w *= (double)this.horFriction;
        this.field_70181_x *= (double)this.vertFriction;
        this.field_70179_y *= (double)this.horFriction;
        this.handleServerUpdatePreRotation();
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.handleCollision(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void handleServerUpdatePreRotation() {
    }

    public void func_70043_V() {
        this.updateRiderPosition(this.field_70153_n, this.riderDestinationX, this.riderDestinationY, this.riderDestinationZ, 1);
    }

    public void updateRiderPosition(Entity entity, int riderDestinationX, int riderDestinationY, int riderDestinationZ, int flags) {
        if (entity != null) {
            float yaw = (float)Math.toRadians(this.field_70177_z);
            float pitch = (float)Math.toRadians(this.field_70125_A);
            int x1 = riderDestinationX;
            int y1 = riderDestinationY;
            int z1 = riderDestinationZ;
            if ((flags & 1) == 1) {
                if (this.frontDirection == 0) {
                    --z1;
                } else if (this.frontDirection == 1) {
                    ++x1;
                } else if (this.frontDirection == 2) {
                    ++z1;
                } else if (this.frontDirection == 3) {
                    --x1;
                }
                Block block = this.mobileChunk.func_147439_a(x1, MathHelper.func_76128_c((double)((double)y1 + this.func_70042_X() + entity.func_70033_W())), z1);
                if (block.func_149662_c()) {
                    x1 = riderDestinationX;
                    y1 = riderDestinationY;
                    z1 = riderDestinationZ;
                }
            }
            double yoff = (flags & 2) == 2 ? 0.0 : this.func_70042_X();
            Vec3 vec = Vec3.func_72443_a((double)((double)((float)x1 - this.mobileChunk.getCenterX()) + 0.5), (double)((double)(y1 - this.mobileChunk.minY()) + yoff), (double)((double)((float)z1 - this.mobileChunk.getCenterZ()) + 0.5));
            switch (this.frontDirection) {
                case 0: {
                    vec.func_72446_c(-pitch);
                    break;
                }
                case 1: {
                    vec.func_72440_a(pitch);
                    break;
                }
                case 2: {
                    vec.func_72446_c(pitch);
                    break;
                }
                case 3: {
                    vec.func_72440_a(-pitch);
                }
            }
            vec.func_72442_b(yaw);
            entity.func_70107_b(this.field_70165_t + vec.field_72450_a, this.field_70163_u + vec.field_72448_b + entity.func_70033_W(), this.field_70161_v + vec.field_72449_c);
        }
    }

    private boolean handleCollision(double cPosX, double cPosY, double cPosZ) {
        boolean didCollide = false;
        if (!this.field_70170_p.field_72995_K) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.2, 0.0, 0.2));
            if (list != null && !list.isEmpty()) {
                didCollide = true;
                for (Entity entity : list) {
                    double d1;
                    double d0;
                    double d2;
                    if (entity == this.field_70153_n || !entity.func_70104_M()) continue;
                    if (entity instanceof EntityMovingWorld) {
                        entity.func_70108_f((Entity)this);
                        continue;
                    }
                    if (!(entity instanceof EntityBoat) || !((d2 = MathHelper.func_76132_a((double)(d0 = cPosX - entity.field_70165_t), (double)(d1 = cPosZ - entity.field_70161_v))) >= 0.01)) continue;
                    d2 = MathHelper.func_76133_a((double)d2);
                    d0 /= d2;
                    d1 /= d2;
                    double d3 = 1.0 / d2;
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    d0 *= d3;
                    d1 *= d3;
                    d0 *= 0.05;
                    d1 *= 0.05;
                    entity.func_70024_g(-(d0 *= (double)(1.0f - entity.field_70144_Y)), 0.0, -(d1 *= (double)(1.0f - entity.field_70144_Y)));
                }
            }
            for (int l = 0; l < 4; ++l) {
                int i1 = MathHelper.func_76128_c((double)(cPosX + ((double)(l % 2) - 0.5) * 0.8));
                int j1 = MathHelper.func_76128_c((double)(cPosZ + ((double)(l / 2) - 0.5) * 0.8));
                for (int k1 = 0; k1 < 2; ++k1) {
                    int l1 = MathHelper.func_76128_c((double)cPosY) + k1;
                    Block block = this.field_70170_p.func_147439_a(i1, l1, j1);
                    if (block == Blocks.field_150433_aE) {
                        this.field_70170_p.func_147468_f(i1, l1, j1);
                        this.field_70123_F = false;
                        continue;
                    }
                    if (block == Blocks.field_150392_bi) {
                        this.field_70170_p.func_147480_a(i1, l1, j1, true);
                        this.field_70123_F = false;
                        continue;
                    }
                    didCollide = true;
                }
            }
        }
        return didCollide;
    }

    public boolean func_70072_I() {
        float f = this.field_70130_N;
        this.field_70130_N = 0.0f;
        boolean ret = super.func_70072_I();
        this.field_70130_N = f;
        return ret;
    }

    public boolean isFlying() {
        return this.getCapabilities().canFly() && this.isFlying;
    }

    public abstract boolean isBraking();

    public boolean func_96092_aw() {
        return this.field_70173_aa > 60;
    }

    public boolean shouldRiderSit() {
        return true;
    }

    public double func_70042_X() {
        return (double)this.field_70129_M + 0.5;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity instanceof EntityLiving ? null : entity.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return this.field_70122_E && !this.func_70090_H() && this.field_70153_n == null;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected void func_70064_a(double distancefallen, boolean onground) {
        if (!this.isFlying()) {
            // empty if block
        }
    }

    protected void func_70069_a(float distance) {
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.5f;
    }

    public float getHorizontalVelocity() {
        return (float)Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
    }

    public void alignToGrid() {
        this.field_70177_z = (float)Math.round(this.field_70177_z / 90.0f) * 90.0f;
        this.field_70125_A = 0.0f;
        Vec3 vec = Vec3.func_72443_a((double)(-this.mobileChunk.getCenterX()), (double)(-this.mobileChunk.minY()), (double)(-this.mobileChunk.getCenterZ()));
        vec.func_72442_b((float)Math.toRadians(this.field_70177_z));
        int ix = MathHelperMod.round_double(vec.field_72450_a + this.field_70165_t);
        int iy = MathHelperMod.round_double(vec.field_72448_b + this.field_70163_u);
        int iz = MathHelperMod.round_double(vec.field_72449_c + this.field_70161_v);
        this.field_70165_t = (double)ix - vec.field_72450_a;
        this.field_70163_u = (double)iy - vec.field_72448_b;
        this.field_70161_v = (double)iz - vec.field_72449_c;
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
    }

    public boolean disassemble(boolean overwrite) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        this.func_70043_V();
        ChunkDisassembler disassembler = this.getDisassembler();
        disassembler.overwrite = overwrite;
        if (!disassembler.canDisassemble(this.getAssemblyInteractor())) {
            return false;
        }
        disassembler.doDisassemble(this.getAssemblyInteractor());
        return true;
    }

    public abstract MovingWorldAssemblyInteractor getNewAssemblyInteractor();

    public void dropAsItems() {
        for (int i = this.mobileChunk.minX(); i < this.mobileChunk.maxX(); ++i) {
            for (int j = this.mobileChunk.minY(); j < this.mobileChunk.maxY(); ++j) {
                for (int k = this.mobileChunk.minZ(); k < this.mobileChunk.maxZ(); ++k) {
                    Block block;
                    TileEntity tileentity = this.mobileChunk.func_147438_o(i, j, k);
                    if (tileentity instanceof IInventory) {
                        IInventory inv = (IInventory)tileentity;
                        for (int it = 0; it < inv.func_70302_i_(); ++it) {
                            ItemStack is = inv.func_70301_a(it);
                            if (is == null) continue;
                            this.func_70099_a(is, 0.0f);
                        }
                    }
                    if ((block = this.mobileChunk.func_147439_a(i, j, k)) == Blocks.field_150350_a) continue;
                    int meta = this.mobileChunk.func_72805_g(i, j, k);
                    block.func_149697_b(this.field_70170_p, MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v), meta, 0);
                }
            }
        }
    }

    protected void fillAirBlocks(Set<ChunkPosition> set, int x, int y, int z) {
        if (x < this.mobileChunk.minX() - 1 || x > this.mobileChunk.maxX() || y < this.mobileChunk.minY() - 1 || y > this.mobileChunk.maxY() || z < this.mobileChunk.minZ() - 1 || z > this.mobileChunk.maxZ()) {
            return;
        }
        ChunkPosition pos = new ChunkPosition(x, y, z);
        if (set.contains(pos)) {
            return;
        }
        set.add(pos);
        if (this.mobileChunk.setBlockAsFilledAir(x, y, z)) {
            this.fillAirBlocks(set, x, y + 1, z);
            this.fillAirBlocks(set, x - 1, y, z);
            this.fillAirBlocks(set, x, y, z - 1);
            this.fillAirBlocks(set, x + 1, y, z);
            this.fillAirBlocks(set, x, y, z + 1);
        }
    }

    public void setPilotSeat(int frontDirection, int riderDestinationX, int riderDestinationY, int riderDestinationZ) {
        this.frontDirection = frontDirection;
        this.riderDestinationX = riderDestinationX;
        this.riderDestinationY = riderDestinationY;
        this.riderDestinationZ = riderDestinationZ;
    }

    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.mobileChunk.getMemoryUsage());
        DataOutputStream out = new DataOutputStream(baos);
        try {
            ChunkIO.writeAll(out, this.mobileChunk);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        compound.func_74773_a("chunk", baos.toByteArray());
        compound.func_74774_a("riderDestinationX", (byte)this.riderDestinationX);
        compound.func_74774_a("riderDestinationY", (byte)this.riderDestinationY);
        compound.func_74774_a("riderDestinationZ", (byte)this.riderDestinationZ);
        compound.func_74774_a("front", (byte)this.frontDirection);
        if (!this.mobileChunk.chunkTileEntityMap.isEmpty()) {
            NBTTagList tileEntities = new NBTTagList();
            for (TileEntity tileentity : this.mobileChunk.chunkTileEntityMap.values()) {
                NBTTagCompound comp = new NBTTagCompound();
                tileentity.func_145841_b(comp);
                tileEntities.func_74742_a((NBTBase)comp);
            }
            compound.func_74782_a("tileent", (NBTBase)tileEntities);
        }
        if (this.mobileChunk.marker != null) {
            NBTTagCompound markerComp = new NBTTagCompound();
            markerComp.func_74768_a("markerPosX", this.mobileChunk.marker.coords.field_151329_a);
            markerComp.func_74768_a("markerPosY", this.mobileChunk.marker.coords.field_151327_b);
            markerComp.func_74768_a("markerPosZ", this.mobileChunk.marker.coords.field_151328_c);
            compound.func_74782_a("markerInfo", (NBTBase)markerComp);
        }
        compound.func_74778_a("name", this.info.getName());
        if (this.info.getOwner() != null) {
            compound.func_74778_a("owner", this.info.getOwner().toString());
        }
        this.writeMovingWorldNBT(compound);
    }

    public abstract void writeMovingWorldNBT(NBTTagCompound var1);

    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        byte[] ab = compound.func_74770_j("chunk");
        ByteArrayInputStream bais = new ByteArrayInputStream(ab);
        DataInputStream in = new DataInputStream(bais);
        try {
            ChunkIO.read(in, this.mobileChunk);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (compound.func_74764_b("riderDestination")) {
            short s = compound.func_74765_d("riderDestination");
            this.riderDestinationX = s & 0xF;
            this.riderDestinationY = s >>> 4 & 0xF;
            this.riderDestinationZ = s >>> 8 & 0xF;
            this.frontDirection = s >>> 12 & 3;
        } else {
            this.riderDestinationX = compound.func_74771_c("riderDestinationX") & 0xFF;
            this.riderDestinationY = compound.func_74771_c("riderDestinationY") & 0xFF;
            this.riderDestinationZ = compound.func_74771_c("riderDestinationZ") & 0xFF;
            this.frontDirection = compound.func_74771_c("front") & 3;
        }
        NBTTagList tileentities = compound.func_150295_c("tileent", 10);
        if (tileentities != null) {
            for (int i = 0; i < tileentities.func_74745_c(); ++i) {
                NBTTagCompound comp = tileentities.func_150305_b(i);
                TileEntity tileentity = TileEntity.func_145827_c((NBTTagCompound)comp);
                this.mobileChunk.setTileEntity(tileentity.field_145851_c, tileentity.field_145848_d, tileentity.field_145849_e, tileentity);
            }
        }
        if (compound.func_74764_b("markerInfo")) {
            NBTTagCompound markerComp = (NBTTagCompound)compound.func_74781_a("markerInfo");
            int x = markerComp.func_74762_e("markerPosX");
            int y = markerComp.func_74762_e("markerPosY");
            int z = markerComp.func_74762_e("markerPosZ");
            this.mobileChunk.marker = new LocatedBlock(this.mobileChunk.func_147439_a(x, y, z), this.mobileChunk.func_72805_g(x, y, z), this.mobileChunk.func_147438_o(x, y, z), new ChunkPosition(x, y, z), null);
        }
        this.info = new MovingWorldInfo();
        this.info.setName(compound.func_74779_i("name"));
        if (compound.func_74764_b("owner")) {
            this.info.setOwner(UUID.fromString(compound.func_74779_i("owner")));
        }
        this.readMovingWorldNBT(compound);
    }

    public abstract void readMovingWorldNBT(NBTTagCompound var1);

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(double horvel) {
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeByte(this.riderDestinationX);
        data.writeByte(this.riderDestinationY);
        data.writeByte(this.riderDestinationZ);
        data.writeByte(this.frontDirection);
        data.writeShort(this.info.getName().length());
        data.writeBytes(this.info.getName().getBytes());
        try {
            ChunkIO.writeAllCompressed(data, this.mobileChunk);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MovingWorldSizeOverflowException ssoe) {
            this.disassemble(false);
            MovingWorld.logger.warn("Ship is too large to be sent");
        }
        this.writeMovingWorldSpawnData(data);
    }

    public abstract void writeMovingWorldSpawnData(ByteBuf var1);

    public void readSpawnData(ByteBuf data) {
        this.riderDestinationX = data.readUnsignedByte();
        this.riderDestinationY = data.readUnsignedByte();
        this.riderDestinationZ = data.readUnsignedByte();
        this.frontDirection = data.readUnsignedByte();
        byte[] ab = new byte[data.readShort()];
        data.readBytes(ab);
        this.info.setName(new String(ab));
        try {
            ChunkIO.readCompressed(data, this.mobileChunk);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mobileChunk.onChunkLoad();
        this.readMovingWorldSpawnData(data);
    }

    public abstract void handleControl(double var1);

    public abstract void readMovingWorldSpawnData(ByteBuf var1);

    public abstract float getXRenderScale();

    public abstract float getYRenderScale();

    public abstract float getZRenderScale();

    public abstract MovingWorldAssemblyInteractor getAssemblyInteractor();

    public abstract void setAssemblyInteractor(MovingWorldAssemblyInteractor var1);

    public MobileChunk getMobileChunk() {
        return this.mobileChunk;
    }
}

