/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.movingworld.common.entity;

import darkevilmac.movingworld.common.entity.EntityMovingWorld;
import darkevilmac.movingworld.common.util.MaterialDensity;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;

public abstract class MovingWorldCapabilities {
    private final EntityMovingWorld movingWorld;
    private int blockCount;
    private float mass;
    private boolean autoCalcMass;
    private float speedLimit;
    private float bankingMultiplier;
    private boolean canFly;

    public MovingWorldCapabilities(EntityMovingWorld movingWorld, boolean autoCalcMass) {
        this.movingWorld = movingWorld;
        this.autoCalcMass = autoCalcMass;
        this.clear();
    }

    public void updateMovingWorldEntities() {
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public void onChunkBlockAdded(Block block, int metadata, int x, int y, int z) {
        ++this.blockCount;
        if (this.autoCalcMass) {
            this.mass += MaterialDensity.getDensity(block);
        }
    }

    public void postBlockAdding() {
    }

    public abstract boolean mountEntity(Entity var1);

    public void clearBlockCount() {
        this.blockCount = 0;
    }

    public void clear() {
        this.clearBlockCount();
        this.mass = 0.0f;
    }

    public float getMass() {
        return this.mass;
    }

    public void setMass(float mass) {
        this.mass = mass;
    }

    public float getSpeedLimit() {
        return this.speedLimit;
    }

    public void setSpeedLimit(float speedLimit) {
        this.speedLimit = speedLimit;
    }

    public float getBankingMultiplier() {
        return this.bankingMultiplier;
    }

    public void setBankingMultiplier(float bankingMultiplier) {
        this.bankingMultiplier = bankingMultiplier;
    }

    public boolean canFly() {
        return this.canFly;
    }

    public void setCanFly(boolean canFly) {
        this.canFly = canFly;
    }

    public void readFromNBT(NBTTagCompound tag) {
    }

    public void writeToNBT(NBTTagCompound tag) {
    }
}

