/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.movingworld.common.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import darkevilmac.movingworld.common.network.ChunkBlockUpdateMessage;
import darkevilmac.movingworld.common.network.FarInteractMessage;
import darkevilmac.movingworld.common.network.MovingWorldClientActionMessage;
import darkevilmac.movingworld.common.network.MovingWorldMessage;
import darkevilmac.movingworld.common.network.RequestMovingWorldDataMessage;
import darkevilmac.movingworld.common.network.TileEntitiesMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;

public class MovingWorldMessageToMessageCodec
extends FMLIndexedMessageToMessageCodec<MovingWorldMessage> {
    private int index = 1;

    public MovingWorldMessageToMessageCodec() {
        this.addDiscriminator(ChunkBlockUpdateMessage.class);
        this.addDiscriminator(FarInteractMessage.class);
        this.addDiscriminator(MovingWorldClientActionMessage.class);
        this.addDiscriminator(RequestMovingWorldDataMessage.class);
        this.addDiscriminator(TileEntitiesMessage.class);
    }

    public FMLIndexedMessageToMessageCodec<MovingWorldMessage> addDiscriminator(Class<? extends MovingWorldMessage> type) {
        FMLIndexedMessageToMessageCodec ret = super.addDiscriminator(this.index, type);
        ++this.index;
        return ret;
    }

    public void encodeInto(ChannelHandlerContext ctx, MovingWorldMessage msg, ByteBuf target) throws Exception {
        msg.encodeInto(ctx, target, FMLCommonHandler.instance().getSide());
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, MovingWorldMessage msg) {
        switch (FMLCommonHandler.instance().getEffectiveSide()) {
            case CLIENT: {
                EntityPlayer player = this.getClientPlayer();
                msg.decodeInto(ctx, source, player, FMLCommonHandler.instance().getSide());
                break;
            }
            case SERVER: {
                EntityPlayer player = this.getServerPlayer(ctx);
                msg.decodeInto(ctx, source, player, FMLCommonHandler.instance().getSide());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    private EntityPlayer getServerPlayer(ChannelHandlerContext ctx) {
        INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
        return ((NetHandlerPlayServer)netHandler).field_147369_b;
    }
}

