/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.movingworld.common.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import darkevilmac.movingworld.common.chunk.mobilechunk.MobileChunkClient;
import darkevilmac.movingworld.common.entity.EntityMovingWorld;
import darkevilmac.movingworld.common.network.EntityMovingWorldMessage;
import darkevilmac.movingworld.common.tile.TileMovingWorldMarkingBlock;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntitiesMessage
extends EntityMovingWorldMessage {
    private NBTTagCompound tagCompound = null;

    public TileEntitiesMessage() {
    }

    public TileEntitiesMessage(EntityMovingWorld movingWorld) {
        super(movingWorld);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buf, Side side) {
        super.encodeInto(ctx, buf, side);
        this.tagCompound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (TileEntity te : this.movingWorld.getMovingWorldChunk().chunkTileEntityMap.values()) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (te instanceof TileMovingWorldMarkingBlock) {
                ((TileMovingWorldMarkingBlock)te).writeNBTForSending(nbt);
            } else {
                te.func_145841_b(nbt);
            }
            list.func_74742_a((NBTBase)nbt);
        }
        this.tagCompound.func_74782_a("list", (NBTBase)list);
        DataOutputStream out = new DataOutputStream((OutputStream)new ByteBufOutputStream(buf));
        try {
            CompressedStreamTools.func_74800_a((NBTTagCompound)this.tagCompound, (DataOutput)out);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buf, EntityPlayer player, Side side) {
        if (this.movingWorld != null) {
            DataInputStream in = new DataInputStream((InputStream)new ByteBufInputStream(buf));
            try {
                this.tagCompound = CompressedStreamTools.func_74794_a((DataInputStream)in);
            }
            catch (IOException e) {
                try {
                    throw e;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        if (this.movingWorld != null && this.tagCompound != null) {
            NBTTagList list = this.tagCompound.func_150295_c("list", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbt = list.func_150305_b(i);
                if (nbt == null) continue;
                int x = nbt.func_74762_e("x");
                int y = nbt.func_74762_e("y");
                int z = nbt.func_74762_e("z");
                try {
                    TileEntity te = this.movingWorld.getMovingWorldChunk().func_147438_o(x, y, z);
                    if (te == null) continue;
                    te.func_145839_a(nbt);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ((MobileChunkClient)this.movingWorld.getMovingWorldChunk()).getRenderer().markDirty();
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

