/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.movingworld.common.tile;

import darkevilmac.movingworld.common.chunk.LocatedBlock;
import darkevilmac.movingworld.common.chunk.assembly.AssembleResult;
import darkevilmac.movingworld.common.chunk.assembly.ChunkAssembler;
import darkevilmac.movingworld.common.chunk.assembly.MovingWorldAssemblyInteractor;
import darkevilmac.movingworld.common.entity.EntityMovingWorld;
import darkevilmac.movingworld.common.entity.MovingWorldInfo;
import darkevilmac.movingworld.common.tile.IMovingWorldTileEntity;
import darkevilmac.movingworld.common.util.LocatedBlockList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public abstract class TileMovingWorldMarkingBlock
extends TileEntity
implements IMovingWorldTileEntity {
    public LocatedBlockList removedFluidBlocks;
    private AssembleResult assembleResult;
    private AssembleResult prevResult;

    public TileMovingWorldMarkingBlock() {
        this.setParentMovingWorld(null);
        this.prevResult = null;
        this.assembleResult = null;
    }

    public abstract MovingWorldAssemblyInteractor getInteractor();

    public abstract void setInteractor(MovingWorldAssemblyInteractor var1);

    public abstract MovingWorldInfo getInfo();

    public abstract void setInfo(MovingWorldInfo var1);

    public abstract int getMaxBlocks();

    public AssembleResult getPrevAssembleResult() {
        return this.prevResult;
    }

    public void setPrevAssembleResult(AssembleResult result) {
        this.prevResult = result;
    }

    public AssembleResult getAssembleResult() {
        return this.assembleResult;
    }

    public void setAssembleResult(AssembleResult assembleResult) {
        this.assembleResult = assembleResult;
    }

    public abstract EntityMovingWorld getMovingWorld(World var1);

    public boolean assembleMovingWorld(EntityPlayer player) {
        boolean returnVal = false;
        if (!this.field_145850_b.field_72995_K) {
            this.prevResult = this.assembleResult;
            ChunkAssembler assembler = new ChunkAssembler(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getMaxBlocks());
            MovingWorldAssemblyInteractor interactor = this.getNewAssemblyInteractor();
            this.assembleResult = assembler.doAssemble(interactor);
            this.assembledMovingWorld(player, returnVal);
            this.setInteractor(interactor);
            switch (this.assembleResult.getCode()) {
                case 1: {
                    ChatComponentText c = new ChatComponentText("Assembled " + this.getInfo().getName() + "!");
                    player.func_145747_a((IChatComponent)c);
                    break;
                }
                case 7: {
                    returnVal = true;
                }
                case 2: {
                    ChatComponentText c = new ChatComponentText("Cannot create moving world with more than " + this.getMaxBlocks() + " blocks");
                    player.func_145747_a((IChatComponent)c);
                    break;
                }
                case 3: {
                    ChatComponentText c = new ChatComponentText("Cannot create moving world with no moving world marker");
                    player.func_145747_a((IChatComponent)c);
                    break;
                }
                case 4: {
                    ChatComponentText c = new ChatComponentText("An error occured while assembling moving world. See console log for details.");
                    player.func_145747_a((IChatComponent)c);
                    break;
                }
                case 0: {
                    ChatComponentText c = new ChatComponentText("Nothing was assembled");
                    player.func_145747_a((IChatComponent)c);
                    break;
                }
            }
        }
        return returnVal;
    }

    public void assembledMovingWorld(EntityPlayer player, boolean returnVal) {
    }

    public boolean mountMovingWorld(EntityPlayer player, EntityMovingWorld movingWorld) {
        if (!this.field_145850_b.field_72995_K && this.assembleResult != null && this.assembleResult.isOK()) {
            this.assembleResult.checkConsistent(this.field_145850_b);
            this.mountedMovingWorld(player, movingWorld, 1);
            if (this.assembleResult.getCode() == 6) {
                return false;
            }
            if (this.assembleResult.getCode() == 7) {
                ChatComponentText c = new ChatComponentText("Moving world contains changes");
                player.func_145747_a((IChatComponent)c);
            }
            this.mountedMovingWorld(player, movingWorld, 2);
            EntityMovingWorld entity = this.assembleResult.getEntity(this.field_145850_b, movingWorld);
            if (entity != null) {
                entity.setInfo(this.getInfo());
                if (this.field_145850_b.func_72838_d((Entity)entity)) {
                    player.func_70078_a((Entity)entity);
                    this.assembleResult = null;
                    return true;
                }
            }
            this.mountedMovingWorld(player, entity, 3);
        }
        return false;
    }

    public void undoCompilation(EntityPlayer player) {
        this.assembleResult = this.prevResult;
        this.prevResult = null;
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeNBTForSending(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public abstract MovingWorldAssemblyInteractor getNewAssemblyInteractor();

    public void mountedMovingWorld(EntityPlayer player, EntityMovingWorld movingWorld, int stage) {
    }

    public void func_145839_a(NBTTagCompound compound) {
        int id;
        Entity entity;
        super.func_145839_a(compound);
        this.getInfo().setName(compound.func_74779_i("name"));
        if (compound.func_74764_b("owner")) {
            this.getInfo().setOwner(UUID.fromString(compound.func_74779_i("owner")));
        }
        this.field_145847_g = compound.func_74762_e("meta");
        if (compound.func_74764_b("ship") && this.field_145850_b != null && (entity = this.field_145850_b.func_73045_a(id = compound.func_74762_e("ship"))) instanceof EntityMovingWorld) {
            this.setParentMovingWorld((EntityMovingWorld)entity);
        }
        if (compound.func_74764_b("res")) {
            this.assembleResult = new AssembleResult(compound.func_74775_l("res"), this.field_145850_b);
            this.assembleResult.assemblyInteractor = this.getNewAssemblyInteractor().fromNBT(compound.func_74775_l("res"), this.field_145850_b);
        }
        if (compound.func_74764_b("removedFluidCompounds")) {
            this.removedFluidBlocks = new LocatedBlockList();
            NBTTagCompound removedFluidCompound = compound.func_74775_l("removedFluidCompounds");
            int tagIndex = 0;
            while (removedFluidCompound.func_74764_b("block#" + tagIndex)) {
                NBTTagCompound lbTag = removedFluidCompound.func_74775_l("block#" + tagIndex);
                LocatedBlock locatedBlock = new LocatedBlock(lbTag, this.field_145850_b);
                this.removedFluidBlocks.add(locatedBlock);
                ++tagIndex;
            }
            compound.func_74782_a("removedFluidCompounds", (NBTBase)new NBTTagCompound());
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74778_a("name", this.getInfo().getName());
        if (this.getInfo().getOwner() != null) {
            compound.func_74778_a("owner", this.getInfo().getOwner().toString());
        }
        compound.func_74768_a("meta", this.field_145847_g);
        compound.func_74778_a("name", this.getInfo().getName());
        if (this.getParentMovingWorld() != null && !this.getParentMovingWorld().field_70128_L) {
            compound.func_74768_a("movingWorld", this.getParentMovingWorld().func_145782_y());
        }
        if (this.assembleResult != null) {
            NBTTagCompound comp = new NBTTagCompound();
            this.assembleResult.writeNBTFully(comp);
            this.assembleResult.assemblyInteractor.writeNBTFully(comp);
            compound.func_74782_a("res", (NBTBase)comp);
        }
        if (this.removedFluidBlocks != null && !this.removedFluidBlocks.isEmpty()) {
            NBTTagCompound removedFluidCompound = new NBTTagCompound();
            for (int i = 0; i < this.removedFluidBlocks.size(); ++i) {
                LocatedBlock locatedBlock = (LocatedBlock)this.removedFluidBlocks.get(i);
                NBTTagCompound lbTag = new NBTTagCompound();
                locatedBlock.writeToNBT(lbTag);
                removedFluidCompound.func_74782_a("block#" + i, (NBTBase)lbTag);
            }
            compound.func_74782_a("removedFluidCompounds", (NBTBase)removedFluidCompound);
        }
    }

    public void writeNBTForSending(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("meta", this.field_145847_g);
        compound.func_74778_a("name", this.getInfo().getName());
        if (this.getParentMovingWorld() != null && !this.getParentMovingWorld().field_70128_L) {
            compound.func_74768_a("movingWorld", this.getParentMovingWorld().func_145782_y());
        }
        if (this.assembleResult != null) {
            NBTTagCompound comp = new NBTTagCompound();
            this.assembleResult.writeNBTMetadata(comp);
            this.assembleResult.assemblyInteractor.writeNBTMetadata(comp);
            compound.func_74782_a("res", (NBTBase)comp);
        }
    }
}

