/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.movingworld.common.util;

import darkevilmac.movingworld.common.chunk.LocatedBlock;
import darkevilmac.movingworld.common.chunk.mobilechunk.MobileChunk;
import darkevilmac.movingworld.common.util.ChunkPositionUtils;
import darkevilmac.movingworld.common.util.LocatedBlockList;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;

public class FloodFiller {
    private LocatedBlockList lbList = new LocatedBlockList();
    private ArrayList<ChunkPosition> posStack;

    public LocatedBlockList floodFillMobileChunk(MobileChunk mobileChunk) {
        this.lbList = new LocatedBlockList();
        this.fillCoord(mobileChunk, mobileChunk.maxX() / 2, mobileChunk.maxY() + 1, mobileChunk.maxZ() / 2);
        this.cleanList(mobileChunk);
        return this.lbList;
    }

    private void cleanList(MobileChunk mobileChunk) {
        Iterator lbIterator = this.lbList.iterator();
        while (lbIterator.hasNext()) {
            ChunkPosition lbPos = ((LocatedBlock)lbIterator.next()).coords;
            if (lbPos.field_151329_a <= mobileChunk.maxX() - 1 && lbPos.field_151329_a >= mobileChunk.minX() && lbPos.field_151327_b <= mobileChunk.maxY() - 1 && lbPos.field_151327_b >= mobileChunk.minY() && lbPos.field_151328_c <= mobileChunk.maxZ() - 1 && lbPos.field_151328_c >= mobileChunk.minZ()) continue;
            lbIterator.remove();
        }
    }

    private void fillCoord(MobileChunk mobileChunk, int startX, int startY, int startZ) {
        this.posStack = new ArrayList();
        this.posStack.add(new ChunkPosition(startX, startY, startZ));
        while (!this.posStack.isEmpty()) {
            ChunkPosition pos = this.posStack.get(this.posStack.size() - 1);
            this.posStack.remove(this.posStack.size() - 1);
            Block block = mobileChunk.func_147439_a(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
            int blockMeta = mobileChunk.func_72805_g(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
            int x = pos.field_151329_a;
            int y = pos.field_151327_b;
            int z = pos.field_151328_c;
            if (block != null && !(block instanceof BlockAir) && !block.isAir((IBlockAccess)mobileChunk, x, y, z) || x > mobileChunk.maxX() || x < mobileChunk.minX() - 1 || y > mobileChunk.maxY() + 1 || y < mobileChunk.minY() - 1 || z > mobileChunk.maxZ() || z < mobileChunk.minZ() - 1 || this.lbList.containsLBOfPos(pos)) continue;
            this.lbList.add(new LocatedBlock(block, blockMeta, pos));
            this.posStack.add(ChunkPositionUtils.combine(pos, new ChunkPosition(1, 0, 0)));
            this.posStack.add(ChunkPositionUtils.combine(pos, new ChunkPosition(0, 1, 0)));
            this.posStack.add(ChunkPositionUtils.combine(pos, new ChunkPosition(0, 0, 1)));
            this.posStack.add(ChunkPositionUtils.combine(pos, new ChunkPosition(-1, 0, 0)));
            this.posStack.add(ChunkPositionUtils.combine(pos, new ChunkPosition(0, -1, 0)));
            this.posStack.add(ChunkPositionUtils.combine(pos, new ChunkPosition(0, 0, -1)));
        }
    }
}

