/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingbook.block;

import net.blay09.mods.cookingbook.CookingConfig;
import net.blay09.mods.cookingbook.CookingForBlockheads;
import net.blay09.mods.cookingbook.block.TileEntitySink;
import net.blay09.mods.cookingbook.client.render.SinkBlockRenderer;
import net.blay09.mods.cookingbook.registry.CookingRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BlockSink
extends BlockContainer {
    public BlockSink() {
        super(Material.field_151575_d);
        this.func_149663_c("cookingbook:sink");
        this.func_149647_a(CookingForBlockheads.creativeTab);
        this.func_149672_a(field_149766_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.975f, 0.9375f);
    }

    public void func_149726_b(World worldIn, int x, int y, int z) {
        super.func_149726_b(worldIn, x, y, z);
        this.findOrientation(worldIn, x, y, z);
    }

    private void findOrientation(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block block = world.func_147439_a(x, y, z - 1);
            Block block1 = world.func_147439_a(x, y, z + 1);
            Block block2 = world.func_147439_a(x - 1, y, z);
            Block block3 = world.func_147439_a(x + 1, y, z);
            int side = 3;
            if (block.func_149662_c() && !block1.func_149662_c()) {
                side = 3;
            }
            if (block1.func_149662_c() && !block.func_149662_c()) {
                side = 2;
            }
            if (block2.func_149662_c() && !block3.func_149662_c()) {
                side = 5;
            }
            if (block3.func_149662_c() && !block2.func_149662_c()) {
                side = 4;
            }
            world.func_72921_c(x, y, z, side, 2);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return SinkBlockRenderer.RENDER_ID;
    }

    public void func_149651_a(IIconRegister iconRegister) {
    }

    public IIcon func_149691_a(int side, int metadata) {
        return Blocks.field_150364_r.func_149691_a(side, 1);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntitySink sink;
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)player.func_70694_bm())) {
            FluidStack fluidStack = null;
            int amount = FluidContainerRegistry.getContainerCapacity((FluidStack)new FluidStack(FluidRegistry.WATER, 1000), (ItemStack)player.func_70694_bm());
            if (CookingConfig.sinkRequiresWater) {
                TileEntitySink sink2 = (TileEntitySink)world.func_147438_o(x, y, z);
                if (sink2.getWaterAmount() >= amount) {
                    fluidStack = sink2.drain(ForgeDirection.UNKNOWN, amount, true);
                }
            } else {
                fluidStack = new FluidStack(FluidRegistry.WATER, amount);
            }
            if (fluidStack != null && fluidStack.amount >= amount) {
                ItemStack filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStack, (ItemStack)player.func_70694_bm());
                if (filledContainer != null) {
                    if (player.func_70694_bm().field_77994_a <= 1) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filledContainer);
                    } else if (player.field_71071_by.func_70441_a(filledContainer)) {
                        --player.func_70694_bm().field_77994_a;
                    }
                }
                this.spawnParticles(world, x, y, z);
            }
            return true;
        }
        if (FluidContainerRegistry.isFilledContainer((ItemStack)player.func_70694_bm())) {
            ItemStack emptyContainer;
            FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)player.func_70694_bm());
            if (CookingConfig.sinkRequiresWater) {
                TileEntitySink sink3 = (TileEntitySink)world.func_147438_o(x, y, z);
                sink3.fill(ForgeDirection.UNKNOWN, fluidStack, true);
            }
            if ((emptyContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)player.func_70694_bm())) != null) {
                if (player.func_70694_bm().field_77994_a <= 1) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, emptyContainer);
                } else if (player.field_71071_by.func_70441_a(emptyContainer)) {
                    --player.func_70694_bm().field_77994_a;
                }
            }
            this.spawnParticles(world, x, y, z);
            return true;
        }
        ItemStack resultStack = CookingRegistry.getSinkOutput(player.func_70694_bm());
        if (resultStack != null) {
            ItemStack oldItem = player.func_70694_bm();
            NBTTagCompound tagCompound = oldItem.func_77978_p();
            ItemStack newItem = resultStack.func_77946_l();
            newItem.func_77982_d(tagCompound);
            if (oldItem.field_77994_a <= 1) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newItem);
            } else if (player.field_71071_by.func_70441_a(newItem)) {
                --oldItem.field_77994_a;
            }
            this.spawnParticles(world, x, y, z);
            return true;
        }
        if (CookingConfig.sinkRequiresWater && (sink = (TileEntitySink)world.func_147438_o(x, y, z)).getWaterAmount() < 1000) {
            return false;
        }
        this.spawnParticles(world, x, y, z);
        return false;
    }

    public void spawnParticles(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        float dripWaterX = 0.0f;
        float dripWaterZ = 0.0f;
        switch (metadata) {
            case 2: {
                dripWaterZ = 0.25f;
                dripWaterX = -0.05f;
                break;
            }
            case 3: {
                dripWaterX = 0.25f;
                break;
            }
            case 4: {
                dripWaterX = 0.25f;
                dripWaterZ = 0.25f;
                break;
            }
            case 5: {
                dripWaterZ = -0.05f;
            }
        }
        float particleX = (float)x + 0.5f;
        float particleY = (float)y + 1.25f;
        float particleZ = (float)z + 0.5f;
        world.func_72869_a("dripWater", (double)particleX + (double)dripWaterX, (double)particleY - (double)0.45f, (double)particleZ + (double)dripWaterZ, 0.0, 0.0, 0.0);
        for (int i = 0; i < 5; ++i) {
            world.func_72869_a("splash", (double)particleX + Math.random() - 0.5, (double)particleY + Math.random() - 0.5, (double)particleZ + Math.random() - 0.5, 0.0, 0.0, 0.0);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase placer, ItemStack itemStack) {
        int l = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (l == 1) {
            world.func_72921_c(x, y, z, 5, 2);
        }
        if (l == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (l == 3) {
            world.func_72921_c(x, y, z, 4, 2);
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntitySink();
    }
}

