/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingbook.block;

import net.blay09.mods.cookingbook.api.kitchen.IKitchenStorageProvider;
import net.blay09.mods.cookingbook.registry.CookingRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityToaster
extends TileEntity
implements IInventory,
IKitchenStorageProvider {
    private static final int TOAST_TICKS = 60;
    private ItemStack[] inventory = new ItemStack[2];
    private EntityItem[] renderItems = new EntityItem[2];
    private boolean active;
    private int toastTicks;

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        for (int i = 0; i < this.renderItems.length; ++i) {
            this.renderItems[i] = new EntityItem(this.field_145850_b, 0.0, 0.0, 0.0);
            this.renderItems[i].field_70290_d = 0.0f;
            this.renderItems[i].func_92058_a(this.inventory[i]);
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int i, int count) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= count) {
                ItemStack itemStack = this.inventory[i];
                this.inventory[i] = null;
                this.func_70296_d();
                return itemStack;
            }
            ItemStack itemStack = this.inventory[i].func_77979_a(count);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            this.func_70296_d();
            return itemStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.inventory[i] = itemStack;
        if (this.renderItems[i] != null) {
            this.renderItems[i].func_92058_a(itemStack);
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "container.cookingbook:toaster";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.func_145830_o()) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory = new ItemStack[this.func_70302_i_()];
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemCompound = tagList.func_150305_b(i);
            this.func_70299_a(itemCompound.func_74771_c("Slot"), ItemStack.func_77949_a((NBTTagCompound)itemCompound));
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound itemCompound = new NBTTagCompound();
            itemCompound.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(itemCompound);
            tagList.func_74742_a((NBTBase)itemCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tagCompound);
    }

    public void func_145845_h() {
        if (this.active) {
            --this.toastTicks;
            if (this.toastTicks <= 0) {
                for (int i = 0; i < this.func_70302_i_(); ++i) {
                    ItemStack inputStack = this.func_70301_a(i);
                    if (inputStack == null) continue;
                    ItemStack outputStack = CookingRegistry.getToastOutput(inputStack);
                    if (outputStack == null) {
                        outputStack = inputStack;
                    }
                    if (this.field_145850_b.field_72995_K) continue;
                    EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.75f), (double)((float)this.field_145849_e + 0.5f), outputStack);
                    entityItem.field_70159_w = 0.0;
                    entityItem.field_70181_x = 0.1f;
                    entityItem.field_70179_y = 0.0;
                    if (!this.field_145850_b.func_72838_d((Entity)entityItem)) continue;
                    this.func_70299_a(i, null);
                }
                this.setActive(false);
            }
        }
    }

    public EntityItem getRenderItem(int i) {
        return this.renderItems[i];
    }

    @Override
    public IInventory getInventory() {
        return (IInventory)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.toastTicks = active ? 60 : 0;
    }
}

