/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.net.message;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityBeefBase;
import erogenousbeef.bigreactors.net.message.base.WorldMessageServer;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;

public class DeviceChangeExposureMessage
extends WorldMessageServer {
    private int side;
    private boolean increment;

    public DeviceChangeExposureMessage() {
    }

    public DeviceChangeExposureMessage(int x, int y, int z, int side, boolean increment) {
        super(x, y, z);
        this.side = side;
        this.increment = increment;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.side = buf.readInt();
        this.increment = buf.readBoolean();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.side);
        buf.writeBoolean(this.increment);
    }

    public static class Handler
    extends WorldMessageServer.Handler<DeviceChangeExposureMessage> {
        @Override
        protected IMessage handleMessage(DeviceChangeExposureMessage message, MessageContext ctx, TileEntity te) {
            if (te instanceof TileEntityBeefBase) {
                TileEntityBeefBase beefTe = (TileEntityBeefBase)te;
                if (message.increment) {
                    beefTe.incrSide(message.side);
                } else {
                    beefTe.decrSide(message.side);
                }
            } else {
                BRLog.warning("Received SideChangeMessage for TE at %d, %d, %d, but it was not a TE with an iterable side exposure!", te.field_145851_c, te.field_145848_d, te.field_145849_e);
            }
            return null;
        }
    }
}

