/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.armor;

import java.util.EnumSet;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.armor.ArmorMod;
import tconstruct.library.armor.ArmorPart;
import tconstruct.library.modifier.IModifyable;

public class TravelModDoubleJump
extends ArmorMod {
    String color = "\u00a77";
    String tooltipName = "Double-Jump";

    public TravelModDoubleJump(EnumSet<ArmorPart> armorTypes, ItemStack[] items) {
        super(0, "Double-Jump", armorTypes, items);
    }

    @Override
    public boolean validType(IModifyable type) {
        return type.getModifyType().equals("Clothing");
    }

    @Override
    public void modify(ItemStack[] recipe, ItemStack input) {
        NBTTagCompound tags = input.func_77978_p().func_74775_l(this.getTagName(input));
        int amount = 1;
        if (tags.func_74764_b(this.key)) {
            int increase = tags.func_74762_e(this.key);
            tags.func_74768_a(this.key, ++increase);
        } else {
            tags.func_74768_a(this.key, amount);
        }
        int modifiers = tags.func_74762_e("Modifiers");
        tags.func_74768_a("Modifiers", --modifiers);
        this.addToolTip(input, this.color + this.tooltipName, this.color + this.key);
    }

    @Override
    protected int addToolTip(ItemStack tool, String tooltip, String modifierTip) {
        String tip;
        String tag;
        NBTTagCompound tags = tool.func_77978_p().func_74775_l(this.getTagName(tool));
        int tipNum = 0;
        do {
            if (tags.func_74764_b(tip = "Tooltip" + ++tipNum)) continue;
            tags.func_74778_a(tip, tooltip);
            String modTip = "ModifierTip" + tipNum;
            tags.func_74778_a(modTip, modifierTip);
            return tipNum;
        } while (!(tag = tags.func_74779_i(tip)).contains("Double-Jump") && !tag.contains("Triple-Jump"));
        tags.func_74778_a(tip, this.getProperName(tooltip, tag));
        String modTip = "ModifierTip" + tipNum;
        tag = tags.func_74779_i(modTip);
        tags.func_74778_a(modTip, this.getProperName(modifierTip, tag));
        return tipNum;
    }

    @Override
    protected String getProperName(String tooltip, String tag) {
        if (tag.contains("Double-Jump")) {
            return this.color + "Triple-Jump";
        }
        if (tag.contains("Triple-Jump")) {
            return this.color + "Quadruple-Jump";
        }
        if (tag.contains("Quadruple-Jump")) {
            return this.color + "Quintuple-Jump";
        }
        if (tag.contains("Quintuple-Jump")) {
            return this.color + "Sextuple-Jump";
        }
        if (tag.contains("Sextuple-Jump")) {
            return this.color + "Septuple-Jump";
        }
        return this.color + "Double-Jump";
    }
}

