/*
 * Decompiled with CFR 0.152.
 */
package chocohead.patcher;

import binnie.core.BinnieCore;
import binnie.core.Mods;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.block.PlankType;
import binnie.extratrees.item.ExtraTreeItems;
import binnie.extratrees.item.Food;
import chocohead.patcher.ITransformer;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import forestry.api.apiculture.FlowerManager;
import forestry.api.genetics.IFlowerAcceptableRule;
import forestry.api.genetics.IFruitBearer;
import forestry.plugins.PluginArboriculture;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@IFMLLoadingPlugin.Name(value="Binnie Patcher ASM")
@IFMLLoadingPlugin.MCVersion(value="1.7.10")
@IFMLLoadingPlugin.SortingIndex(value=2007)
@IFMLLoadingPlugin.TransformerExclusions(value={"chocohead.patcher", "chocohead.patcher."})
public final class BinniePatcher
implements IFMLLoadingPlugin,
IClassTransformer {
    private static final Map<String, ITransformer> transformerMap = new HashMap<String, ITransformer>();
    public static final boolean obfuscated;

    public String[] getASMTransformerClass() {
        return new String[]{"chocohead.patcher.BinniePatcher"};
    }

    public String getModContainerClass() {
        return "chocohead.patcher.BinniePatcher$Patcher";
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        for (String clazz : new String[]{"binniecore", "botany", "extrabees", "extratrees", "genetics"}) {
            try {
                ((ITransformer.IRooter)Class.forName("chocohead.patcher." + clazz + ".Root").newInstance()).addTransformers(transformerMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ITransformer transformer = transformerMap.get(transformedName);
        if (transformer == null) {
            return basicClass;
        }
        transformerMap.remove(transformedName);
        return transformer.transform(basicClass);
    }

    static {
        boolean o = true;
        try {
            o = Launch.classLoader.getClassBytes("net.minecraft.world.World") == null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        obfuscated = o;
    }

    public static final class Patcher
    extends DummyModContainer {
        @Mod.Instance(value="BinniePatcher")
        public static Patcher instance;
        public static Logger logger;

        public Patcher() {
            super(new ModMetadata());
            ModMetadata md = super.getMetadata();
            md.name = "Binnie Patcher";
            md.modId = "BinniePatcher";
            md.description = "Coremod to fix patch Binnie's Mods for Forestry 4";
            md.version = "1.8.2";
            md.url = "http://forum.feed-the-beast.com/threads/1-7-10-binnie-patcher.143722";
            md.authorList = Collections.singletonList("Chocohead");
            md.credits = "Thanks to Binnie for his mods and all the Forestry team :)";
            md.autogenerated = false;
            md.parent = "BinnieCore";
            md.dependencies = Arrays.asList(VersionParser.parseVersionReference((String)"Forestry"), VersionParser.parseVersionReference((String)"BinnieCore"));
            instance = this;
            logger = LogManager.getLogger((String)"Binnie Patcher");
        }

        public boolean registerBus(EventBus bus, LoadController controller) {
            bus.register((Object)this);
            return true;
        }

        @Subscribe
        public void preInit(FMLPreInitializationEvent event) {
            if (!Loader.isModLoaded((String)"BinnieCore")) {
                throw new RuntimeException("Binnie's mods jar must also be present for Binnie Patcher to work.");
            }
            logger = event.getModLog();
        }

        @Subscribe
        public void init(FMLInitializationEvent event) {
            if (BinnieCore.isExtraTreesActive()) {
                for (int i = 0; i < PlankType.ExtraTreePlanks.values().length; ++i) {
                    OreDictionary.registerOre((String)"slabWood", (ItemStack)new ItemStack(ExtraTrees.blockSlab, 1, i));
                }
                OreDictionary.registerOre((String)"pulpWood", (ItemStack)ExtraTreeItems.Sawdust.get(1));
                Food.registerOreDictionary();
                OreDictionary.registerOre((String)"cropApple", (Item)Items.field_151034_e);
                OreDictionary.registerOre((String)"cropHops", (ItemStack)ExtraTreeItems.Hops.get(1));
                OreDictionary.registerOre((String)"seedWheat", (Item)Items.field_151015_O);
                OreDictionary.registerOre((String)"seedWheat", (ItemStack)ExtraTreeItems.GrainWheat.get(1));
                OreDictionary.registerOre((String)"seedBarley", (ItemStack)ExtraTreeItems.GrainBarley.get(1));
                OreDictionary.registerOre((String)"seedCorn", (ItemStack)ExtraTreeItems.GrainCorn.get(1));
                OreDictionary.registerOre((String)"seedRye", (ItemStack)ExtraTreeItems.GrainRye.get(1));
                OreDictionary.registerOre((String)"seedRoasted", (ItemStack)ExtraTreeItems.GrainRoasted.get(1));
            }
        }

        @Subscribe
        public void postInit(FMLPostInitializationEvent event) {
            if (BinnieCore.isExtraTreesActive()) {
                PluginArboriculture.validFences.add(ExtraTrees.blockFence);
                PluginArboriculture.validFences.add(ExtraTrees.blockMultiFence);
                PluginArboriculture.validFences.add(ExtraTrees.blockGate);
            }
            if (BinnieCore.isExtraBeesActive()) {
                FlowerManager.flowerRegistry.registerAcceptableFlower(Blocks.field_150355_j, new String[]{"extrabees.flower.water"});
                FlowerManager.flowerRegistry.registerAcceptableFlower(Blocks.field_150436_aH, new String[]{"extrabees.flower.sugar"});
                FlowerManager.flowerRegistry.registerAcceptableFlower(Blocks.field_150348_b, new String[]{"extrabees.flower.rock"});
                FlowerManager.flowerRegistry.registerAcceptableFlowerRule(new IFlowerAcceptableRule(){

                    public boolean isAcceptableFlower(String flowerType, World world, int x, int y, int z) {
                        Block block;
                        if (flowerType.equals("extrabees.flower.rock") && (block = world.func_147439_a(x, y, z)) != null) {
                            return block.func_149688_o() == Material.field_151576_e;
                        }
                        return false;
                    }
                }, new String[]{"extrabees.flower.rock"});
                FlowerManager.flowerRegistry.registerAcceptableFlower(Blocks.field_150342_X, new String[]{"extrabees.flower.book"});
                FlowerManager.flowerRegistry.registerAcceptableFlower((Block)Blocks.field_150330_I, new String[]{"extrabees.flower.dead"});
                FlowerManager.flowerRegistry.registerAcceptableFlower(Blocks.field_150429_aA, new String[]{"extrabees.flower.redstone"});
                FlowerManager.flowerRegistry.registerAcceptableFlower(Blocks.field_150364_r, new String[]{"extrabees.flower.wood"});
                FlowerManager.flowerRegistry.registerAcceptableFlowerRule(new IFlowerAcceptableRule(){

                    public boolean isAcceptableFlower(String flowerType, World world, int x, int y, int z) {
                        Block block;
                        if (flowerType.equals("extrabees.flower.wood") && (block = world.func_147439_a(x, y, z)) != null) {
                            return block.isWood((IBlockAccess)world, x, y, z);
                        }
                        return false;
                    }
                }, new String[]{"extrabees.flower.wood"});
                FlowerManager.flowerRegistry.registerAcceptableFlower((Block)Blocks.field_150362_t, new String[]{"extrabees.flower.leaves"});
                FlowerManager.flowerRegistry.registerAcceptableFlowerRule(new IFlowerAcceptableRule(){

                    public boolean isAcceptableFlower(String flowerType, World world, int x, int y, int z) {
                        Block block;
                        if (flowerType.equals("extrabees.flower.leaves") && (block = world.func_147439_a(x, y, z)) != null) {
                            return block.isLeaves((IBlockAccess)world, x, y, z);
                        }
                        return false;
                    }
                }, new String[]{"extrabees.flower.leaves"});
                FlowerManager.flowerRegistry.registerAcceptableFlower(Blocks.field_150345_g, new String[]{"extrabees.flower.sapling"});
                FlowerManager.flowerRegistry.registerAcceptableFlowerRule(new IFlowerAcceptableRule(){

                    public boolean isAcceptableFlower(String flowerType, World world, int x, int y, int z) {
                        Block block;
                        if (flowerType.equals("extrabees.flower.sapling") && (block = world.func_147439_a(x, y, z)) != null) {
                            block.getClass().getName().toLowerCase().contains("sapling");
                        }
                        return false;
                    }
                }, new String[]{"extrabees.flower.sapling"});
                try {
                    FlowerManager.flowerRegistry.registerAcceptableFlower((Block)PluginArboriculture.blocks.pods, new String[]{"extrabees.flower.sapling"});
                }
                catch (NoSuchFieldError e) {
                    logger.warn("You ought to update Forestry to 4.2.1+: ", (Throwable)e);
                }
                FlowerManager.flowerRegistry.registerAcceptableFlowerRule(new IFlowerAcceptableRule(){

                    public boolean isAcceptableFlower(String flowerType, World world, int x, int y, int z) {
                        return flowerType.equals("extrabees.flower.fruit") ? world.func_147438_o(x, y, z) instanceof IFruitBearer : false;
                    }
                }, new String[]{"extrabees.flower.fruit"});
                if (Mods.Botania.active()) {
                    FlowerManager.flowerRegistry.registerAcceptableFlower(Mods.Botania.block("flower"), new String[]{"extrabees.flower.mystical"});
                }
            }
        }
    }
}

