/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import openmods.calc.Frame;
import openmods.calc.FrameFactory;
import openmods.calc.ICallable;
import openmods.calc.IExecutable;
import openmods.calc.IGettable;
import openmods.calc.ISymbol;
import openmods.utils.Stack;

public class Environment<E> {
    public static final String VAR_ANS = "_ans";
    private final Frame<E> topFrame = this.createTopMap();
    private final E nullValue;

    public Environment(E nullValue) {
        this.nullValue = nullValue;
    }

    protected Frame<E> createTopMap() {
        return FrameFactory.createTopFrame();
    }

    public E nullValue() {
        return this.nullValue;
    }

    public void setGlobalSymbol(String name, ISymbol<E> symbol) {
        this.topFrame.symbols().put(name, symbol);
    }

    public void setGlobalSymbol(String name, ICallable<E> callable) {
        this.topFrame.symbols().put(name, callable);
    }

    public void setGlobalSymbol(String name, IGettable<E> gettable) {
        this.topFrame.symbols().put(name, gettable);
    }

    public void setGlobalSymbol(String name, E value) {
        this.topFrame.symbols().put(name, value);
    }

    public Frame<E> topFrame() {
        return this.topFrame;
    }

    public Frame<E> executeIsolated(IExecutable<E> executable) {
        Frame<E> freshFrame = FrameFactory.newLocalFrame(this.topFrame);
        executable.execute(freshFrame);
        return freshFrame;
    }

    public void execute(IExecutable<E> executable) {
        executable.execute(this.topFrame);
    }

    public E executeAndPop(IExecutable<E> executable) {
        executable.execute(this.topFrame);
        Stack<E> stack = this.topFrame.stack();
        if (stack.isEmpty()) {
            this.topFrame.symbols().put(VAR_ANS, this.nullValue);
            return null;
        }
        E result = stack.pop();
        this.topFrame.symbols().put(VAR_ANS, result);
        return result;
    }
}

