/*
 * Decompiled with CFR 0.152.
 */
package openmods.config.simple;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import openmods.Log;
import openmods.config.simple.ConfigProcessor;
import openmods.config.simple.Entry;
import openmods.reflection.FieldAccess;

public class ClassFrontend {
    public static void processClass(File file, Class<?> cls) {
        ConfigProcessor processor = new ConfigProcessor();
        HashMap fields = Maps.newHashMap();
        for (Field f : cls.getFields()) {
            Field prev;
            Entry e = f.getAnnotation(Entry.class);
            if (e == null) continue;
            Class<?> type = f.getType();
            if (!type.equals(String.class)) {
                Log.warn("Field %s has @Entry annotation, but invalid type %s (should be String)", f, type);
                continue;
            }
            if (!Modifier.isStatic(f.getModifiers())) {
                Log.warn("Field %s has @Entry annotation, but isn't static", f);
                continue;
            }
            String name = e.name();
            if (name.equals("")) {
                name = f.getName();
            }
            Preconditions.checkState(((prev = fields.put(name, f)) == null ? 1 : 0) != 0, (String)"Duplicate field name: %s, fields: %s, %s", (Object[])new Object[]{name, f, prev});
            final FieldAccess wrap = FieldAccess.create(f);
            String defaultValue = (String)wrap.get(null);
            Preconditions.checkNotNull((Object)defaultValue, (String)"Field %s has no default value", (Object[])new Object[]{f});
            processor.addEntry(name, e.version(), defaultValue, new ConfigProcessor.UpdateListener(){

                @Override
                public void valueSet(String value) {
                    wrap.set(null, value);
                }
            }, e.comment());
        }
        processor.process(file);
    }
}

