/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.network.packets;

import com.rwtema.extrautils.nei.ping.ParticlePing;
import com.rwtema.extrautils.network.XUPacketBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.ChunkPosition;

public class PacketNEIPong
extends XUPacketBase {
    List<ChunkPosition> positionList;
    public static final int MAX_SIZE = 20;

    public PacketNEIPong() {
    }

    public PacketNEIPong(List<ChunkPosition> positionList) {
        this.positionList = positionList;
    }

    @Override
    public void writeData(ByteBuf data) throws Exception {
        data.writeByte(this.positionList.size());
        for (ChunkPosition pos : this.positionList) {
            data.writeInt(pos.field_151329_a);
            data.writeByte(pos.field_151327_b);
            data.writeInt(pos.field_151328_c);
        }
    }

    @Override
    public void readData(EntityPlayer player, ByteBuf data) {
        int n = data.readUnsignedByte();
        if (n > 20) {
            n = 20;
        }
        this.positionList = new ArrayList<ChunkPosition>(n);
        for (int i = 0; i < n; ++i) {
            int x = data.readInt();
            short y = data.readUnsignedByte();
            int z = data.readInt();
            this.positionList.add(new ChunkPosition(x, (int)y, z));
        }
    }

    @Override
    public void doStuffServer(ChannelHandlerContext ctx) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doStuffClient() {
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
        for (ChunkPosition chunkPosition : this.positionList) {
            for (int i = 0; i < 20; ++i) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new ParticlePing(Minecraft.func_71410_x().field_71441_e, chunkPosition));
            }
        }
    }

    @Override
    public boolean isValidSenderSide(Side properSenderSide) {
        return properSenderSide == Side.SERVER;
    }
}

