/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SoundGen {
    public static void main(String[] args) {
        try {
            String name;
            int i;
            ZipFile zip = new ZipFile("F:/dev/code/old workspaces/forge-1.7.10-tropicraft/pkg/assets.zip");
            Enumeration<? extends ZipEntry> entries = zip.entries();
            ArrayList<String> soundNames = new ArrayList<String>();
            String initialPath = "assets/tropicraft/";
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.toString().endsWith(".ogg")) continue;
                String name2 = entry.toString();
                if ((name2 = name2.substring(initialPath.length())).startsWith("sounds")) {
                    name2 = name2.substring("sounds".length() + 1);
                }
                soundNames.add(name2.substring(0, name2.length() - 4));
            }
            HashMap<String, ArrayList<String>> numbered = new HashMap<String, ArrayList<String>>();
            for (i = 0; i < soundNames.size(); ++i) {
                String oriName = name = (String)soundNames.get(i);
                boolean isNum = true;
                boolean isNumbered = false;
                while (isNum) {
                    try {
                        Integer.parseInt(name.substring(name.length() - 1));
                        name = name.substring(0, name.length() - 1);
                        isNumbered = true;
                    }
                    catch (NumberFormatException e) {
                        isNum = false;
                    }
                }
                if (!isNumbered) continue;
                ArrayList<String> numbers = (ArrayList<String>)numbered.get(name);
                if (numbers == null) {
                    numbers = new ArrayList<String>();
                    numbered.put(name, numbers);
                }
                numbers.add(oriName);
                Collections.sort(numbers);
            }
            for (i = soundNames.size() - 1; i >= 0; --i) {
                name = (String)soundNames.get(i);
                for (Map.Entry e : numbered.entrySet()) {
                    if (!name.startsWith((String)e.getKey()) || name.equals(e.getKey())) continue;
                    soundNames.remove(i);
                    if (soundNames.contains(e.getKey())) continue;
                    soundNames.add(i, (String)e.getKey());
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append("\n\n");
            sb.append("{\n");
            for (int i2 = 0; i2 < soundNames.size(); ++i2) {
                String name3;
                String oriName = name3 = (String)soundNames.get(i2);
                boolean isRecord = name3.startsWith("records");
                String category = isRecord ? "record" : (name3.contains("wpn_portal") ? "player" : "neutral");
                String ingameName = name3.replaceAll("\\/", ".");
                sb.append("  \"" + ingameName + "\": { \n");
                sb.append("    \"category\": \"" + category + "\",\n");
                sb.append("    \"sounds\": [\n");
                if (isRecord) {
                    sb.append("      {\n");
                    sb.append("        \"name\": \"" + name3 + "\",\n        \"stream\": true\n");
                    sb.append("      }\n");
                } else {
                    ArrayList<String> soundPaths = (ArrayList<String>)numbered.get(oriName);
                    if (soundPaths == null) {
                        soundPaths = new ArrayList<String>();
                        soundPaths.add(name3);
                    }
                    for (int j = 0; j < soundPaths.size(); ++j) {
                        sb.append("      \"" + (String)soundPaths.get(j) + "\"");
                        if (j != soundPaths.size() - 1) {
                            sb.append(",\n");
                            continue;
                        }
                        sb.append("\n");
                    }
                }
                sb.append("    ]\n");
                sb.append("  }");
                if (i2 != soundNames.size() - 1) {
                    sb.append(",\n");
                    continue;
                }
                sb.append("\n");
            }
            sb.append("}");
            System.out.println(sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

