/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.tropicraft.block.BlockTropicraft;
import net.tropicraft.info.TCRenderIDs;
import net.tropicraft.registry.TCItemRegistry;

public class BlockCoffeePlant
extends BlockTropicraft {
    public static final int MAX_HEIGHT = 3;
    public static final int GROWTH_RATE_FERTILE = 10;
    public static final int GROWTH_RATE_INFERTILE = 20;
    public static final int RIPENING_RATE_FERTILE = 12;
    public static final int RIPENING_RATE_INFERTILE = 25;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] leafIcons;
    @SideOnly(value=Side.CLIENT)
    public IIcon stemIcon;

    public BlockCoffeePlant() {
        super(Material.field_151585_k);
        this.func_149675_a(true);
        this.func_149649_H();
        this.func_149647_a(null);
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return TCItemRegistry.coffeeBean;
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.leafIcons[meta &= 7];
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        if (side == 1 && world.func_147439_a(x, y, z) == this) {
            return false;
        }
        if (side == 0 && world.func_147439_a(x, y, z) == this) {
            return false;
        }
        return super.func_149646_a(world, x, y, z, side);
    }

    public boolean func_149662_c() {
        return false;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    private void tryToGrowUpwards(World world, int x, int y, int z, Random random) {
        if (world.func_147437_c(x, y + 1, z)) {
            int height = 1;
            while (world.func_147439_a(x, y - height, z) == this) {
                ++height;
            }
            if (height < 3 && random.nextInt(this.isFertile(world, x, y - height, z) ? 10 : 20) == 0) {
                world.func_147465_d(x, y + 1, z, (Block)this, 0, 2);
            }
        }
    }

    private void tryToRipen(World world, int x, int y, int z, Random random) {
        int meta = world.func_72805_g(x, y, z) & 7;
        if (meta == 7) {
            world.func_72921_c(x, y, z, 6, 2);
            return;
        }
        if (meta == 6) {
            return;
        }
        if (world.func_72957_l(x, y + 1, z) < 9) {
            return;
        }
        if (random.nextInt(this.isFertile(world, x, y - 1, z) ? 12 : 25) != 0) {
            return;
        }
        world.func_72921_c(x, y, z, meta + 1, 2);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (world.field_72995_K) {
            return;
        }
        this.tryToGrowUpwards(world, x, y, z, random);
        this.tryToRipen(world, x, y, z, random);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float offsetX, float offsetY, float offsetZ) {
        if ((world.func_72805_g(x, y, z) & 7) != 6) {
            return false;
        }
        world.func_147465_d(x, y, z, (Block)this, 0, 3);
        ItemStack stack = new ItemStack((Item)TCItemRegistry.coffeeBean, 1, 2);
        this.func_149642_a(world, x, y, z, stack);
        return true;
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return TCItemRegistry.coffeeBean;
    }

    public int func_149692_a(int meta) {
        return 2;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack((Item)TCItemRegistry.coffeeBean, 1, 0);
    }

    public int func_149643_k(World par1World, int par2, int par3, int par4) {
        return 0;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return meta == 6 ? 1 : 0;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        Block soil = world.func_147439_a(x, y - 1, z);
        return !(world.func_72883_k(x, y, z) < 8 && !world.func_72937_j(x, y, z) || soil == null || soil != this && !soil.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)TCItemRegistry.coffeeBean));
    }

    public int func_149645_b() {
        return TCRenderIDs.coffeePlant;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.leafIcons = new IIcon[7];
        for (int i = 0; i < 7; ++i) {
            this.leafIcons[i] = iconRegister.func_94245_a(this.func_149739_a().substring(this.func_149739_a().indexOf(".") + 1) + "_" + i);
        }
        this.stemIcon = iconRegister.func_94245_a(this.func_149739_a().substring(this.func_149739_a().indexOf(".") + 1) + "_" + "Stem");
    }
}

