/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.registry.TCCreativeTabRegistry;
import net.tropicraft.world.worldgen.TCGenBase;
import net.tropicraft.world.worldgen.WorldGenTallTree;
import net.tropicraft.world.worldgen.WorldGenTropicraftCurvedPalm;
import net.tropicraft.world.worldgen.WorldGenTropicraftFruitTrees;
import net.tropicraft.world.worldgen.WorldGenTropicraftLargePalmTrees;
import net.tropicraft.world.worldgen.WorldGenTropicraftNormalPalms;
import net.tropicraft.world.worldgen.WorldGenTualang;
import net.tropicraft.world.worldgen.WorldGenUpTree;

public class BlockTropicraftSapling
extends BlockSapling
implements IGrowable {
    protected String[] names;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] icons;

    public BlockTropicraftSapling(String[] names) {
        this.names = names;
        this.func_149675_a(true);
        this.func_149649_H();
        this.func_149647_a(TCCreativeTabRegistry.tabBlock);
    }

    protected boolean func_149854_a(Block block) {
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak || block == Blocks.field_150354_m || block == TCBlockRegistry.purifiedSand || block == TCBlockRegistry.mineralSands;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            super.func_149674_a(world, x, y, z, rand);
            if (world.func_72957_l(x, y + 1, z) >= 9 && rand.nextInt(7) == 0) {
                this.markOrGrowMarked(world, x, y, z, rand);
            }
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        return null;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149851_a(World p_149851_1_, int p_149851_2_, int p_149851_3_, int p_149851_4_, boolean p_149851_5_) {
        return true;
    }

    public boolean func_149852_a(World p_149852_1_, Random p_149852_2_, int p_149852_3_, int p_149852_4_, int p_149852_5_) {
        return (double)p_149852_1_.field_73012_v.nextFloat() < 0.45;
    }

    public void func_149853_b(World p_149853_1_, Random p_149853_2_, int p_149853_3_, int p_149853_4_, int p_149853_5_) {
        this.markOrGrowMarked(p_149853_1_, p_149853_3_, p_149853_4_, p_149853_5_, p_149853_2_);
    }

    public void markOrGrowMarked(World world, int x, int y, int z, Random rand) {
        TCGenBase.blockGenNotifyFlag = 3;
        int l = world.func_72805_g(x, y, z);
        this.func_149878_d(world, x, y, z, rand);
        TCGenBase.blockGenNotifyFlag = 2;
    }

    public void func_149878_d(World world, int x, int y, int z, Random rand) {
        int type = world.func_72805_g(x, y, z);
        Object gen = null;
        if (type == 0) {
            int b = rand.nextInt(3);
            if (b == 0) {
                gen = new WorldGenTropicraftLargePalmTrees(false);
            } else if (b == 1) {
                gen = new WorldGenTropicraftCurvedPalm(world, rand);
            } else if (b == 2) {
                gen = new WorldGenTropicraftNormalPalms(false);
            }
        } else {
            gen = type == 1 ? this.randomRainforestTreeGen(world) : new WorldGenTropicraftFruitTrees(world, rand, type - 2);
        }
        if (gen != null) {
            world.func_147468_f(x, y, z);
            if (!gen.func_76484_a(world, rand, x, y, z)) {
                world.func_147465_d(x, y, z, (Block)this, type, 3);
            }
        }
    }

    private WorldGenerator randomRainforestTreeGen(World world) {
        Random rand = new Random();
        int type = rand.nextInt(4);
        switch (type) {
            case 0: {
                return new WorldGenTallTree(world, rand);
            }
            case 1: {
                return new WorldGenUpTree(world, rand);
            }
            case 2: 
            case 3: {
                return new WorldGenTualang(world, rand, 18, 9);
            }
        }
        return new WorldGenTualang(world, rand, 25, 10);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int id, int metadata) {
        if (metadata < 0 || metadata > this.names.length - 1) {
            metadata = this.names.length - 1;
        }
        return this.icons[metadata];
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.names.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public String func_149739_a() {
        return String.format("tile.%s%s", "tropicraft:", this.getActualName(super.func_149739_a()));
    }

    protected String getActualName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(46) + 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[this.names.length];
        for (int i = 0; i < this.names.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a(this.func_149739_a().substring(this.func_149739_a().indexOf(".") + 1) + "_" + this.names[i]);
        }
    }
}

