/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.block.tileentity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.tropicraft.item.scuba.ItemScubaGear;
import net.tropicraft.item.scuba.ItemScubaTank;

public class TileEntityAirCompressor
extends TileEntity {
    public boolean compressing;
    private int ticks;
    private static final float fillRate = 0.1f;
    private ItemStack tank;
    private float maxCapacity;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.compressing = nbt.func_74767_n("Compressing");
        this.ticks = nbt.func_74762_e("Ticks");
        if (nbt.func_74764_b("Tank")) {
            this.tank = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Tank"));
            this.maxCapacity = this.tank.func_77960_j() == 1 ? (float)ItemScubaGear.AirType.TRIMIX.getMaxCapacity() : (float)ItemScubaGear.AirType.REGULAR.getMaxCapacity();
        } else {
            this.tank = null;
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("Compressing", this.compressing);
        nbt.func_74768_a("Ticks", this.ticks);
        if (this.tank != null) {
            NBTTagCompound var4 = new NBTTagCompound();
            this.tank.func_77955_b(var4);
            nbt.func_74782_a("Tank", (NBTBase)var4);
        }
    }

    public void func_145845_h() {
        if (this.tank == null) {
            return;
        }
        float airContained = this.getTagCompound(this.tank).func_74760_g("AirContained");
        if (this.compressing && airContained < (float)ItemScubaGear.AirType.REGULAR.getMaxCapacity()) {
            if (airContained + 0.1f >= (float)ItemScubaGear.AirType.REGULAR.getMaxCapacity()) {
                this.tank.func_77978_p().func_74776_a("AirContained", (float)ItemScubaGear.AirType.REGULAR.getMaxCapacity());
                ++this.ticks;
                this.finishCompressing();
            } else {
                this.tank.func_77978_p().func_74776_a("AirContained", airContained + 0.1f);
                ++this.ticks;
            }
        }
    }

    public NBTTagCompound getTagCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void sync() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, nbttagcompound);
    }

    public boolean addTank(ItemStack stack) {
        if (this.tank == null && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemScubaTank) {
            this.tank = stack;
            this.compressing = true;
            this.sync();
            return true;
        }
        return false;
    }

    public void ejectTank() {
        if (this.tank != null) {
            EntityItem tankItem = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, this.tank);
            this.field_145850_b.func_72838_d((Entity)tankItem);
            this.tank = null;
        }
        this.ticks = 0;
        this.compressing = false;
        this.sync();
    }

    public boolean isDoneCompressing() {
        return this.ticks > 0 && !this.compressing;
    }

    public float getTickRatio() {
        return (float)this.ticks / ((float)ItemScubaGear.AirType.REGULAR.getMaxCapacity() * 0.1f);
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void startCompressing() {
        this.compressing = true;
        this.sync();
    }

    public void finishCompressing() {
        this.compressing = false;
        this.sync();
    }
}

