/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.client.renderer.item;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.IItemRenderer;
import net.tropicraft.item.scuba.ItemScubaChestplateGear;
import net.tropicraft.util.TropicraftUtils;
import org.lwjgl.opengl.GL11;

public class ItemDiveComputerRenderer
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        EntityPlayer player = (EntityPlayer)data[0];
        TextureManager textureManager = (TextureManager)data[1];
        MapData mapData = (MapData)data[2];
        ItemStack chestplate = player.func_71124_b(3);
        if (chestplate == null || !(chestplate.func_77973_b() instanceof ItemScubaChestplateGear)) {
            return;
        }
        float airRemaining = this.getTagCompound(chestplate).func_74762_e("AirRemaining");
        int currentDepth = MathHelper.func_76128_c((double)player.field_70163_u);
        int maxDepth = this.getTagCompound(chestplate).func_74762_e("MaxDepth");
        airRemaining = chestplate.func_77978_p().func_74760_g("AirContained");
        int blocksAbove = chestplate.func_77978_p().func_74762_e("WaterBlocksAbove");
        int blocksBelow = chestplate.func_77978_p().func_74762_e("WaterBlocksBelow");
        ItemScubaChestplateGear gear = (ItemScubaChestplateGear)chestplate.func_77973_b();
        float timeRemaining = airRemaining / gear.getAirType(chestplate).getUsageRate();
        String timeUnits = timeRemaining <= 60.0f ? "secs" : "mins";
        timeRemaining = timeRemaining <= 60.0f ? timeRemaining : timeRemaining / 60.0f;
        float airTemp = player.field_70170_p.func_72807_a((int)MathHelper.func_76128_c((double)player.field_70165_t), (int)MathHelper.func_76128_c((double)player.field_70161_v)).field_76750_F;
        int width = Minecraft.func_71410_x().field_71443_c;
        int height = Minecraft.func_71410_x().field_71440_d;
        float yaw = player.field_70177_z;
        int heading = MathHelper.func_76128_c((double)((double)(yaw * 4.0f / 360.0f) + 0.5)) & 3;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        textureManager.func_110577_a(TropicraftUtils.getTextureGui("diveComputerBackground"));
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        tessellator.func_78382_b();
        int b0 = 16;
        int other = 140;
        tessellator.func_78374_a((double)(0 - b0), (double)(other + b0), 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)(other + b0), (double)(other + b0), 0.0, 1.0, 1.0);
        tessellator.func_78374_a((double)(other + b0), (double)(0 - b0), 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)(0 - b0), (double)(0 - b0), 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glPushMatrix();
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScalef((float)0.45f, (float)0.45f, (float)1.0f);
        GL11.glTranslatef((float)150.0f, (float)150.0f, (float)0.0f);
        GL11.glRotatef((float)(yaw + 180.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
        textureManager.func_110577_a(TropicraftUtils.getTextureGui("compassBackground"));
        tessellator.func_78382_b();
        int offset = -75;
        other = 150;
        tessellator.func_78374_a((double)(0 + offset), (double)(other + offset), 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)(other + offset), (double)(other + offset), 0.0, 1.0, 1.0);
        tessellator.func_78374_a((double)(other + offset), (double)(0 + offset), 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)(0 + offset), (double)(0 + offset), 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)1.3f, (float)1.3f, (float)1.0f);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(String.format("%.0f", Float.valueOf(airRemaining)), 70, 14, 52446);
        this.drawString(blocksAbove, 46, 79, 0xBBBBFF);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.6f, (float)0.6f, (float)1.0f);
        this.drawString(String.format("%.0f %s", Float.valueOf(timeRemaining), timeUnits), 29, 30, 16182034);
        this.drawString(TropicraftUtils.translateGUI("maxDepth") + ": " + maxDepth, 194, 150, -1);
        this.drawString(airTemp + " F", 6, 150, -1);
        GL11.glPopMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        this.drawString("psi", 245, 47, 0xFFFFFF);
        this.drawString("Air", 206, 24, 0xFFFFFF);
        this.drawString(TropicraftUtils.translateGUI("timeRemaining"), 34, 24, 0xFFFFFF);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private boolean isFullyUnderwater(EntityPlayer player) {
        int x = MathHelper.func_76143_f((double)player.field_70165_t);
        int y = MathHelper.func_76143_f((double)(player.field_70163_u + (double)player.field_70131_O - (double)2.3f));
        int z = MathHelper.func_76143_f((double)player.field_70161_v);
        return player.field_70170_p.func_147439_a(x, y, z).func_149688_o().func_76224_d();
    }

    public NBTTagCompound getTagCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    private void drawString(Object text, int x, int y, int color) {
        Minecraft.func_71410_x().field_71466_p.func_78276_b(String.valueOf(text), x, y, color);
    }
}

