/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.drinks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.tropicraft.drinks.Drink;
import net.tropicraft.drinks.Ingredient;
import net.tropicraft.drinks.MixerRecipe;
import net.tropicraft.registry.TCDrinkMixerRegistry;

public final class MixerRecipes {
    private static Map<Drink, Ingredient[]> drinkToIngredientsMap = new HashMap<Drink, Ingredient[]>();

    private MixerRecipes() {
    }

    public static void addMixerRecipes() {
        MixerRecipes.registerMixerRecipe(Drink.limeade, Ingredient.lime, Ingredient.sugar, Ingredient.waterBucket);
        MixerRecipes.registerMixerRecipe(Drink.caipirinha, Ingredient.lime, Ingredient.sugarcane, Ingredient.waterBucket);
        MixerRecipes.registerMixerRecipe(Drink.orangeade, Ingredient.orange, Ingredient.sugar, Ingredient.waterBucket);
        MixerRecipes.registerMixerRecipe(Drink.lemonade, Ingredient.lemon, Ingredient.sugar, Ingredient.waterBucket);
        MixerRecipes.registerMixerRecipe(Drink.blackCoffee, Ingredient.roastedCoffeeBean, Ingredient.waterBucket);
        MixerRecipes.registerMixerRecipe(Drink.pinaColada, Ingredient.pineapple, Ingredient.coconutChunk);
        MixerRecipes.registerMixerRecipe(Drink.pinaColada, Ingredient.pineappleChunks, Ingredient.coconut);
    }

    private static void registerMixerRecipe(Drink result, Ingredient ... ingredients) {
        TCDrinkMixerRegistry.getInstance().registerRecipe(new MixerRecipe(result, ingredients));
        drinkToIngredientsMap.put(result, ingredients);
    }

    public static ItemStack getItemStack(Drink drink) {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        for (Ingredient i : drinkToIngredientsMap.get(drink)) {
            stack.add(i.getIngredient());
        }
        return TCDrinkMixerRegistry.getInstance().getResult(stack.toArray(new ItemStack[stack.size()]));
    }
}

